/* This file extracted from the GTK tutorial.

   It could be used to create menu factories and key bindings
   It currently is used for keys binding only
*/

#include "gxedit.h"
#ifndef GTK_1_1
#include <strings.h>


static void menus_remove_accel(GtkWidget * widget, gchar * signal_name, gchar * path);
static gint menus_install_accel(GtkWidget * widget, gchar * signal_name, gchar key, gchar modifiers, gchar * path);
void menus_init(void);
void menus_create(GtkMenuEntry * entries, int nmenu_entries);

static GtkMenuEntry menu_items[] =
{
 {"<Main>/Key1", "<control>N", CB_new, NULL},
 {"<Main>/Key2", "<control>O", CB_open, NULL},
 {"<Main>/Key3", "<control>S", CB_save, NULL},
 {"<Main>/Key4", "<control>E", CB_saveas, NULL},
 {"<Main>/Key6", "<control>Q", CB_exit, NULL},
 {"<Main>/Key7", "<control>X", CB_exit, NULL},
 {"<Main>/Key8", "<control>C", CB_copy, NULL},
 {"<Main>/Key9", "<control>V", CB_paste, NULL},
 {"<Main>/Key10", "<control>F", CB_find, NULL},
 {"<Main>/Key11", "<control>H", CB_help, NULL},
 {"<Main>/Key12", "<control>T", CB_settings, NULL},
 {"<Main>/Key13", "<control>I", CB_spell, NULL},
 {"<Main>/Key14", "<control>A", CB_awk, NULL},
 {"<Main>/Key15", "<control>R", CB_run, NULL},
 {"<Main>/Key16", "<control>L", CB_lines_count, NULL},
 {"<Main>/Key17", "<control>W", CB_words_count, NULL},
 {"<Main>/Key18", "<control>B", CB_bytes_count, NULL},
 {"<Main>/Key19", "<control>G", CB_find_again, NULL},
 {"<Main>/Key20", "<control>D", CB_indent, NULL},
 {"<Main>/Key21", "<control>-", CB_indent_minus, NULL},
 {"<Main>/Key22", "<control>+", CB_indent_plus, NULL},
 {"<Main>/Key23", "<control>=", CB_indent_plus, NULL},
 {"<Main>/Key24", "<control>M", CB_mark, NULL}
};

/* calculate the number of menu_item's */
static int nmenu_items = sizeof(menu_items) / sizeof(menu_items[0]);

static int initialize = TRUE;
static GtkMenuFactory *factory = NULL;
static GtkMenuFactory *subfactory[1];
static GHashTable *entry_ht = NULL;

void get_main_menu(GtkWidget ** menubar, GtkAcceleratorTable ** table)
{
    if (initialize)
	    menus_init();
    
    if (menubar)
	    *menubar = subfactory[0]->widget;
    if (table)
	    *table = subfactory[0]->table;
}

void menus_init(void)
{
    if (initialize) {
	initialize = FALSE;
	
	factory = gtk_menu_factory_new(GTK_MENU_FACTORY_MENU_BAR);
	subfactory[0] = gtk_menu_factory_new(GTK_MENU_FACTORY_MENU_BAR);
	
	gtk_menu_factory_add_subfactory(factory, subfactory[0], "<Main>");
	menus_create(menu_items, nmenu_items);
    }
}

void menus_create(GtkMenuEntry * entries, int nmenu_entries)
{
    char *accelerator;
    int i;
    
    if (initialize)
	    menus_init();
    
    if (entry_ht)
	    for (i = 0; i < nmenu_entries; i++) {
		accelerator = g_hash_table_lookup(entry_ht, entries[i].path);
		if (accelerator) {
		    if (accelerator[0] == '\0')
			    entries[i].accelerator = NULL;
		    else
			    entries[i].accelerator = accelerator;
		}
	    }
    gtk_menu_factory_add_entries(factory, entries, nmenu_entries);
    
    for (i = 0; i < nmenu_entries; i++)
	    if (entries[i].widget) {
		gtk_signal_connect(GTK_OBJECT(entries[i].widget), "install_accelerator",
				   (GtkSignalFunc) menus_install_accel,
				   entries[i].path);
		gtk_signal_connect(GTK_OBJECT(entries[i].widget), "remove_accelerator",
				   (GtkSignalFunc) menus_remove_accel,
				   entries[i].path);
	    }
}

static gint menus_install_accel(GtkWidget * widget, gchar * signal_name, gchar key, gchar modifiers, gchar * path)
{
    char accel[64];
    char *t1, t2[2];
    
    accel[0] = '\0';
    if (modifiers & GDK_CONTROL_MASK)
	    strcat(accel, "<control>");
    if (modifiers & GDK_SHIFT_MASK)
	    strcat(accel, "<shift>");
    if (modifiers & GDK_MOD1_MASK)
	    strcat(accel, "<alt>");
    
    t2[0] = key;
    t2[1] = '\0';
    strcat(accel, t2);
    
    if (entry_ht) {
	t1 = g_hash_table_lookup(entry_ht, path);
	g_free(t1);
    } else
	    entry_ht = g_hash_table_new(g_str_hash, g_str_equal);
    
    g_hash_table_insert(entry_ht, path, g_strdup(accel));
    
    return TRUE;
}

static void menus_remove_accel(GtkWidget * widget, gchar * signal_name, gchar * path)
{
    char *t;
    
    if (entry_ht) {
	t = g_hash_table_lookup(entry_ht, path);
	g_free(t);
	
	g_hash_table_insert(entry_ht, path, g_strdup(""));
    }
}

void menus_set_sensitive(char *path, int sensitive)
{
    GtkMenuPath *menu_path;
    
    if (initialize)
	    menus_init();
    
    menu_path = gtk_menu_factory_find(factory, path);
    if (menu_path)
	    gtk_widget_set_sensitive(menu_path->widget, sensitive);
    else
	    g_warning("Unable to set sensitivity for menu which doesn't exist: %s", path);
}
#endif
