;;; dtk-interp.el --- Language specific (e.g. TCL) interface to speech server
;;; $Id: dtk-interp.el,v 8.0 1998/05/01 14:15:46 raman Exp $
;;; $Author: raman $ 
;;; Description:  Interfacing to the speech server
;;; Keywords: Dectalk, Speech Server
;;{{{  LCD Archive entry: 

;;; LCD Archive Entry:
;;; emacspeak| T. V. Raman |raman@adobe.com 
;;; A speech interface to Emacs |
;;; $Date: 1998/05/01 14:15:46 $ |
;;;  $Revision: 8.0 $ | 
;;; Location undetermined
;;;

;;}}}
;;{{{  Copyright:

;;;Copyright (C) 1995, 1996, 1997, 1998   T. V. Raman  Adobe Systems Incorporated
;;; All Rights Reserved. 
;;;
;;; This file is not part of GNU Emacs, but the same permissions apply.
;;;
;;; GNU Emacs is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; GNU Emacs is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Emacs; see the file COPYING.  If not, write to
;;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;}}}
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(require 'cl)
(declaim  (optimize  (safety 0) (speed 3)))
;;{{{ introduction

;;; All requests to the speech server are factored out into
;;; this module.
;;; These calls are declared here as defsubst so they are
;;; inlined by the byte compiler.
;;; This preserves the same level of efficiency as before,
;;; but gives us the flexibility to call out to different
;;; speech servers.

;;}}}
;;{{{ silence

(defsubst dtk-interp-silence (duration force)
  (declare (special dtk-speaker-process))
  (process-send-string dtk-speaker-process
                       (format "sh %d%s\n"
                               duration
                               (if force "\nd" ""))))

;;}}}
;;{{{  tone

(defsubst dtk-interp-tone (pitch duration &optional force)

  (process-send-string dtk-speaker-process
                       (format "t %d %d%s\n"
                               pitch duration
                               (if force "\nd" "")))(declare (special dtk-speaker-process)))

;;}}}
;;{{{  queue 

(defsubst dtk-interp-queue (text)
  (declare (special dtk-speaker-process))
  (process-send-string dtk-speaker-process
                       (format "q {%s }\n"
                               text)))

(defsubst dtk-interp-queue-set-rate(rate)
  (declare (special dtk-speaker-process))
  (process-send-string dtk-speaker-process
                       (format "r {%s}\n" rate)))

;;}}}
;;{{{  speak

(defsubst dtk-interp-speak ()
  (declare (special dtk-speaker-process))
  (process-send-string dtk-speaker-process
                            "d\n"))

;;}}}
;;{{{ say

(defsubst dtk-interp-say (string)
  (declare (special dtk-speaker-process))
  (process-send-string dtk-speaker-process
                              (format  "tts_say { %s}\n"
                                       string )))

;;}}}
;;{{{ dispatch

;;;synonym for above in current server:
(defsubst dtk-interp-dispatch (string)
  (declare (special dtk-speaker-process))
  (process-send-string dtk-speaker-process
                              (format  "tts_say { %s}\n"
                                       string )))

;;}}}
;;{{{ stop

(defsubst dtk-interp-stop ()
  (declare (special dtk-speaker-process))
  (process-send-string dtk-speaker-process
                       (format "s\n" )))

;;}}}
;;{{{ sync

(defsubst dtk-interp-sync()
  (declare (special dtk-speaker-process
                    dtk-punctuation-mode dtk-speech-rate dtk-character-scale
                    dtk-capitalize dtk-split-caps
                    dtk-allcaps-beep))
  (let ((command (concat 
                  (format "tts_set_punctuations %s  \n "
                          dtk-punctuation-mode )
                  (format "tts_capitalize %s \n "
                          (if dtk-capitalize 1  0 ))
                  (format "tts_allcaps_beep %s \n "
                          (if dtk-allcaps-beep 1  0 ))
                  (format "tts_split_caps  %s \n "
                          (if dtk-split-caps 1 0 ))
                  (format "tts_set_speech_rate %s \n" dtk-speech-rate)
                  (format "tts_set_character_scale %s \n "
                          dtk-character-scale))))
    (process-send-string dtk-speaker-process command )))

;;}}}
;;{{{  letter

(defsubst dtk-interp-letter (letter)
  (declare (special dtk-speaker-process))
  (process-send-string dtk-speaker-process
                       (format "l {%s}\n" letter )))

;;}}}
;;{{{  rate

(defsubst dtk-interp-set-rate (rate)
  (declare (special dtk-speaker-process))
  (process-send-string dtk-speaker-process
                         (format "tts_set_speech_rate %s\n"
                                 rate)))

;;}}}
;;{{{ character scale

(defsubst dtk-interp-set-character-scale (factor)
  (declare (special dtk-speaker-process))
  (process-send-string dtk-speaker-process
                       (format "tts_set_character_scale %s\n"
                               factor)))

;;}}}
;;{{{  split caps 

(defsubst dtk-interp-toggle-split-caps (dtk-split-caps)
  (declare (special dtk-speaker-process))
  (process-send-string dtk-speaker-process
                       (format "tts_split_caps %s\n"
                               (if dtk-split-caps 1 0 ))))

;;}}}
;;{{{ capitalization

(defsubst dtk-interp-toggle-capitalization (dtk-capitalize)
  (declare (special dtk-speaker-process))
  (process-send-string dtk-speaker-process 
                       (format "tts_capitalize  %s\n"
                               (if dtk-capitalize  1 0 ))))

;;}}}
;;{{{ allcaps beep

(defsubst dtk-interp-toggle-allcaps-beep  (dtk-allcaps-beep)
  (declare (special dtk-speaker-process))
  (process-send-string dtk-speaker-process 
                         (format "tts_allcaps_beep  %s\n"
                                 (if dtk-allcaps-beep  1 0
                                     ))))

;;}}}
;;{{{ punctuations

(defsubst dtk-interp-set-punctuations(mode)
  (declare (special dtk-speaker-process))
  (process-send-string dtk-speaker-process  
                         (format "tts_set_punctuations %s\n"
                                 mode)))

;;}}}
;;{{{ reset

(defsubst dtk-interp-reset-state ()
  (declare (special dtk-speaker-process))
  (process-send-string dtk-speaker-process
                         (format "tts_reset \n")))

;;}}}
;;{{{ pause

(defsubst dtk-interp-pause ()
  (declare (special dtk-speaker-process))
  (process-send-string dtk-speaker-process
                       "tts_pause\n"))

;;}}}
;;{{{ resume

(defsubst dtk-interp-resume ()
  (declare (special dtk-speaker-process))
  (process-send-string dtk-speaker-process
                       "tts_resume\n"))

;;}}}

(provide 'dtk-interp)
;;{{{  local variables

;;; local variables:
;;; folded-file: t
;;; end: 

;;}}}
