
;; the toolkit restricts operation to a single display
;; the glue layer should not have that restriction

(define *X-display* #f)

(define *X-root-window* #f)
(define *X-default-depth* #f)

;; the toolkit also requires at least 4 grays (NeXT)

(define *baseline-colors* (vector #f #f #f #f))

(define *application-colors* *baseline-colors*)

(define (X-init)
  (if (not *X-display*)
      (real-X-init))
  (values))

(define (real-X-init)
  (let ((d (open-display (getenv "DISPLAY"))))
    (if (not d)
	(error "X-init: could not open display `~a'\n" 
	       (getenv "DISPLAY")))
    (let ((v (alloc-colors d 2)))
      (if (not v)
	  (error "X-init: could not allocate colors\n"))
      (set! *X-display* d)
      (set! *X-root-window* (make <X-window>
				  x-display-ptr: (x-display-ptr *X-display*)
				  x-display: *X-display*
				  xid: (x-display-default-root-window 
					*X-display*)
				  local-object: #f))
      (set! *X-default-depth* 8)  ;; a HACK
      (vector-set! *baseline-colors* 0 (black-pixel *X-display*))
      (vector-set! *baseline-colors* 3 (white-pixel *X-display*))
      (vector-set! *baseline-colors* 1 (vector-ref v 0))
      (vector-set! *baseline-colors* 2 (vector-ref v 1))
      (assign-color *X-display* (vector-ref v 0) "DimGray")
      (assign-color *X-display* (vector-ref v 1) "LightGray")
      (let ((c *application-colors*))
	(let-syntax ((fix-color (syntax-form (n)
				  (set! n (vector-ref c n)))))
	  (fix-color *black*)
	  (fix-color *white*)
	  (fix-color *light*)
	  (fix-color *dark*)
	  (fix-color *std-window-foreground*)
	  (fix-color *std-window-background*)))
      ;; return nothing...
      (values))))


