
(define-class <lss> (<object>)
  raw-lss-ptr
  path)

(define-rstore-glue (open-lss (path <raw-string>)
			      (mode <raw-int>)
			      (commit_seg_num <raw-int>)
			      (commit_in_seg <raw-int>))
  literals: ((& error) 
	     (& <lss>)
	     "open-lss: couldn't open ~s")
{
  LSS *s = lss_open( path, mode, 
		     plain_lss_error_handler, NULL, 
		     (commit_seg_num << 16) + commit_in_seg );
  if (s)
    {
      REG0 = make2( TLREF(1), RAW_PTR_TO_OBJ(s), raw_path );
      RETURN1();
    }
  else
    {
      REG0 = LITERAL(2);
      REG1 = raw_path;
      APPLY(2,TLREF(0));
    }
})

(define-rstore-glue (close-lss (self <lss>))
{
  lss_close( self );
  RETURN0();
})

(define-rstore-glue (lss-read-record (self <lss>) (rec_num <raw-int>))
{
  access_t a;

  lss_access( self, rec_num, &a );
  REG0 = bvec_alloc( a.bytes, byte_vector_class );
  memcpy( PTR_TO_DATAPTR(REG0), a.addr, a.bytes );
  lss_release( self, &a );
  RETURN1();
})

(define-rstore-glue (lss-write-record (self <lss>) 
		     (rec_num <raw-int>)
		     (data <byte-vector>))
{
  lss_write( self, rec_num, PTR_TO_DATAPTR(data), SIZEOF_PTR(data) );
  RETURN0();
})

(define-rstore-glue (lss-client-commit-info (self <lss>))
{
  UINT_32 len;
  void *p = lss_get_client_commit_info( self, &len );

  REG0 = alloc( len, byte_vector_class );
  memcpy( PTR_TO_DATAPTR(REG0), p, len );
  RETURN1();
})

(define-rstore-glue (lss-commit (self <lss>) (client_info <byte-vector>))
{
  lss_commit( self, 
	      PTR_TO_DATAPTR(client_info),
	      SIZEOF_PTR(client_info) );
  RETURN0();
})

(define-rstore-glue (lss-commit-info (self <lss>))
  literals: ((& <time>))
{
  commit_info_t ci;

  lss_get_lss_commit_info( self, &ci );

  REG0 = int2fx( ci.commit_version );
  REG1 = make_time_sec( ci.commit_time, TLREF(0) );
  REG2 = make_time_sec( ci.create_time, TLREF(0) );
  REG3 = cons( int2fx( ci.prev_commit_at >> 16 ),
	       int2fx( ci.prev_commit_at & 0xFFFF ) );
  REG4 = cons( int2fx( self->spare_commit_at >> 16 ),
	       int2fx( self->spare_commit_at & 0xFFFF ) );
  RETURN(5);
})

(define (lss-for-each-record (self <lss>) proc)
  (lss-for-each-record* self
			(lambda (recnum offset len)
			  (proc recnum))))

;; call the given procedure with the entries from the record index.
;; for each record, proc is called with:
;;  [0] the record number
;;  [1] pstore offset
;;  [2] length

(define-rstore-glue (lss-for-each-record* (self <lss>) proc)
{
  UINT_32 i;

  for (i=0; i<self->index_capacity; i++)
    {
      if (self->index[i].number)
	{
	  REG2 = int2fx(i);
	  JUMP(3,lss_foreachf_1);
	}
    }
  /* no records! */
  RETURN0();
}

("lss_foreachf_1"
{
  LSS *self = (LSS *)OBJ_TO_RAW_PTR(gvec_ref(REG0,SLOT(0)));
  UINT_32 j, i = fx2int(REG2);
  obj the_proc = REG1;

  /* find the next one */

  for (j = i+1; j < self->index_capacity; j++)
    {
      if (self->index[j].number)
	{
	  REG2 = int2fx(j);
	  SAVE_CONT3(lss_foreachf_2);
	  REG0 = int2fx(self->index[i].number);
	  REG1 = int2fx(self->index[i].offset);
	  REG2 = int2fx(self->index[i].length);
	  APPLY( 3, the_proc );
	}
    }
  /* no more left -- call proc in tail position */
  REG0 = int2fx( self->index[i].number );
  REG1 = int2fx( self->index[i].offset );
  REG2 = int2fx( self->index[i].length );
  APPLY( 3, the_proc );
})

("lss_foreachf_2"
{
  RESTORE_CONT3();
  JUMP(3,lss_foreachf_1);
}))
