#|------------------------------------------------------------*-Scheme-*--|
 | File:    compiler/target.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.9
 | File mod date:    1997.11.29 23:10:29
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  (rsc)
 |
 `------------------------------------------------------------------------|#


(define-class <<target-class>> (<object>)
  class-name
  heap-type
  image-mode
  superclasses
  (class-category type: <fixnum> init-value: 0)
  (class-hash type: <fixnum> init-value: 0)
  ;;
  direct-slots
  all-slots
  instance-size
  corresponding-primtype
  class-precedence-list
  (spare-0 init-keyword: #f getter: #f setter: #f init-value: #f)
  (spare-1 init-keyword: #f getter: #f setter: #f init-value: #f)
  (spare-2 init-keyword: #f getter: #f setter: #f init-value: #f)
  (spare-3 init-keyword: #f getter: #f setter: #f init-value: #f)
  (spare-4 init-keyword: #f getter: #f setter: #f init-value: #f))

(add-mifio-class "<<standard-class>>" <<target-class>>)

;; the variable <<target-class>> is defined as a regular variable in
;; modules/compiler/classes.scm; we need to make it a constant...

(set-write-prot! (& <<target-class>>) #t)

;;;

(define-class <target-function> (<object>)
  template)

(define-class <target-closure> (<target-function>)
  environment)

(define-class <target-method> (<target-closure>)
  function-specializers
  (sync-method init-value: #f))

(define-class <target-gf> (<target-function>)
  generic-function-methods
  function-specializers
  generic-function-name
  (gf-cache-0-k init-value: #f)      (gf-cache-0-v init-value: #f) ;; [4 5]
  (gf-cache-1-k init-value: #f)      (gf-cache-1-v init-value: #f) ;; [6 7]
  (gf-cache-2-k init-value: #f)      (gf-cache-2-v init-value: #f) ;; [8 9]
  (gf-cache-3-k init-value: #f)      (gf-cache-3-v init-value: #f) ;; [10 11]
  (gf-cache-V-k init-value: #f)      (gf-cache-V-v init-value: #f) ;; [12 13]
  (gf-cache-overflow init-value: #f)
  (miss-count type: <fixnum> init-value: 0))

(add-mifio-class "<function>" <target-function>)
(add-mifio-class "<closure>" <target-closure>)
(add-mifio-class "<method>" <target-method>)
(add-mifio-class "<generic-function>" <target-gf>)

;;;

(define-class <target-slot-method> (<target-method>)
  (index type: <fixnum>)
  type-restriction ;; a <<target-class>> or a <patch>
  (slot-descriptor type: <slot-descriptor>))

(define-class <target-getter> (<target-slot-method>))

(define-class <target-setter> (<target-slot-method>))

(add-mifio-class "<getter>" <target-getter>)
(add-mifio-class "<setter>" <target-setter>)

#|
(define $target-classes (list <<target-class>>
			      <target-getter>
			      <target-setter>))
|#
;;;

(define-syntax (target-class? o)
  (instance? o <<target-class>>))

;;;

;; class introspection

;; return a list of all the class's <slot-descriptor>'s (including inherited)

(define (tclass-slots c)
  (if (null? (tclass-supers c))
      (tclass-direct-slots c)
      (append (tclass-slots (car (tclass-supers c)))
	      (tclass-direct-slots c))))

(define (tclass-supers c)
  (superclasses (actual-value c)))

(define (tclass-direct-slots c)
  (direct-slots (actual-value c)))

(define (tclass-precedence-list (c <<target-class>>))
  (if (null? (superclasses c))
      (list c)
      (cons c (tclass-precedence-list (car (superclasses c))))))

(define (target-expr-value expr lex-envt dyn-envt)
  (let ((ic (compile expr lex-envt dyn-envt 'value)))
    (if (compile-time-const? ic)
	(compile-time-const-value ic)
	(error "~s: not a constant expression" expr))))

(define (method-dispatch-class (m <target-method>))
  (car (function-specializers m)))

(define (find-method-by-class (gf <target-gf>) class)
  (let loop ((i (generic-function-methods gf)))
    (if (pair? i)
	(if (target-subclass? class (method-dispatch-class (car i)))
	    (car i)
	    (loop (cdr i)))
	#f)))

(define-method write-object ((self <<target-class>>) port)
  (format port "#[<<target-class>> ~s]" (class-name self)))
