// FILE:        BufFileInput.cpp
// AUTHOR:      Alexey Demakov (AVD) demakov@kazbek.ispras.ru
// CREATION:    26-JAN-1998
// DESCRIPTION: File Input Stream with lookahead for Scanner.
//   See file BufFileInput.h for details

#include "tokens.h"
#include "BufFileInput.h"
#include <assert.h>
#include <string.h>

BufFileInput::BufFileInput( FILE *f, int buf_size )
: input( f ),
  start( 0 ),
  len( 0 ),
  buf( new int[buf_size] ),
  size( buf_size )
{
}

int BufFileInput::nextChar( void )
{
    if( len > 0 )
    {
        // get char from buffer
        int c = buf[start];

        if( c != EOF )
        {
            start++; start %= size;
            len--;
        }
        return c;
    } else {
        // get char from file
        int c = getc( input );

        if( c == EOF )
        {
            // if EOF - put it in the buffer as indicator
            buf[start] = EOF;
            len++;
        }
        return c;
    }
}

int BufFileInput::lookahead( char* s )
{
    int l = strlen( s );

    assert( 0 < l && l <= size );

    while( len < l )
    {
        int c = getc( input );

        buf[ (start+len) % size ] = c;

        len++;

        if( c == EOF ) return 0;
    }

    for( int i = 0; i < l; i++ )
    {
        if( s[i] != buf[ (start+i) % size ] ) return 0;
    }
    return 1;
}

// End of file BufFileInput.cpp

