/*
 * SXPDBF.C - PDB find functionality in SX
 *
 * Source Version: 3.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
 
#include "sx.h"

static char
 TYPE[10];

void
 SC_DECLARE(_SX_find_data,
         (HASHTAB *type_table, PDBfile *file, byte *vr, 
          long nitems, char *type)), 
 SC_DECLARE(_SX_find_indirection,
         (HASHTAB *type_table, PDBfile *file, char **vr, 
          long nitems, char *type)), 
 SC_DECLARE(_SX_find_leaf,
         (HASHTAB *type_table, PDBfile *file, char *vr, 
          long nitems, char *type));

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_FIND_TYPES - find all types used by this variable */

object *SX_find_types(arg)
   object *arg;
   {char *type;
    long nitems;
    byte *vr;
    HASHTAB *type_table;
    object *args, *obj;
    PDBfile *file;
    syment *ep;

    if (!SX_PDBDATAP(arg))
       SS_error("MUST BE PDBDATA - SX_FIND_TYPES", arg);

    file   = PDBDATA_FILE(arg);
    ep     = PDBDATA_EP(arg);
    vr     = PDBDATA_DATA(arg);
    type   = PD_entry_type(ep);
    nitems = PD_entry_number(ep);

/* create a hash table to put all of these types in */
    type_table = SC_make_hash_table(HSZSMALL, NODOC);
    strcpy(TYPE, "type");

/* fill the hash table with the types */
    _SX_find_data(type_table, file, vr, nitems, type);

/* convert table to list */
    args = SS_mk_cons(SS_mk_hash_table(type_table), 
                      SS_null);
    obj = SS_hash_dump(args);

/* delete hash table */
    SC_hash_clr(type_table);

    return(obj);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_FIND_DATA - locate part of a data element */

void _SX_find_data(type_table, file, vr, nitems, type)
   HASHTAB *type_table;
   PDBfile *file;
   byte *vr;
   long nitems;
   char *type;
   {

/* if the type is an indirection, follow the pointer */
    if (_PD_indirection(type))
       _SX_find_indirection(type_table, file, (char **) vr, nitems, type);
    else
       _SX_find_leaf(type_table, file,  vr, nitems, type);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_FIND_INDIRECTION - locate part of a data element thru indirection */

void _SX_find_indirection(type_table, file, vr, nitems, type)
   HASHTAB *type_table;
   PDBfile *file;
   char **vr;
   long nitems;
   char *type;
   {long i, ditems;
    char *dtype, bf[MAXLINE];

    dtype = PD_dereference(SC_strsavef(type,
                           "char*:_SX_FIND_INDIRECTION:dtype"));

    for (i = 0L; i < nitems; i++, vr++)
        {ditems = _PD_number_refd(DEREF(vr), dtype, file->host_chart);

         if (ditems == -1L)
            {sprintf(bf, 
                     "CAN'T GET POINTER LENGTH ON %s - _SX_FIND_INDIRECTION", 
                     dtype);
             SS_error(bf, SS_null);};

         if (ditems == -2L)
            {sprintf(bf, 
                     "UNKNOW TYPE %s - _SX_FIND_INDIRECTION", 
                     dtype);
             SS_error(bf, SS_null);};

/* if the type is an indirection, follow the pointer */
         if (_PD_indirection(dtype))
            _SX_find_indirection(type_table, file, (char **) DEREF(vr), 
                                 ditems, dtype);
         else
            _SX_find_leaf(type_table, file, DEREF(vr), ditems, dtype);};

    SFREE(dtype);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_FIND_LEAF - if 'type' is a primitive type, display the data, 
 *               - otherwise, lookup the type, and display each member.
 */

void _SX_find_leaf(type_table, file, vr, nitems, type)
   HASHTAB *type_table;
   PDBfile *file;
   char *vr;
   long nitems;
   char *type;
   {long i, sz;
    char *svr;
    defstr *defp;
    HASHTAB *tab;
    memdes *desc, *mem_lst;

    tab = file->host_chart;

/* print out the type */
    defp = PD_inquire_table_type(tab, type);
    if (defp == NULL)
       SS_error("VARIABLE NOT IN STRUCTURE CHART - _SX_FIND_LEAF", SS_null);

    mem_lst = defp->members;
    if (mem_lst != NULL)
       {SC_install(type, TYPE, TYPE, type_table);
	sz  = defp->size;
	svr = vr;
        for (i = 0L; i < nitems; i++, svr += sz)
            {if (pdb_wr_hook != NULL)
                mem_lst = (*pdb_wr_hook)(file, svr, defp);

             for (desc = mem_lst; desc != NULL; desc = desc->next)
                 {_SX_find_data(type_table, file,
				(char *) (svr + desc->member_offs), 
                                desc->number, desc->type);};};};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
