; 
; SXPDB.SCM - test all PDB functions in SX
;
;  4-may-89
;  Lee Taylor
;  updated 15-sep-92
;  Stewart Brown and Dennis Braddy
; 

(set-format "short"   "%4d")
(set-format "integer" "%6d")
(set-format "long"    "%8d")
(set-format "float"   "%11.3e")
(set-format "double"  "%11.3e")

;-----------------------------------------------------------------;

(define c (write-pdbdata nil "c" (type "char" 10) "bar"))
(show-pdb c) 

(define a (write-pdbdata nil "a" (type "char *") "foo"))
(show-pdb a) 

(define e (write-pdbdata nil "e" (type "char *" 3) "Foo" () "Bar"))
(show-pdb e) 

(define s (write-pdbdata nil "s" (type "char **") '("Hello" "world")))
(show-pdb s) 

;-----------------------------------------------------------------;

(define cn (write-pdbdata nil "cn" (type "integer" 10) 1 2 3 4 5 6 7 8 9 10))
(show-pdb cn) 

(define an (write-pdbdata nil "an" (type "integer *") '(1 2 3 4)))
(show-pdb an) 

(define en (write-pdbdata nil "en" (type "integer *" 3) '(-1 -2 -3) '(4 5 6) '(7 8 9)))
(show-pdb en) 

(define sn (write-pdbdata nil "sn" (type "integer **") '((1 2 3 4 5) (6 7 8 9))))
(show-pdb sn) 

;-----------------------------------------------------------------;

(define cs (write-pdbdata nil "cs" (type "short" 10) 1 2 3 4 5 6 7 8 9 10))
(show-pdb cs) 

(define as (write-pdbdata nil "as" (type "short *") '(1 2 3 4)))
(show-pdb as) 

(define es (write-pdbdata nil "es" (type "short *" 3) '(-1 -2 -3) '(4 5 6) '(7 8 9)))
(show-pdb es) 

(define ss (write-pdbdata nil "ss" (type "short **") '((1 2 3 4 5) (6 7 8 9))))
(show-pdb ss) 

;-----------------------------------------------------------------;

(make-defstr* nil "cat" (def-member integer i)
                        (def-member integer i1 2)
                        (def-member float   f)
                        (def-member double  dd 2))

(define struct1 (write-pdbdata nil "struct1" (type "cat") '(10 (1 2)
                                                    20.0 (3.1415926  5.))))
(show-pdb struct1)

(make-defstr* nil "dog" (def-member integer i)
                        (def-member char c 10) 
                        (def-member integer i1 2)
                        (def-member float   f))

(define struct2 (write-pdbdata nil "struct2" (type "dog") '(10 "test" (1 2) 20.)))
(show-pdb struct2)

(make-defstr* nil "bird" (def-member integer i)
                         (def-member char c 10) 
                         (def-member integer *i1)
                         (def-member char *a)
                         (def-member char **s)
                         (def-member float   f))

(define struct3a (write-pdbdata nil "struct3a" (type "bird" 3)
         '(10 "test" ((1 2)) ("doggie") (("big" "ugly")) 20.)
         '(20 "baz"  ((3 4 5 6)) ("kitty") (("nice" "soft" "warm")) 22.)
         '(30 "foo"  (7) ("birdy") (("small")) 24.)
                                            ))
(set-switch 0 2)
(show-pdb struct3a)

(define struct3 (write-pdbdata nil "struct3" (type "bird **")
         '(((10 "test" ((1 2)) ("doggie") (("big" "ugly")) 20.)
           (20 "baz"  ((3 4 5 6)) ("kitty") (("nice" "soft" "warm")) 22.)
           (30 "foo"  (7) ("birdy") (("small")) 24.)
                                            ))))

(show-pdb struct3)

(make-defstr* nil "rabbit" (def-member integer i)
		           (def-member char c 10) 
                           (def-member dog **ddd)
                           (def-member integer x 4))

(define struct4 (write-pdbdata nil "struct4" (type "rabbit")
           '(10 "test" (((
			  (11 "first" (1 2) 20.)
			  (21 "second" (3 4) 30.)
			  (31 "third" (5 6) 40.)
			  )))
		(12 13 14 15)
		)))

(show-pdb struct4)

; ----------------------------------------------------------
; test pdb->list
; ----------------------------------------------------------

(printf nil "testing pdb->list\n")

(define (wr-data name x)
    (apply write-pdbdata (cons nil (cons name (cdr x)))))

(define c (wr-data "c" (pdb->list c)))
(show-pdb c)
(define a (wr-data "a" (pdb->list a)))
(show-pdb a)
(define e (wr-data "e" (pdb->list e)))
(show-pdb e)
(define s (wr-data "s" (pdb->list s)))
(show-pdb s)

(define cs (wr-data "cs" (pdb->list cs)))
(show-pdb cs)
(define as (wr-data "as" (pdb->list as)))
(show-pdb as)
(define es (wr-data "es" (pdb->list es)))
(show-pdb es)
(define ss (wr-data "ss" (pdb->list ss)))
(show-pdb ss)

(define cn (wr-data "cn" (pdb->list cn)))
(show-pdb cn)
(define an (wr-data "an" (pdb->list an)))
(show-pdb an)
(define en (wr-data "en" (pdb->list en)))
(show-pdb en)
(define sn (wr-data "sn" (pdb->list sn)))
(show-pdb sn)

(define struct1 (wr-data "struct1" (pdb->list struct1)))
(show-pdb struct1)
(define struct2 (wr-data "struct2" (pdb->list struct2)))
(show-pdb struct2)
(define struct3 (wr-data "struct3" (pdb->list struct3)))
(show-pdb struct3)
(define struct3a (wr-data "struct3a" (pdb->list struct3a)))
(show-pdb struct3a)
(define struct4 (wr-data "struct4" (pdb->list struct4)))
(show-pdb struct4)

;-----------------------------------------------------------------;
;   write to a file
;-----------------------------------------------------------------;

(printf nil "Creating file foofoo\n")

(define file1 (open-pdbfile "foofoo" "w"))
(display (list-file))
(newline)

(write-pdbdata file1 "c" c)
(write-pdbdata file1 "a" a)
(write-pdbdata file1 "e" e)
(write-pdbdata file1 "s" s)

(write-pdbdata file1 "cs" cs)
(write-pdbdata file1 "as" as)
(write-pdbdata file1 "es" es)
(write-pdbdata file1 "ss" ss)

(write-pdbdata file1 "cn" cn)
(write-pdbdata file1 "an" an)
(write-pdbdata file1 "en" en)
(write-pdbdata file1 "sn" sn)

;  copy over defstrs

(write-defstr* file1 (read-defstr* nil "cat"))
(write-defstr* file1 (read-defstr* nil "dog"))
(write-defstr* file1 (read-defstr* nil "bird"))
(write-defstr* file1 (read-defstr* nil "rabbit"))

(write-pdbdata file1 "struct1" struct1)
(write-pdbdata file1 "struct2" struct2)
(write-pdbdata file1 "struct3" struct3)
(write-pdbdata file1 "struct3a" struct3a)
(write-pdbdata file1 "struct4" struct4)

(close-pdbfile file1)

;-----------------------------------------------------------------;

(printf nil "reading file foofoo\n")

(define file2 (open-pdbfile "foofoo"))
(define c1 (read-pdbdata file2 "c"))
(show-pdb c1)
(define a1 (read-pdbdata file2 "a"))
(show-pdb a1)
(define e1 (read-pdbdata file2 "e"))
(show-pdb e1)
(define s1 (read-pdbdata file2 "s"))
(show-pdb s1)

(define cs1 (read-pdbdata file2 "cs"))
(show-pdb cs1)
(define as1 (read-pdbdata file2 "as"))
(show-pdb as1)
(define es1 (read-pdbdata file2 "es"))
(show-pdb es1)
(define ss1 (read-pdbdata file2 "ss"))
(show-pdb ss1)

(define cn1 (read-pdbdata file2 "cn"))
(show-pdb cn1)
(define an1 (read-pdbdata file2 "an"))
(show-pdb an1)
(define en1 (read-pdbdata file2 "en"))
(show-pdb en1)
(define sn1 (read-pdbdata file2 "sn"))
(show-pdb sn1)

(define struct11 (read-pdbdata file2 "struct1"))
(show-pdb struct11)
(define struct21 (read-pdbdata file2 "struct2"))
(show-pdb struct21)
(define struct31 (read-pdbdata file2 "struct3"))
(show-pdb struct31)
(define struct3a1 (read-pdbdata file2 "struct3a"))
(show-pdb struct3a1)
(define struct41 (read-pdbdata file2 "struct4"))
(show-pdb struct41)

(close-pdbfile file2)
(quit)
;-----------------------------------------------------------------;


