/*
 * SXMM.C - constructors and destructors for SX
 *
 * Source Version: 3.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
 
#include "sx.h"

static void
 SC_DECLARE(_SX_rl_gpdbdata, (object *obj)),
 SC_DECLARE(_SX_wr_gpdbdata, (object *obj, object *strm)),
 SC_DECLARE(_SX_wr_gsyment, (object *obj, object *strm)),
 SC_DECLARE(_SX_wr_gdefstr, (object *obj, object *strm)),
 SC_DECLARE(_SX_wr_gfile, (object *obj, object *strm));

/*--------------------------------------------------------------------------*/

/*                              PDB SECTION                                 */

/*--------------------------------------------------------------------------*/

/* _SX_MK_PDBDATA - make and return g_pdbdata */

g_pdbdata *_SX_mk_pdbdata(name, data, ep, file)
   char *name;
   byte *data;
   syment *ep;
   PDBfile *file;
   {g_pdbdata *pp;

    pp = FMAKE(g_pdbdata, "_SX_MK_PDBDATA:pp");

    SC_mark(data, 1);
    SC_mark(ep, 1);
    SC_mark(file, 1);

    pp->name = SC_strsavef(name, "char*:_SX_MK_PDBDATA:name");
    pp->data = data;
    pp->ep   = ep;
    pp->file = file;

    return(pp);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_MK_GPDBDATA - encapsulate a g_pdbdata as an object */

object *_SX_mk_gpdbdata(name, data, ep, file)
   char *name;
   byte *data;
   syment *ep;
   PDBfile *file;
   {g_pdbdata *pp;
    object *op;

    pp = _SX_mk_pdbdata(name, data, ep, file);

    op = SS_mk_object(pp, G_PDBDATA, SELF_EV, pp->name);
    SC_mark(pp, 1);

    op->print   = _SX_wr_gpdbdata;
    op->release = _SX_rl_gpdbdata;

    return(op);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_RL_GPDBDATA - release g_pdbdata */

static void _SX_rl_gpdbdata(obj)
   object *obj;
   {g_pdbdata *pp;

    pp = SS_GET(g_pdbdata, obj);
    if (SC_ref_count(pp) < 2)
       {SFREE(pp->name);

/* for now this only lowers the reference count but is NOT prepared to
 * free the objects themselves - that is for the next pass
 */
	SFREE(pp->data);
	SFREE(pp->file);
	SFREE(pp->ep);};

    SFREE(pp);

    SS_rl_object(obj);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_WR_GPDBDATA - print a g_pdbdata */

static void _SX_wr_gpdbdata(obj, strm)
   object *obj, *strm;
   {PRINT(SS_OUTSTREAM(strm), "<PDBDATA|%s>", PDBDATA_NAME(obj));

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_MK_GSYMENT - encapsulate a syment as an object */

object *_SX_mk_gsyment(ep)
   syment *ep;
   {object *op;

    if (ep == NULL)
       return(SS_null);

    op = SS_mk_object(ep, G_SYMENT, SELF_EV, ep->type);
    op->print   = _SX_wr_gsyment;
    op->release = SS_rl_object;

    return(op);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_WR_GSYMENT - print a g_syment */

static void _SX_wr_gsyment(obj, strm)
   object *obj, *strm;
   {PRINT(SS_OUTSTREAM(strm), "<SYMENT|%s>", SYMENT_TYPE(obj));

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_MK_GDEFSTR - encapsulate a defstr as an object */

object *_SX_mk_gdefstr(dp)
   defstr *dp;
   {object *op;

    if (dp == NULL)
       return(SS_null);

    op = SS_mk_object(dp, G_DEFSTR, SELF_EV, dp->type);
    op->print   = _SX_wr_gdefstr;
    op->release = SS_rl_object;

    return(op);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_WR_GDEFSTR - print a g_defstr */

static void _SX_wr_gdefstr(obj, strm)
   object *obj, *strm;
   {PRINT(SS_OUTSTREAM(strm), "<DEFSTR|%s>", DEFSTR_TYPE(obj));

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_WR_GFILE - print a g_file */

static void _SX_wr_gfile(obj, strm)
   object *obj, *strm;
   {PRINT(SS_OUTSTREAM(strm), "<%s|%s|%s>",
                              FILE_TYPE(obj), FILE_EXT_TYPE(obj),
                              FILE_NAME(obj));

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_MK_FILE - make and return a g_file */

g_file *_SX_mk_file(name, type, ext_type, file)
   char *name, *type, *ext_type;
   byte *file;
   {g_file *po;

    po = FMAKE(g_file, "_SX_MK_FILE:po");

    SC_mark(file, 1);

    po->name           = SC_strsavef(name, "char*:_SX_MK_FILE:name");
    po->type           = SC_strsavef(type, "char*:_SX_MK_FILE:type");
    po->external_type  = SC_strsavef(ext_type, "char*:_SX_MK_FILE:ext_type");
    po->file           = file;
    po->file_object    = NULL;
    po->n_menu_items   = 0L;
    po->max_menu_items = 0L;
    po->menu           = NULL;
    po->next           = SX_file_list;

    return(po);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_RL_FILE - release a g_file
 *             - assume the caller closed the file
 */

static void _SX_rl_file(po)
   g_file *po;
   {long i, n;
    SX_menu_item *mitems;

    mitems = po->menu;
    if (mitems != NULL)
       {n = po->n_menu_items;
        for (i = 0L; i < n; i++)
            {SFREE(mitems[i].vname);
             SFREE(mitems[i].label);};
        SFREE(mitems);};

    SFREE(po->file);
    po->file_object = NULL;

    SFREE(po->external_type);
    SFREE(po->type);
    SFREE(po->name);
    SFREE(po);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_MK_GFILE - make and return type g_file */

object *SX_mk_gfile(po)
   g_file *po;
   {object *op;

    if (po == NULL)
       return(SS_null);

    SC_mark(po, 1);

    op = SS_mk_object(po, G_FILE, SELF_EV, po->name);
    op->print   = _SX_wr_gfile;
    op->release = SS_rl_object;

    return(op);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_MK_OPEN_FILE - initialize an g_file and return a pointer
 *                  - to it
 */

g_file *_SX_mk_open_file(fun, name, type, ext_type, mode, type_hook)
   PFPByte fun;
   char *name, *type, *ext_type, *mode;
   PFInt type_hook;
   {PDBfile *file;
    object *obj;
    g_file *po;

/* open the file */
    file = (PDBfile *) (*fun)(name, mode);
    if (file == NULL)
       {if (SC_isfile_ascii(name))
           SS_error("REQUESTED FILE IS ASCII - _SX_MK_OPEN_FILE",
                     SS_mk_string(name));
        else if (SC_isfile(name))
           SS_error("BAD FILE TYPE OR MODE - _SX_MK_OPEN_FILE",
                    SS_mk_string(name));
        else
           {file = (PDBfile *) (*fun)(name, "w");
            if (file == NULL)
               SS_error("CAN'T OPEN FILE - _SX_MK_OPEN_FILE", 
                        SS_mk_string(name));};};

/* get the miserable, pesky type REAL in once and for all!! */
    if (strcmp(type, SX_PDBFILE_S) == 0)
       {PD_typedef_primitive_types(file);
	if (sizeof(REAL) == sizeof(double))
	   PD_typedef(file, "double", "REAL");
        else
	   PD_typedef(file, "float", "REAL");};

    po  = _SX_mk_file(name, type, ext_type, file);
    obj = SX_mk_gfile(po);
    SS_UNCOLLECT(obj);

/* GOTCHA: since po points to obj and obj points to po
 *         handle the GC by insisting that anybody who
 *         assigns to obj must take responsibility for 
 *         marking it
 */
    po->file_object = obj;
    po->type_hook   = type_hook;

    return(po);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_REL_OPEN_FILE - GC an g_file
 *                   - include closing the file
 */

void _SX_rel_open_file(fun, po)
   PFInt fun;
   g_file *po;
   {char *file;

    file = po->file;

/* close the file */
    if (!(*fun)(file))
       SS_error("CAN'T PROPERLY CLOSE FILE - _SX_REL_OPEN_FILE", 
                po->file_object);

    _SX_rl_file(po);

    return;}
    
/*--------------------------------------------------------------------------*/

/*                              PANACEA SECTION                             */

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/*                                PGS SECTION                               */

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/*                                PML SECTION                               */

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
