/*
 * SXIO.C - SX io test routines
 *
 * Source Version: 3.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
 
#include "sx.h"

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SPRINT - C's fprintf for Scheme */

object *SS_print(argl)
   object *argl;
   {Register object *str, *obj, *format;
    char forms[MAXLINE], *fmt, *le, *lb, local[MAXLINE], *pt;
    int c;
    FILE *stream;

    str  = SS_car(argl);
    argl = SS_cdr(argl);
    if (SS_nullobjp(str))
       str = SS_outdev;

    if (!SS_outportp(str))
       SS_error("BAD PORT - PRINT", str);
    stream = SS_OUTSTREAM(str);

    format = SS_car(argl);
    if (!SS_stringp(format))
       SS_error("BAD FORMAT - PRINT", format);
    strcpy(forms, SS_STRING_TEXT(format));
    fmt = forms;

    while (TRUE)
       {for (pt = local; (((c = *fmt++) != '%') && (c != '\0')); pt++)
            {if (c == '\\')
                {switch (c = *fmt++)
                    {case 't' : *pt = '\t';
                                break;
                     case 'r' : *pt = '\r';
                                break;
                     case 'n' : *pt = '\n';
                                break;};}
             else
                *pt = c;};
        *pt = '\0';
        PRINT(stream, local);

        if (c == '\0')
           break;

/* copy from the % to the type specifier to get the format descriptor for
 * this item
 */
        le = strpbrk(fmt, "sdouxXfeEgGc%");
        local[0] = '%';
        for (lb = &local[1]; le != fmt; *lb++ = *fmt++);
        fmt++;
        *lb++ = *le;
        *lb = '\0';

/* get the object now */
        if (SS_nullobjp(argl))
           return(SS_f);
        argl = SS_cdr(argl);
        if (SS_nullobjp(argl))
           return(SS_f);
        obj  = SS_car(argl);

/* jump on the type spec to pull the correct arg type off the stack */
        switch (*le)
           {case 's' :
            case 'c' : _SS_print(obj, "", "", str);
                       break;

            case 'i' :
            case 'X' :
            case 'x' :
            case 'o' :
            case 'd' :
            case 'u' : if (!SS_integerp(obj))
                          SS_error("NON-INTEGER FOR INTEGER FIELD - PRINT",
                                   obj);
                       PRINT(stream, local, SS_INTEGER_VALUE(obj));
                       break;

            case 'f' : 
            case 'e' :
            case 'E' : 
            case 'g' : 
            case 'G' : if (!SS_floatp(obj))
                          SS_error("NON-FLOAT FOR REAL FIELD - PRINT",
                                   obj);
                       PRINT(stream, local, SS_FLOAT_VALUE(obj));
                       break;
            case '%' : PRINT(stream, "%%");
                       break;};};

    return(SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
