/*
 * SCPAR.C - parallel support routines
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "score.h"

SC_THREAD_ATTR(_SC_thread_attr);

static int
 *_SC_indexes = NULL;

static SC_thread
 *_SC_threads = NULL;

static SC_thread_key
 *SC_key;

#ifdef HAVE_THREADS

static void
 SC_DECLARE(_SC_work_thread, (void *x));

static int
 SC_thread_work_size,
 SC_n_threads,
 SC_next_work_item,
 SC_n_work_started,
 SC_n_work_finished,
 SC_n_work_items;

SC_dynamic_array
 SC_thread_args,
 SC_thread_work;

static void
 **SC_thread_ret;

#endif

int
 SC_comm_rank = 0,
 SC_comm_size = 1;

SC_THREAD_CONDV(SC_work_available_condv);
SC_THREAD_CONDV(SC_work_finished_condv);

SC_THREAD_LOCK(SC_thread_workqueue_lock);

/*--------------------------------------------------------------------------*/

/*                               SMP ROUTINES                               */

/*--------------------------------------------------------------------------*/

/* SC_CURRENT_THREAD - return the id of the current thread */

int SC_current_thread()
   {int tid;

    if (SC_tid_hook != NULL)
       (*SC_tid_hook)(&tid);

    else
       tid = 0;

    return(tid);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SC_INIT_THREADS - execute the given function FNC on NT threads
 *                 - serial execution follows from NT equal to 1
 */

void SC_init_threads(nt, ik, tid)
   int nt;
   SC_thread_key *ik;
   PFVoid tid;
   {
#ifdef HAVE_THREADS    
    int i;
#endif

    _SC_threads = FMAKE_N(SC_thread, nt+1, "SC_INIT_THREADS:threads");
    _SC_indexes = FMAKE_N(int, nt+1, "SC_INIT_THREADS:indexes");

    _SC_indexes[0] = 0;
    _SC_threads[0] = SC_THREAD_SELF();

    SC_CREATE_KEY(*ik, NULL);
    SC_SET_KEY(int, *ik, _SC_indexes);

    SC_key = ik;
    SC_tid_hook = tid;

#ifdef HAVE_THREADS
    SC_thread_work_size = nt;
    SC_n_threads        = nt;
    SC_n_work_started   = nt;
    SC_n_work_finished  =  0;
    SC_n_work_items     =  0;

    SC_INIT_DYNAMIC_ARRAY(SC_thread_work, PFPVoid, "PFPVoid", SC_thread_work_size);
    SC_INIT_DYNAMIC_ARRAY(SC_thread_args, void *,  "void *",  SC_thread_work_size);

    for (i = 1; i <= nt; i++)
        {_SC_indexes[i] = i;
         SC_THREAD_CREATE(_SC_threads[i], _SC_thread_attr,
                          _SC_work_thread, _SC_indexes[i]);};

/* wait until all threads are initialized before returning */
    SC_LOCKON(SC_thread_workqueue_lock);
      while (SC_n_work_finished < SC_n_work_started)
          SC_COND_WAIT(SC_work_finished_condv, SC_thread_workqueue_lock);
    SC_LOCKOFF(SC_thread_workqueue_lock);

#endif
 
    return;}

/*--------------------------------------------------------------------------*/

#ifdef HAVE_THREADS

/*--------------------------------------------------------------------------*/

/* SC_DO_THREADS - execute the given function NT times
 *               - serial execution follows from NT equal to 1
 *
 *                  n: number of entries in the following arguments
 *              nt[i]: number of threads that should execute fnc[i]
 *                fnc: array of functions to execute
 *             arg[i]: argument list (struct *) for fnc[i]
 *                 ik: thread key
 *                ret: array to hold return values from fnc, there
 *                     needs to be enough space to handle all the
 *                     function invocations (independent of number
 *                     of threads).
 */

void SC_do_threads(n, nt, fnc, arg, ik, ret)
   int n, *nt;
   void *(*fnc[])();
   void **arg;
   SC_thread_key *ik;
   void **ret;
   {int i, j;

    SC_LOCKON(SC_thread_workqueue_lock);
      SC_thread_ret = ret;

      SC_N_DYNAMIC(SC_thread_work) = 0;
      SC_N_DYNAMIC(SC_thread_args) = 0;
      SC_n_work_finished = 0;
      SC_n_work_started  = 0;
      SC_n_work_items    = 0;

      for (i = 0; i < n; i++)
          for (j = 0; j < nt[i]; j++)
              {SC_REMEMBER_DYNAMIC(PFPVoid, fnc[i], SC_thread_work);
               if (arg != NULL)
                  {SC_REMEMBER_DYNAMIC(void *, arg[i], SC_thread_args);}
               else
                  {SC_REMEMBER_DYNAMIC(void *, NULL, SC_thread_args);}
               SC_n_work_items++;};

      SC_next_work_item = 0;

      SC_THREAD_BROADCAST(SC_work_available_condv);

      while(SC_n_work_finished < SC_n_work_items)
          SC_COND_WAIT(SC_work_finished_condv, SC_thread_workqueue_lock);
    SC_LOCKOFF(SC_thread_workqueue_lock); 

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

void _SC_work_thread(x)
   void *x;
   {PFPVoid fnc;
    void *arg;
    int i, t;

    t = *(int *)x;
    SC_SET_KEY(int, *SC_key, x);

    while (TRUE)
        {SC_LOCKON(SC_thread_workqueue_lock);
           SC_n_work_finished++;
           
           if (SC_n_work_started >= SC_n_work_items)
              SC_n_work_items = 0;

           if (SC_n_work_started == SC_n_work_finished &&
               SC_n_work_items   == 0)
              SC_THREAD_SIGNAL(SC_work_finished_condv);
           
           while(SC_n_work_items == 0)
               SC_COND_WAIT(SC_work_available_condv, SC_thread_workqueue_lock);
           
           if (SC_n_work_started < SC_n_work_items)
              {fnc = SC_GET_NTH_DYNAMIC(PFPVoid, SC_thread_work, SC_next_work_item);
               arg = SC_GET_NTH_DYNAMIC(void *, SC_thread_args, SC_next_work_item);
               i   = SC_next_work_item;
               SC_next_work_item++;}
           else
              fnc = NULL;

           SC_n_work_started++;
         SC_LOCKOFF(SC_thread_workqueue_lock);


         if (fnc != NULL)
            if (SC_thread_ret == NULL)
               (*fnc) (arg);
            else
               SC_thread_ret[i+1] = (*fnc)(arg);}

    return;}

/*--------------------------------------------------------------------------*/

#else

/*--------------------------------------------------------------------------*/

/* SC_DO_THREADS - execute the given function FNC on NT threads
 *               - serial execution follows from NT equal to 1
 */

void SC_do_threads(n, nt, fnc, arg, ik, ret)
   int n, *nt;
   void *(*fnc[])();
   void **arg;
   SC_thread_key *ik;
   void **ret;
   {int i, j, icounter;
    void *larg;
    PFPVoid lfnc;

    if (ret == NULL)
       {for (i = 0; i < n; i++)
            for (j = 1; j <= nt[i]; j++)
	        {_SC_indexes[j] = j;
                 SC_SET_KEY(int, *ik, &j);
                 larg = (arg == NULL) ? NULL : arg[i];
                 lfnc = fnc[i];
	         (*lfnc)((void *) larg);};}
    else
       {icounter = 0;
        for (i = 0; i < n; i++)
            for (j = 1; j <= nt[i]; j++)
	        {_SC_indexes[j] = j;
                 SC_SET_KEY(int, *ik, &j);
                 larg = (arg == NULL) ? NULL : arg[i];
                 lfnc = fnc[i];
	         ret[++icounter] = (*lfnc)((void *) larg);};};

    i = 0;
    SC_SET_KEY(int, *ik, &i);

    return;}

/*--------------------------------------------------------------------------*/

#endif

/*--------------------------------------------------------------------------*/
