/*
 * INTERACT.C - interactive test for PACT
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

/***********************************************************************
* File        : interact.c 
* Programmer  : Carolyn Sharp
* Machines    : sun3, phoenix, Cray 2, RS6000
*
* Description : Interactive tester for pact - tests those routines
*               which cannot be handled automatically. 
* Notes       : Use Ctrl-C at any time to quit.
* Caution     : Redirection of output -> terminal appears hung  but it's
*               just waiting for your terminal input.
***********************************************************************/

#include "score.h"

main()
   {int ifail = 0;
  
    ifail += tSC_wall_clock_time();
    ifail += tSC_pause();
    ifail += tSC_banner();

    if (ifail == 0)
       PRINT(STDOUT, "\nPASS Interactive Tester \n");
    else
       PRINT(stderr, "\nFAIL = %d in Interactive Tester \n", ifail);

    return(ifail ? 1 : 0);}

/***********************************************************************
* Function    : tSC_wall_clock_time
* Usage       : Interactive tester for pact/score/scctl.c function
*               SC_wall_clock_time
*
* Description : Displays time and instructions for user response.
*               Prints name of function if test fails.
*
* Returns     : 1|0 for PASS|FAIL.
***********************************************************************/

int tSC_wall_clock_time()
   {int cfail = 0;
    int time = 30;
    char reply[MAXLINE];                  /* MAXLINE defined in scstd.h */
    int i;
    int t0, t1;

    PRINT(STDOUT, "\n\n***** This is the test for SC_wall_clock_time ***** \n");

    t0 = SC_wall_clock_time();
    PRINT(STDOUT, "t0 = %d \n", t0);
    sleep(time);
    t1 = SC_wall_clock_time();
    PRINT(STDOUT, "t1 = %d \n", t1);
    PRINT(STDOUT, "Does %d = %d? \n",(t1-t0),time);

    for (i=0; i<time; i++)
        PRINT(STDOUT, "%d\n", SC_wall_clock_time());

    PRINT(STDOUT, "The starting time is: %11.3e \n", SC_wall_clock_time());
    PRINT(STDOUT, "(Taking %d second nap...zzz...) \n", time);
    sleep(time);
    PRINT(STDOUT, "The wake-up  time is: %11.3e \n", SC_wall_clock_time());
    PRINT(STDOUT, "\nIs that close enough?");
    PRINT(STDOUT, "TICKS_SECOND = %d", TICKS_SECOND);
    PRINT(STDOUT, "\nPlease reply y|n to set PASS|FAIL flag: ");
    if (gets(reply) == NULL)
       PRINT(STDOUT, "\n Error reading response \n");

    else
       if (reply[0] != 'y')
          cfail++;

    return(cfail);}

/***********************************************************************
* Function    : tSC_banner
* Usage       : Interactive tester for pact/score/scctl.c function
*               SC_banner 
*
* Description : Displays banner and instructions for user response.
*               Prints name of function if test fails.
*
* Returns     : 1|0 for PASS|FAIL.
***********************************************************************/

tSC_banner()
   {int bfail = 0;
    char reply[MAXLINE], bstr[MAXLINE];

    strcpy(bstr, "This message is brought to you by SC_banner.");

    PRINT(STDOUT, "\n\n***** This is the test for SC_banner ***** \n");
    PRINT(STDOUT, "You should see the message:\n %s \n", bstr);

    SC_banner(bstr);

    PRINT(STDOUT, "\nDo the messages match?");
    PRINT(STDOUT, "\nPlease reply y|n to set PASS|FAIL flag: ");
    if (gets(reply) == NULL)
       PRINT(STDOUT, "\n Error reading response \n");

    else
       {if (reply[0] != 'y')
	   bfail++;};

    if (bfail != 0)
       PRINT(STDOUT, "\nFAIL SC_banner \n");

    return(bfail);}

/***********************************************************************
* Function    : tSC_pause 
* Usage       : Interactive tester for pact/score/scctl.c function
*               SC_pause
*
* Description : Causes pause for user until <CR> received.
*               Prints name of function if test fails.
*
* Returns     : 1|0 for PASS|FAIL.
***********************************************************************/

tSC_pause()
   {int pfail = 0;
    char reply[MAXLINE];

    PRINT(STDOUT, "\n\n***** This is the test for SC_pause ***** \n");
    PRINT(STDOUT, "You should expect a pause until you press <CR>.\n");

    SC_pause();

    PRINT(STDOUT, "Was there a pause?\n");
    PRINT(STDOUT, "Please reply y|n to set PASS|FAIL flag: ");
    if (gets(reply) == NULL)
       PRINT(STDOUT, "\n Error reading response \n");

    else
       {if (reply[0] != 'y')
	   pfail++;};

    if (pfail != 0)
       PRINT(STDOUT, "\nFAIL SC_pause \n");

    return(pfail);}
 


