/*
 * SHTTY.C - routines to handle low level terminal I/O
 *
 * Source Version: 4.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "scheme.h"

#define PRIMITIVE_PRINT (*pr_print)
#define PRIMITIVE_GETLN (*pr_gets)

#define EOI(str)                                                             \
   (((SS_PTR(str) != SS_BUFFER(str)) && (*(SS_PTR(str) - 1) == '\n')) ||     \
     (*SS_PTR(str) == '\0'))

static PFfprintf
 pr_print = NULL;

static PFfgets
 pr_gets = NULL;

char
 Sbuffer[LRG_TXT_BUFFER];

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_GET_CH - the do it right character reader
 *           - must get the next character from the given stream
 */

int SS_get_ch(str, ign_ws)
   object *str;
   int ign_ws;
   {Register int c;
    Register FILE *s;
    char eof;

    eof = (char) EOF;
    if (pr_gets == NULL)
#ifdef MAC
       pr_gets = (PFfgets) PG_wind_fgets;
#else
       pr_gets = io_gets_hook;
#endif

    s = SS_INSTREAM(str);

    while (TRUE)
       {if (EOI(str))
           {if (s == NULL)
               return(EOF);

            if (PRIMITIVE_GETLN(SS_BUFFER(str), MAXLINE, s) == NULL)
               {*SS_PTR(str) = eof;
                return(EOF);};

            SS_PTR(str) = SS_BUFFER(str);};

        c = *SS_PTR(str)++;

        if (c == EOF)
           SS_PTR(str)--;

        if (ign_ws)
           {switch (c)
               {case '\n':

#ifndef MACPLUS
                case '\r':
#endif

                case '\t':
                case ' ' : break;
                case ';' : while ((c = *SS_PTR(str)++) != '\0')
                              {if (c == EOF)
                                  return(c);
                               else if ((c == '\n') || (c == '\r'))
                                  break;};
                           break;
                default  : return(c);};}
        else
           return(c);};}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_UNGET_CH - the do it right character unreader
 *             - must put the character back on the stream
 */

void SS_unget_ch(c, str)
   int c;
   object *str;
   {if (SS_PTR(str) > SS_BUFFER(str))
       *(--SS_PTR(str)) = (char) c;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_PUT_CH - the do it right character printer
 *           - must put the character to the given stream
 */

void SS_put_ch(c, str)
   int c;
   object *str;
   {FILE *s;

    s = SS_INSTREAM(str);
    if (s != NULL)
       putc(c, s);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_PRINTF - a print function that can handle transcripts */

#ifdef PCC

int SS_printf(fp, fmt, va_alist)
   FILE *fp;
   char *fmt;
   va_dcl

#endif

#ifdef ANSI

int SS_printf(FILE *fp, char *fmt, ...)

#endif

   {FILE *hp;

    if (fp != NULL)
       {SC_VA_START(fmt);
	SC_VSPRINTF(Sbuffer, fmt);
	SC_VA_END;

	if (pr_print == NULL)
#ifdef MAC
	   pr_print = (PFfprintf) PG_wind_fprintf;
#else
	   pr_print = io_printf_hook;
#endif

	hp = SS_OUTSTREAM(SS_histdev);
	if (SS_hist_flag && (fp != hp))
	   PRIMITIVE_PRINT(hp, "%s", Sbuffer);

	PRIMITIVE_PRINT(fp, "%s", Sbuffer);};

    return(FALSE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_GET_STRING - convert a SCHEME object to a string */

char *SS_get_string(obj)
   object *obj;
   {static char t[MAXLINE];

    memset(t, 0, MAXLINE);

    if (obj->print_name != NULL)
       strcpy(t, obj->print_name);
      
    else if (SS_integerp(obj))
       sprintf(t, "%ld", SS_INTEGER_VALUE(obj));

    else if (SS_floatp(obj))
       sprintf(t, "%g", SS_FLOAT_VALUE(obj));

    else if (SS_nullobjp(obj))
        strcpy(t, "nil");

    else if (obj == NULL)
        strcpy(t, "nil");

    else
        strcpy(t, "-none-");

    return(t);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

