/*
 * SHTLEV.C - top level of scheme interpreter
 *
 * Source Version: 4.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "scheme.h"

continuation
 *SS_continue;

err_continuation
 *SS_err_continue;

char
 *SS_OBJECT_S,
 *SS_POBJECT_S;

PFVoid
 SS_post_read_hook,
 SS_post_eval_hook,
 SS_print_err_msg_hook;

PFInt
 SS_post_print_hook;

int
 SS_interactive,
 SS_lines_page,
 SS_hist_flag,
 SS_print_flag,
 SS_stat_flag,
 SS_nsave,
 SS_nrestore,
 SS_nsetc,
 SS_ngoc,
 SS_stack_size,
 SS_stack_mask,
 SS_stack_ptr,
 SS_cont_ptr,
 SS_err_cont_ptr,
 SS_errlev;

HASHTAB
 *SS_symtab;

object
 *SS_scheme_symtab,
 *SS_quoteproc,
 *SS_quasiproc,
 *SS_unqproc,
 *SS_unqspproc,
 *SS_setproc,
 *SS_null,
 *SS_eof,
 *SS_t,
 *SS_f,
 *SS_else,
 *SS_This,
 *SS_Val,
 *SS_Unev,
 *SS_Exn,
 *SS_Argl,
 *SS_Fun,
 *SS_Env,
 *SS_Global_Env,
 *SS_err_state,
 **SS_err_stack,
 *SS_rdobj,
 *SS_evobj;

SC_dynamic_array
 SS_stack;

static int
 SS_exit_val = 0;

static int
 SC_DECLARE(_SS_repl, (byte));

void
 SC_DECLARE(dprint, (object *obj));
 
static void
 SC_DECLARE(_SS_fpe_handler, (int sig, int code)),
 SC_DECLARE(_SS_restore_state_prim, (int ns, int nc, int ne));

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_REPL - run a READ-EVAL-PRINT Loop */

void SS_repl()
   {char *t;

    while (TRUE)
       {SS_err_catch(_SS_repl, NULL);

/* reset the input buffer */
        t = SS_BUFFER(SS_indev);
        SS_PTR(SS_indev) = t;
        *t = '\0';};}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_REPL - run a READ-EVAL-PRINT Loop */

static int _SS_repl()
   {long a, f, d;
    double evalt;

    SS_Assign(SS_rdobj, SS_null);
    SS_Assign(SS_evobj, SS_null);

    sprintf(SS_ans_prompt, "(%d): ", SS_errlev - 1);

    d = 0L;
    while (TRUE)
       {SC_mem_stats_set(0L, 0L);
        SS_ngoc       = 0;
        SS_nsetc      = 0;
        SS_nsave      = 0;
        SS_nrestore   = 0;

/* Print the prompt call the Reader */
        PRINT(stdout, "%s", SS_prompt);
        SS_Assign(SS_rdobj, _SS_read(SS_indev));

        if (SS_post_read_hook != NULL)
           (*SS_post_read_hook)(SS_indev);

        SS_interactive = TRUE;

/* Eval the object returned by the Reader */
	evalt = SC_cpu_time();
        SS_Assign(SS_evobj, SS_eval(SS_rdobj));
	evalt = SC_cpu_time() - evalt;

        if (SS_post_eval_hook != NULL)
           (*SS_post_eval_hook)(SS_indev);

/* Print the evaluated object */
        if (SS_print_flag)
           _SS_print(SS_evobj, SS_ans_prompt, "\n", SS_outdev);

        SS_Assign(SS_Env, SS_Global_Env);
        SS_Assign(SS_This, SS_null);
        SS_Assign(SS_Exn, SS_null);
        SS_Assign(SS_Val, SS_null);
        SS_Assign(SS_Unev, SS_null);
        SS_Assign(SS_Argl, SS_null);
        SS_Assign(SS_Fun, SS_null);
        SS_Assign(SS_rdobj, SS_null);
        SS_Assign(SS_evobj, SS_null);

/* Restore the global environment */
	SC_mem_stats(&a, &f, NULL, NULL);
        d += a - f;
        if (SS_stat_flag)
           {PRINT(stdout, "Stack Usage (S/R): (%d/%d)",
                  SS_nsave, SS_nrestore);
            PRINT(stdout, "   Continuations (S/G): (%d/%d)\n",
                  SS_nsetc, SS_ngoc);
            PRINT(stdout, "Memory Usage(A/F): (%ld/%ld)",
                  a, f);
            PRINT(stdout, "   Net (A-F): (%ld)",
		  d);
            PRINT(stdout, "   Time: (%10.3e)\n",
		  evalt);};

        if (SS_post_print_hook != NULL)
           (*SS_post_print_hook)();
        else
           PRINT(stdout, "\n");};}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_END_SCHEME - gracefully exit from Scheme */

void SS_end_scheme(val)
   int val;
   {if (!SS_nullobjp(SS_histdev))
       SS_trans_off();

    switch (val)
       {case ABORT    : exit(1);
        case ERR_FREE : exit(SS_exit_val);};}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_QUIT - exit from Scheme */

object *SS_quit(arg)
   object *arg;
   {SS_exit_val = 0;
    SS_args(arg,
            SC_INTEGER_I, &SS_exit_val,
            0);

    longjmp(SC_top_lev, ERR_FREE);

    return(SS_null);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_INIT_SCHEME - initialize the interpreter */

void SS_init_scheme(Code, Vers)
   char *Code, *Vers;
   {PFVoid force_load;
    HASHTAB *tab;

    PM_enable_fpe(TRUE, (PFSignal_handler) _SS_fpe_handler);

#ifdef SIGFPE
    SIGNAL(SIGFPE, _SS_fpe_handler);
#endif

/* force the loader to load dprint for debugging convenience */
    force_load = dprint;

#ifdef LARGE
    SS_stack_size = 128;
#else
    SS_stack_size = 32;
#endif
    SS_stack_mask = SS_stack_size - 1;

    SS_inst_prm();
    SS_inst_const();

    SS_err_state = SS_null;
    SS_Env       = SS_null;

    tab           = SC_make_hash_table(HSZLARGE, NODOC);
    SS_Global_Env = SS_mk_cons(SS_mk_hash_table(tab), SS_null);
    SS_UNCOLLECT(SS_Global_Env);

    SS_Assign(SS_Env, SS_Global_Env);

    SS_This  = SS_null;
    SS_Exn   = SS_null;
    SS_Val   = SS_null;
    SS_Unev  = SS_null;
    SS_Argl  = SS_null;
    SS_Fun   = SS_null;
    SS_rdobj = SS_null;
    SS_evobj = SS_null;

/* give default values to the lisp package interface variables  */
    SS_post_read_hook  = NULL;
    SS_post_eval_hook  = NULL;
    SS_post_print_hook = NULL;
    SS_pr_ch_in        = SS_get_ch;
    SS_pr_ch_un        = SS_unget_ch;
    SS_pr_ch_out       = SS_put_ch;

    putln           = (PFfprintf) SS_printf;

#ifdef MAC
    getln           = (PFfgets) PG_wind_fgets;
#else
    getln           = io_gets_hook;
#endif

    SS_interactive = TRUE;
    SS_lines_page  = 50;
    SS_print_flag  = TRUE;
    SS_stat_flag   = TRUE;
    SS_nsave       = 0;
    SS_nrestore    = 0;
    SS_nsetc       = 0;
    SS_ngoc        = 0;

    SC_mem_stats_set(0L, 0L);

    sprintf(CV_Banner, " %s  -  %s\n\n", Code, Vers);

    SS_print_err_msg_hook = _SS_print_err_msg;

    SC_init_path(2, "HOME", "SCHEME");

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_INST_CONST - install Scheme constants */

void SS_inst_const()
   {hashel *hp;

    SS_OBJECT_S  = SC_strsavef("object", "char*:SS_INST_CONST:object");
    SS_POBJECT_S = SC_strsavef("object *", "char*:SS_INST_CONST:pobject");

    if ((hp = SC_lookup("quote", SS_symtab)) == NULL)
       {PRINT(ERRDEV, "Error initializing QUOTE\n");
        longjmp(SC_top_lev, ABORT);};  
    SS_quoteproc = (object *) hp->def;
    SS_UNCOLLECT(SS_quoteproc);

    if ((hp = SC_lookup("quasiquote", SS_symtab)) == NULL)
       {PRINT(ERRDEV, "Error initializing QUASIQUOTE\n");
        longjmp(SC_top_lev, ABORT);};  
    SS_quasiproc = (object *) hp->def;
    SS_UNCOLLECT(SS_quasiproc);

    if ((hp = SC_lookup("unquote", SS_symtab)) == NULL)
       {PRINT(ERRDEV, "Error initializing UNQUOTE\n");
        longjmp(SC_top_lev, ABORT);};  
    SS_unqproc = (object *) hp->def;
    SS_UNCOLLECT(SS_unqproc);

    if ((hp = SC_lookup("unquote-splicing", SS_symtab)) == NULL)
       {PRINT(ERRDEV, "Error initializing UNQUOTE-SPLICING\n");
        longjmp(SC_top_lev, ABORT);};  
    SS_unqspproc = (object *) hp->def;
    SS_UNCOLLECT(SS_unqspproc);

    if ((hp = SC_lookup("set!", SS_symtab)) == NULL)
       {PRINT(ERRDEV, "Error initializing SET!\n");
        longjmp(SC_top_lev, ABORT);};  
    SS_setproc = (object *) hp->def;
    SS_UNCOLLECT(SS_setproc);

    SS_null = SS_mk_boolean("nil", FALSE);
    SC_arrtype(SS_null, NULL_OBJ);
    SS_UNCOLLECT(SS_null);
    SC_install("nil", SS_null, SS_POBJECT_S, SS_symtab);

    SS_eof = SS_mk_boolean("#eof", TRUE);
    SC_arrtype(SS_eof, EOF_OBJ);
    SS_UNCOLLECT(SS_eof);
    SC_install("#eof", SS_eof, SS_POBJECT_S, SS_symtab);

    SS_t = SS_mk_boolean("#t", TRUE);
    SS_UNCOLLECT(SS_t);
    SC_install("#t", SS_t, SS_POBJECT_S, SS_symtab);

    SS_f = SS_mk_boolean("#f", FALSE);
    SS_UNCOLLECT(SS_f);
    SC_install("#f", SS_f, SS_POBJECT_S, SS_symtab);

    SS_else = SS_mk_boolean("else", TRUE);
    SS_UNCOLLECT(SS_else);
    SC_install("else", SS_else, SS_POBJECT_S, SS_symtab);

    SS_histdev = SS_null;
    SS_indev = SS_mk_inport(stdin);
    SS_UNCOLLECT(SS_indev);
    SS_outdev = SS_mk_outport(stdout);
    SS_UNCOLLECT(SS_outdev);

/* initialize the stack and the continuation stack */
    SS_init_stack();
    SS_init_cont();

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_INIT_STACK - rewind the stack to the beginning */

void SS_init_stack()
   {SC_INIT_DYNAMIC(SS_stack, SS_stack_size);

    SS_nsave    = 0;
    SS_nrestore = 0;
    SS_stack_ptr = 0;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_INIT_CONT - rewind the continuation stack to the beginning */

void SS_init_cont()
   {int i;

    SS_nsetc = 0;
    SS_ngoc  = 0;

    if ((SS_continue = FMAKE_N(continuation, SS_stack_size,
                       "SS_INIT_CONT:SS_continue")) == NULL)
       longjmp(SC_top_lev, ABORT);
    for (i = 0; i < SS_stack_size; SS_continue[i++].signal = SS_null);
    SS_cont_ptr = 0;

    if ((SS_err_continue = FMAKE_N(err_continuation, SS_stack_size,
                           "SS_INIT_CONT:err_continue")) == NULL)
       longjmp(SC_top_lev, ABORT);
    for (i = 0; i < SS_stack_size; SS_err_continue[i++].signal = SS_null);
    SS_err_cont_ptr = 0;

    if ((SS_err_stack = FMAKE_N(object *, SS_stack_size,
                        "SS_INIT_CONT:err_stack")) == NULL)
       longjmp(SC_top_lev, ABORT);
    for (i = 0; i < SS_stack_size; SS_err_stack[i++] = NULL);
    SS_errlev = 0;

    return;}

/*--------------------------------------------------------------------------*/

/*                      SYMBOL TABLE MANIPULATORS                           */

/*--------------------------------------------------------------------------*/

/* SS_INST_PRM - install the Scheme primitives */

void SS_inst_prm()
   {if (SS_symtab == NULL)
       SS_symtab = SC_make_hash_table(HSZLARGE, DOC);

#ifdef LARGE

    SS_inst_lrg();
    SS_inst_proc();

#endif

/*
 * A
 */
    SS_install("and",
               "Special Form: (and <form> ... <form>), evaluates forms until FALSE is returned",
               SS_sargs,
               SS_Ident, SS_AND);

    SS_install("append",
               "Return a new list made from a copy of the first and the second arguments",
               SS_nargs, 
               SS_append, SS_PR_PROC);

    SS_install("apply",
               "Special Form: cons the procedure onto the args and eval the result",
               SS_sargs,
               SS_Ident, SS_EE_MACRO);

    SS_install("apropos",
               "Procedure: searches the symbol table for documentation",
               SS_nargs,
               SS_apropos, SS_PR_PROC);

    SS_install("assoc",
               "Procedure: Returns the first list whose car is equal? to the first arg",
               SS_nargs,
               SS_assoc, SS_PR_PROC);

    SS_install("assq",
               "Procedure: Returns the first list whose car is eq? to the first arg",
               SS_nargs,
               SS_assq, SS_PR_PROC);

    SS_install("assv",
               "Procedure: Returns the first list whose car is eqv? to the first arg",
               SS_nargs,
               SS_assv, SS_PR_PROC);

/*
 * B
 */
    SS_install("banner",
               "Procedure: print the code system banner",
               SS_nargs,
               SS_banner, SS_PR_PROC);

    SS_install("begin",
               "Special Form: Evaluate a list of forms and returns the value of the last one",
               SS_sargs,
               SS_Ident, SS_BEGIN);

    SS_install("boolean?",
               "Returns #t if the object is a boolean, and #f otherwise",
               SS_sargs, 
               SS_boolp, SS_PR_PROC);

    SS_install("break",
               "Procedure: enter a Scheme break, return with return-level",
               SS_zargs,
               SS_break, SS_PR_PROC);

/*
 * C
 */
    SS_install("caaar",
               "Return the caaar of the argument",
               SS_sargs, 
               SS_caaar, SS_PR_PROC);

    SS_install("caadr",
               "Return the caadr of the argument",
               SS_sargs, 
               SS_caadr, SS_PR_PROC);

    SS_install("caar",
               "Return the caar of the argument",
               SS_sargs, 
               SS_caar, SS_PR_PROC);

    SS_install("cadar",
               "Return the cadar of the argument",
               SS_sargs, 
               SS_cadar, SS_PR_PROC);

    SS_install("caddr",
               "Return the caddr of the argument",
               SS_sargs, 
               SS_caddr, SS_PR_PROC);

    SS_install("cadr",
               "Return the cadr of the argument",
               SS_sargs, 
               SS_cadr, SS_PR_PROC);

    SS_install("car",
               "Return the car of the argument",
               SS_sargs, 
               SS_car, SS_PR_PROC);

    SS_install("call-with-cc",
               "Procedure: pass an escape procedure to the argument, a procedure of one argument",
               SS_sargs,
               SS_catch, SS_PR_PROC);

    SS_install("cdar",
               "Return the cdar of the argument",
               SS_sargs, 
               SS_cdar, SS_PR_PROC);

    SS_install("cdaar",
               "Return the cdaar of the argument",
               SS_sargs, 
               SS_cdaar, SS_PR_PROC);

    SS_install("cdadr",
               "Return the cdadr of the argument",
               SS_sargs, 
               SS_cdadr, SS_PR_PROC);

    SS_install("cddar",
               "Return the cddar of the argument",
               SS_sargs, 
               SS_cddar, SS_PR_PROC);

    SS_install("cdddr",
               "Return the cdddr of the argument",
               SS_sargs, 
               SS_cdddr, SS_PR_PROC);

    SS_install("cddr",
               "Return the cddr of the argument",
               SS_sargs, 
               SS_cddr, SS_PR_PROC);

    SS_install("cdr",
               "Return the cdr of the argument",
               SS_sargs, 
               SS_cdr, SS_PR_PROC);

    SS_install("close-input-file",
               "Procedure: Close the specified input port and release the IN_PORT object",
               SS_sargs,
               SS_cls_in, SS_PR_PROC);

    SS_install("close-output-file",
               "Procedure: Close the specified output port and release the OUT_PORT object",
               SS_sargs,
               SS_cls_out, SS_PR_PROC);

    SS_install("cond",
               "Special Form: (cond (<clause1>) ... (<clausen>))",
               SS_sargs,
               SS_Ident, SS_COND);

    SS_install("cons",
               "Return a new cons whose car and cdr are the arguments",
               SS_nargs, 
               SS_cons, SS_PR_PROC);

/*
 * D
 */
    SS_install("define",
               "Special Form: defines variables and procedures in the current environment",
               SS_sargs,
               SS_Ident, SS_DEFINE);

    SS_install("defined?",
               "Special Form: returns #t if its argument has been defined in the current environment",
               SS_sargs,
               SS_defp, SS_UR_MACRO);

    SS_install("define-macro",
               "Special Form: defines special forms in the current environment",
               SS_sargs,
               SS_Ident, SS_DEFINE);

    SS_install("describe",
               "Procedure: prints the documentation for a procedure to the specified device",
               SS_nargs,
               SS_describe, SS_PR_PROC);

    SS_install("display",
               "Procedure: prints an object to the specified device in human readable form",
               SS_nargs,
               SS_display, SS_PR_PROC);

    SS_install("display-object-table",
               "Procedure: Prints information about all known objects",
               SS_zargs,
               SS_pr_obj_map, SS_PR_PROC);

/*
 * E
 */
    SS_install("eof-object?",
               "Returns #t if the object is the EOF_OBJ, and #f otherwise",
               SS_sargs, 
               SS_eofp, SS_PR_PROC);

    SS_install("eq?",
               "Procedure: Returns #t iff the two objects are identical",
               SS_nargs,
               SS_eq, SS_PR_PROC);

    SS_install("equal?",
               "Procedure: Returns the result of recursively applying eqv? to thearguments",
               SS_nargs,
               SS_equal, SS_PR_PROC);

    SS_install("eqv?",
               "Procedure: Returns #t iff the two objects are equivalent",
               SS_nargs,
               SS_eqv, SS_PR_PROC);

    SS_install("err-catch",
               "Special Form: Calls the given error procedure if the procedure call fails",
               SS_nargs,
               SS_catch_err, SS_UR_MACRO);

    SS_install("eval",
               "Procedure: Evaluates the given form and returns the value",
               SS_sargs,
               SS_exp_eval, SS_PR_PROC);

/*
 * F
 */
    SS_install("file?",
               "Procedure: Returns #t if the object is a file, and #f otherwise",
               SS_nargs,
               SS_filep, SS_PR_PROC);

    SS_install("ascii-file?",
               "Procedure: Returns #t if the object is an ascii file, and #f otherwise",
               SS_nargs,
               SS_ascii_filep, SS_PR_PROC);

    SS_install("for-each",
               "Special Form: applies a procedure over a set of lists",
               SS_nargs,
               SS_foreach, SS_PR_PROC);

/*
 * G
 */
    SS_install("make-new-symbol",
               "Procedure: generate a new symbol",
               SS_sargs,
               SS_newsym, SS_PR_PROC);

/*
 * H
 */

/*
 * I
 */
    SS_install("if",
               "Special Form: (if <pred> <consequent> <alternate>)",
               SS_sargs,
               SS_Ident, SS_IF);

    SS_install("input-port?",
               "Returns #t if the object is an input port (IN_PORT), and #f otherwise",
               SS_sargs, 
               SS_iportp, SS_PR_PROC);

    SS_install("integer?",
               "Returns #t if the object is an integer number, and #f otherwise",
               SS_sargs, 
               SS_intp, SS_PR_PROC);

/*
 * J
 */

/*
 * K
 */

/*
 * L
 */
    SS_install("lambda",
               "Special Form: (lambda (<parameters>) <exp1> ... <expn>)",
               SS_nargs,
               SS_lambda, SS_UR_MACRO);

    SS_install("last",
               "Return the last element of a list or return any other object",
               SS_sargs, 
               SS_last, SS_PR_PROC);

    SS_install("length",
               "Return the number of elements in the given list",
               SS_nargs, 
               SS_length, SS_PR_PROC);

    SS_install("let",
               "Special Form: define local variables using lambda binding",
               SS_nargs,
               SS_let, SS_UE_MACRO);

    SS_install("let*",
               "Special Form: define local variables using lambda binding and maximal scoping",
               SS_nargs,
               SS_letstr, SS_UE_MACRO);

    SS_install("list",
               "Return a new list made up of the arguments",
               SS_nargs, 
               SS_list, SS_PR_PROC);

    SS_install("list-ref",
               "Return the nth element of the list (0 based)",
               SS_nargs, 
               SS_lst_ref, SS_PR_PROC);

    SS_install("list-tail",
               "Return the tail of the list omitting the first n elements",
               SS_nargs, 
               SS_lst_tail, SS_PR_PROC);

    SS_install("load",
               "Procedure: Open a file of Scheme forms and eval all the objects in it\n     Usage: (load <file> [#t])",
               SS_nargs,
               SS_load, SS_PR_PROC);

/*
 * M
 */
    SS_install("map",
               "Special Form: maps a procedure over a set of lists",
               SS_nargs,
               SS_map, SS_PR_PROC);

    SS_install("member",
               "Procedure: Returns the first sublist of the second arg whose car is equal? to the first arg",
               SS_nargs,
               SS_member, SS_PR_PROC);

    SS_install("memq",
               "Procedure: Returns the first sublist of the second arg whose car is eq? to the first arg",
               SS_nargs,
               SS_memq, SS_PR_PROC);

    SS_install("memv",
               "Procedure: Returns the first sublist of the second arg whose car is eqv? to the first arg",
               SS_nargs,
               SS_memv, SS_PR_PROC);

/*
 * N
 */
    SS_install("newline",
               "Procedure: print a <CR><LF> or equivalent to the specified device",
               SS_nargs,
               SS_newline, SS_PR_PROC);

    SS_install("not",
               "Procedure: Returns #t if object is #f and #f for any other object",
               SS_sargs,
               SS_not, SS_PR_PROC);

    SS_install("null?",
               "Procedure: Returns #t iff the object is the empty list, ()",
               SS_sargs,
               SS_nullp, SS_PR_PROC);

    SS_install("number?",
               "Procedure: Returns #t if the object is a number, and #f otherwise",
               SS_sargs,
               SS_numberp, SS_PR_PROC);

/*
 * O
 */
    SS_install("open-input-file",
               "Procedure: Open the specified file for input and return an IN_PORT object",
               SS_sargs,
               SS_opn_in, SS_PR_PROC);

    SS_install("open-output-file",
               "Procedure: Open the specified file for output and return an OUT_PORT object",
               SS_sargs,
               SS_opn_out, SS_PR_PROC);

    SS_install("or",
               "Special Form: (or <form> ... <form>), evaluates forms until TRUE is returned",
               SS_sargs,
               SS_Ident, SS_OR);

    SS_install("output-port?",
               "Returns #t if the object is an output port (OUT_PORT), and #f otherwise",
               SS_sargs, 
               SS_oportp, SS_PR_PROC);

/*
 * P
 */
    SS_install("pair?",
               "Returns #t if the object is a cons or list, and #f otherwise",
               SS_sargs, 
               SS_pair, SS_PR_PROC);

    SS_install("print-toggle",
               "Procedure: Toggle printing of values",
               SS_zargs,
               SS_print_toggle, SS_PR_PROC);

    SS_install("printf",
               "C-like formatted print function: (printf port format . rest)",
               SS_nargs, 
               SS_fprintf, SS_PR_PROC);

    SS_install("procedure?",
               "Returns #t if the object is a procedure object, and #f otherwise",
               SS_sargs, 
               SS_procp, SS_PR_PROC);

/*
 * Q
 */
    SS_install("quasiquote",
               "Special Form: Like quote except that unquote and unquote-splicing forms are eval'd",
               SS_sargs,
               SS_quasiq, SS_UR_MACRO);

    SS_install("quit",
               "Procedure: Exit from Scheme",
               SS_znargs,
               SS_quit, SS_PR_PROC);

    SS_install("quote",
               "Special Form: (quote x) -> x",
               SS_sargs,
               SS_quote, SS_UR_MACRO);

/*
 * R
 */
    SS_install("read",
               "Procedure: reads an ASCII representation of an object and returns the object",
               SS_nargs,
               SS_read, SS_PR_PROC);

    SS_install("real?",
               "Returns #t if the object is a real number, and #f otherwise",
               SS_sargs, 
               SS_realp, SS_PR_PROC);

    SS_install("reset",
               "Procedure: unwinds the Error/Break stack and returns to top level",
               SS_zargs,
               SS_reset, SS_PR_PROC);

    SS_install("return-level",
               "Procedure: pops n levels off the Error/Break stack and returns the second arg as value",
               SS_nargs,
               SS_retlev, SS_PR_PROC);

    SS_install("reverse",
               "Destructively reverse the list and return it",
               SS_sargs, 
               SS_reverse, SS_PR_PROC);

/*
 * S
 */
    SS_install("set!",
               "Special Form: binds variable to value in current environment",
               SS_sargs,
               SS_Ident, SS_SET);

    SS_install("set-car!",
               "Procedure: Replace the car of the first argument with the second and return the new car",
               SS_nargs,
               SS_setcar, SS_PR_PROC);

    SS_install("set-cdr!",
               "Procedure: Replace the cdr of the first argument with the second and return the new cdr",
               SS_nargs,
               SS_setcdr, SS_PR_PROC);

    SS_install("sprintf",
               "C style sprintf string builder function: (sprintf format . rest)",
               SS_nargs, 
               SS_sprintf, SS_PR_PROC);

    SS_install("stats-toggle",
               "Procedure: Toggle printing of statistics",
               SS_zargs,
               SS_stats_toggle, SS_PR_PROC);

    SS_install("string?",
               "Returns #t if the object is a string, and #f otherwise",
               SS_sargs, 
               SS_strp, SS_PR_PROC);

    SS_install("symbol?",
               "Returns #t if the object is a variable, and #f otherwise",
               SS_sargs, 
               SS_varp, SS_PR_PROC);

    SS_install("system",
               "Procedure: invokes the operation system to process the given string as a command line",
               SS_sargs,
               SS_system, SS_PR_PROC);

/*
 * T
 */
    SS_install("time",
               "Procedure: return current time as (yy mm dd hh mm ss)",
               SS_zargs,
               SS_time, SS_PR_PROC);

    SS_install("trace",
               "Procedure: 'trace's calls to the procedures in the list of arguments",
               SS_nargs,
               SS_trace, SS_PR_PROC);

    SS_install("transcript-off",
               "Procedure: close the transcript file to stop recording a Scheme session",
               SS_zargs,
               SS_trans_off, SS_UR_MACRO);

    SS_install("transcript-on",
               "Procedure: open the specified transcript file to start recording a Scheme session",
               SS_sargs,
               SS_trans_on, SS_PR_PROC);

/*
 * U
 */
    SS_install("unquote",
               "Special Form: In a quasiquote'd form inserts the result of evaluating\n its argument",
               SS_sargs,
               SS_unquote, SS_UR_MACRO);

    SS_install("unquote-splicing",
               "Special Form: In a quasiquote'd form splices the eval'd list into the quoted form",
               SS_sargs,
               SS_unq_spl, SS_UR_MACRO);

    SS_install("untrace",
               "Procedure: removes the 'trace' from the procedures in the argument list",
               SS_nargs,
               SS_untrace, SS_PR_PROC);

/*
 * V
 */

/*
 * W
 */
    SS_install("write",
               "Procedure: puts the printed representation of an object to the specified device",
               SS_nargs,
               SS_write, SS_PR_PROC);

/*
 * X
 */

/*
 * Y
 */

/*
 * Z
 */

    SS_install_math();

    return;}

/*--------------------------------------------------------------------------*/

/*                              ERROR HANDLERS                              */

/*--------------------------------------------------------------------------*/

/* SS_PUSH_ERR - push an error stack frame */

void SS_push_err(flag, type)
   int flag, type;
   {object *x;

    SS_save_registers(flag);

    x = SS_mk_esc_proc(SS_cont_ptr, SS_stack_ptr, SS_errlev, type);
    SS_MARK(x);
    SS_err_stack[SS_errlev] = x;

    SS_errlev = (SS_errlev + 1) & SS_stack_mask;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_POP_ERR - pop an error stack frame and restore the state of the
 *            - interpreter to the time that the frame was pushed
 *            - return the escape procedure object associated with the
 *            - correct error stack frame
 */

object *SS_pop_err(n, flag)
   int n, flag;
   {object *x;

    if (SS_errlev < 1)
       {PRINT(stdout, "\nERROR: ERROR STACK BLOWN - SS_POP_ERR\n\n");
        exit(1);};

/* GC the other error stack frames */
    while (TRUE)
       {x = SS_err_stack[--SS_errlev];
        SS_err_stack[SS_errlev] = NULL;
        if (SS_errlev <= n)
           {_SS_restore_state(x);
            break;}
        else
           SS_GC(x);};

    SS_restore_registers(flag);

    return(x);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_FPE_HANDLER - handle floating point exception signals */

static void _SS_fpe_handler(sig, code)
   int sig, code;
   {

#ifdef SIGFPE
    SIGNAL(SIGFPE, _SS_fpe_handler);
#endif

    SS_error("FLOATING POINT EXCEPTION - _SS_FPE_HANDLER",
	     SS_mk_cons(SS_Fun, SS_Argl));

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_INTERRUPT_HANDLER - handle interrupts for SCHEME */

void SS_interrupt_handler(sig)
   int sig;
   {char bf[MAXLINE], *cmnd, *arg, *t;
    int nl;
    object *argl;

    SIGNAL(SIGINT, SS_interrupt_handler);

    PRINT(stdout, "\n\nInterrupt (%d frames):\n", SS_errlev - 1);
    PRINT(stdout, "  a     - Reset to starting frame\n");
    PRINT(stdout, "  b     - Enter SCHEME break\n");
    PRINT(stdout, "  r     - Resume from here\n");
    PRINT(stdout, "  u <n> - Return n levels\n");
    PRINT(stdout, "  q     - Quit\n");
    PRINT(stdout, "\nI-> ");
    GETLN(bf, MAXLINE, stdin);
    cmnd = SC_strtok(bf, " \t\n\r", t);
    arg  = SC_strtok(bf, " \t\n\r", t);

#ifndef MAC

    io_flush(stdout);

#endif

    switch (cmnd[0])
       {case 'r' : PRINT(stdout, "\nResuming\n\n");
                   break;

        case 'a' : PRINT(stdout, "\nResetting\n\n");
                   SS_reset();
                   break;

        case 'b' : PRINT(stdout, "\nEntering SCHEME break\n\n");
                   t = SS_BUFFER(SS_indev);
                   SS_PTR(SS_indev) = t;
                   *t = '\0';
                   SS_break();
                   break;

        case 'u' : nl = SC_stoi(arg);
                   PRINT(stdout, "\nReturning %d frames\n\n", 2*nl);
                   argl = SS_mk_cons(SS_mk_integer(nl),
                                     SS_mk_cons(SS_t, SS_null));
                   SS_retlev(argl);
                   break;

        default  : 
        case 'q' : PRINT(stdout, "\nExiting\n\n");
                   exit(1);};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_ERR_CATCH - execute the function specified by the first argument
 *              - in an environment which catches errors from SS_error
 *              - if there is an error execute the function specified by
 *              - the second argument
 *              - return TRUE if the ABORT branch is not taken
 */

int SS_err_catch(func, errf)
   PFInt func, errf;
   {object *esc;
    int ret;

    ret = TRUE;
    SS_cont_ptr++;
    SS_push_err(FALSE, ERR_OBJ);
    switch (setjmp(SS_continue[SS_cont_ptr].cont))
       {case ABORT     : if (errf != NULL)
                            ret = (*errf)();
                         else
                            ret = FALSE;
                         break;

        case RETURN_OK : break;

        default        : if (func != NULL)
                            ret = (*func)();

        case ERR_FREE  : esc = SS_pop_err(SS_errlev - 1, FALSE);
                         SS_GC(esc);};

    SS_cont_ptr--;

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_ERROR - signal an error
 *          - create a higher level REPL and push on
 */

void SS_error(s, obj)
   char *s;
   object *obj;
   {FILE *str;
    object *esc;
    char *t;
    int nc;
/*
    qargs = SS_make_list(SS_OBJECT_I, SS_quoteproc,
                         SS_OBJECT_I, SS_Argl,
                         0);
    qobj  = SS_make_list(SS_OBJECT_I, SS_quoteproc,
                         SS_OBJECT_I, obj,
                         0);
    SS_Assign(SS_err_state, SS_make_list(SS_OBJECT_I, SS_Fun,
                                         SS_OBJECT_I, qargs,
                                         SS_OBJECT_I, qobj,
                                         0));
*/
    SS_Assign(SS_err_state, SS_make_list(SS_OBJECT_I, SS_Fun,
                                         SS_OBJECT_I, SS_Argl,
                                         SS_OBJECT_I, obj,
                                         SC_STRING_I, s,
                                         0));

    str = SS_OUTSTREAM(SS_outdev);
    if (SS_print_err_msg_hook != NULL)
       SS_PRINT_ERR_MSG(str, s, obj);

    t = SS_BUFFER(SS_indev);
    SS_PTR(SS_indev) = t;
    *t = '\0';

    esc = SS_pop_err(SS_errlev - 1, FALSE);
    nc  = SS_ESCAPE_CONTINUATION(esc);
    SS_GC(esc);

    longjmp(SS_continue[nc].cont, ABORT);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_BREAK - enter a Scheme break from the Scheme level
 *          - return with return-level or reset
 *          - create a higher level REPL and push on
 */

object *SS_break()
   {SS_Save(SS_evobj);
    SS_Save(SS_rdobj);

    SS_push_err(TRUE, ERR_OBJ);
    PRINT(stdout,"\n");

    _SS_repl();

    return(SS_t);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_RETLEV - pops n levels off the error/break stack and
 *           - returns the second arg as value
 *           - GOTCHA: there are residual GC issues here
 */

object *SS_retlev(argl)
   object *argl;
   {int n;
    object *x, *val;

    x    = SS_car(argl);
    argl = SS_cdr(argl);
    if (!SS_integerp(x))
       SS_error("FIRST ARG MUST BE AN INTEGER - SS_RETLEV", x);

    n = (int) SS_INTEGER_VALUE(x);
    n = SS_errlev - n;
    n = max(1, n);

    if (!SS_consp(argl))
       SS_error("SECOND ARG MISSING - SS_RETLEV", x);
    val = SS_car(argl);    

    if (SS_errlev > 1)
       {x = SS_pop_err(n, TRUE);

        SS_Restore(SS_rdobj);
        SS_Restore(SS_evobj);

        x = SS_exp_eval(SS_mk_cons(x,
                                   SS_mk_cons(SS_mk_cons(SS_quoteproc,
                                                         SS_mk_cons(val,
                                                                    SS_null)),
                                              SS_null)));}
    else
       x = SS_f;

    return(x);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_RESET - unwind the error/break stack and return to top level */

object *SS_reset()
   {_SS_restore_state_prim(0, 1, 0);
    PRINT(stdout,"\n");

    longjmp(SS_continue[1].cont, ABORT);
/*    longjmp(SS_continue[1].cont, RETURN_OK); */

    return(SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_RESTORE_STATE - restore the state of Scheme to that
 *                   - implied by the given escape procedure
 */

void _SS_restore_state(esc_proc)
   object *esc_proc;
   {int ns, nc, ne;

    ns = SS_ESCAPE_STACK(esc_proc);
    nc = SS_ESCAPE_CONTINUATION(esc_proc);
    ne = SS_ESCAPE_ERROR(esc_proc);

    _SS_restore_state_prim(ns, nc, ne);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_RESTORE_STATE_PRIM - do the actual work of restoring the state
 *                        - of the interpreter
 */

static void _SS_restore_state_prim(ns, nc, ne)
   int ns, nc, ne;
   {object *x, *esc;

/* restore the stack */
    if (SS_stack_ptr < ns)
       SS_error("CORRUPT STACK FRAME - _SS_RESTORE_STATE_PRIM", SS_null);

    for (; SS_stack_ptr > ns; SS_stack_ptr--)
        {SS_nrestore++;
         x = SC_GET_NTH_DYNAMIC(object *, SS_stack, SS_stack_ptr);
         SC_SET_NTH_DYNAMIC(object *, SS_stack, SS_stack_ptr, NULL);
         SS_stack.n--;
         SS_GC(x);};

/* restore the continuation stack */
    if (SS_cont_ptr < nc)
       SS_error("CORRUPT CONTINUATION FRAME - _SS_RESTORE_STATE_PRIM",
                SS_null);

    for (; SS_cont_ptr > nc; SS_cont_ptr--)
        {SS_ngoc++;
         SS_Assign(SS_continue[SS_cont_ptr].signal, SS_null);};

/* restore the error stack */
    if (SS_errlev < ne)
       SS_error("CORRUPT ERROR FRAME - _SS_RESTORE_STATE_PRIM", SS_null);

    for (; SS_errlev > ne; SS_errlev--)
        {esc = SS_err_stack[SS_errlev-1];
         SS_err_stack[SS_errlev-1] = NULL;
         SS_GC(esc);};

    sprintf(SS_ans_prompt, "(%d): ", SS_errlev - 1);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_PRINT_ERR_MSG - default error message print function for
 *                   - SS_print_err_msg_hook
 */

void _SS_print_err_msg(str, s, obj)
   FILE *str;
   char *s;
   object *obj;
   {PRINT(str, "(%d):  ERROR: %s\n      BAD OBJECT (", SS_errlev, s);
    switch (SC_arrtype(obj, -1))
       {default             : PRINT(str, "unknown");
                              break;
        case  SC_INTEGER_I  : PRINT(str, "integer");
                              break;
        case  SC_FLOAT_I    : PRINT(str, "float");
                              break;
        case  SC_STRING_I   : PRINT(str, "string");
                              break;
        case  CONS          : PRINT(str, "cons");
                              break;
        case  VARIABLE      : PRINT(str, "variable");
                              break;
        case  PROC_OBJ      : PRINT(str, "proc_obj");
                              break;
        case  BOOLEAN       : PRINT(str, "boolean");
                              break;
        case  IN_PORT       : PRINT(str, "in_port");
                              break;
        case  OUT_PORT      : PRINT(str, "out_port");
                              break;
        case  EOF_OBJ       : PRINT(str, "eof_obj");
                              break;
        case  ERR_OBJ       : PRINT(str, "err_obj");
        case  NULL_OBJ      : break;
        case  '\0'          : PRINT(str,
                                    "0x0): POINTER 0x%lx IS FREE\n\n",
                                    (long) (obj - (object *) NULL));
                              return;};

    _SS_print(obj, "): ", "\n\n", SS_outdev);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SS_PRINT_ERR_MSG_A - alternate error message print function for
 *                     - SS_print_err_msg_hook
 */

void _SS_print_err_msg_a(str, s, obj)
   FILE *str;
   char *s;
   object *obj;
   {PRINT(str, "ERROR : %s : ", s);

    if (SC_arrtype(obj, -1) == 0)
       PRINT(str, "MEMORY PROBABLY CORRUPTED\n");
    else
       _SS_print(obj, "", "\n", SS_outdev);

    _SS_print(SS_Fun, "CURRENT FUNCTION: ", "\n\n", SS_outdev);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SS_SYSTEM - pass command to operating system from Scheme */

object *SS_system(obj)
   object *obj;
   {if (!SS_stringp(obj))
       SS_error("BAD STRING TO SYSTEM", obj);
    SYSTEM(SS_STRING_TEXT(obj));

    return(SS_t);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
