/*
 * GSTXTS.C - test of graphics library
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"

#include "pgs.h"

static void
 SC_DECLARE(sf_dt,
         (PG_device *dev, double x1, double y1, char *face, char *style,
          int size)),
 SC_DECLARE(test_dev, (PG_device *dev));

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

main(argc, argv)
   int argc;
   char *argv[];
   {char s[MAXLINE], *token;
    PG_device *SCR_dev, *PS_dev, *CGM_dev;
    REAL x1, y1, x2, y2, dx, dy;
    char *face, *style;
    int size;

/* connect the I/O functions */
    PG_open_console("PGS Test", "COLOR", TRUE, 0.1, 0.7, 0.5, 0.3);

    SCR_dev = PG_make_device("WINDOW", "COLOR", "PGS Test");
    PG_open_device(SCR_dev, 0.1, 0.1, 0.5, 0.6);
    PG_set_viewport(SCR_dev, 0.1, 0.9, 0.2, 0.8);
    PG_set_window(SCR_dev, 0.0, 1.0, 0.0, 1.0);
    PG_draw_box(SCR_dev, -0.02, 1.02, -0.02, 1.02);

    CGM_dev = PG_make_device("CGM", "MONOCHROME", "gstxts");
    PG_open_device(CGM_dev, 0.1, 0.1, 0.8, 0.8);

    PS_dev = PG_make_device("PS", "MONOCHROME", "gstxts");
    PG_open_device(PS_dev, 0.1, 0.1, 0.8, 1.1);

    PG_expose_device(PG_console_device);

    PG_clear_window(SCR_dev);
    PG_clear_window(CGM_dev);
    PG_clear_window(PS_dev);

    test_dev(SCR_dev);
    test_dev(CGM_dev);
    test_dev(PS_dev);

    PG_finish_plot(SCR_dev);
    PG_finish_plot(CGM_dev);
    PG_finish_plot(PS_dev);

    SC_pause();
#if 0
    while (TRUE)
       {char *s;

	PG_make_device_current(SCR_dev);
        PG_update_vs(SCR_dev);

        PRINT(STDOUT, "ENTER x1, y1, face, style, size: ");

        GETLN(s, MAXLINE, stdin);
        if ((token = SC_strtok(s, " ,\r\n", s)) != NULL)
           {x1 = ATOF(token);
            if ((token = SC_strtok(NULL, " ,\r\n", s)) != NULL)
               {y1 = ATOF(token);
                if ((face = SC_strtok(NULL, " ,\r\n", s)) != NULL)
                   {if ((style = SC_strtok(NULL, " ,\r\n", s)) != NULL)
                       {if ((token = SC_strtok(NULL, " ,\r\n", s)) != NULL)
                           size = ATOF(token);
                        else
                           size = 12;}
                    else
                       {style = "medium";
                        size  = 12;};}
                else
                   {face  = "times";
                    style = "medium";
                    size  = 12;};};}
        else
           break;

        PG_clear_viewport(SCR_dev);

        PG_set_font(SCR_dev, face, style, size);

        PG_get_text_ext(SCR_dev, "foo", &dx, &dy);
        x2 = x1 + dx;
        y2 = y1 + dy;

/* write some marks */
/*
        x[0] = 0.5*(x1+x2);
        y[0] = y1 - 0.1*dy;
        PG_draw_markers(SCR_dev, 1, x, y, 1);

        x[0] = x1 - 0.1*dx;
        y[0] = 0.5*(y1+y2);
        PG_draw_markers(SCR_dev, 1, x, y, 0);
*/
/* write some text and draw a box around it */
        PG_write_WC(SCR_dev, x1, y1, "%s", "foo");
        PG_draw_box(SCR_dev, x1, x2, y1, y2);

        PG_update_vs(SCR_dev);};
#endif

    PG_close_device(SCR_dev);
    PG_close_device(CGM_dev);
    PG_close_device(PS_dev);

    return(0);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SF_DT - set the font and draw the text */

static void sf_dt(dev, x1, y1, face, style, size)
   PG_device *dev;
   double x1, y1;
   char *face, *style;
   int size;
   {REAL x2, y2, dx, dy;

    PG_set_font(dev, face, style, size);

    PG_get_text_ext(dev, "foo", &dx, &dy);

/* write some text and draw a box around it */
    PG_write_WC(dev, x1, y1, "%s", "foo");

    x2 = x1 + dx;
    y2 = y1 + dy;
    PG_draw_box(dev, x1, x2, y1, y2);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* TEST_DEV - test the entire device */

static void test_dev(dev)
   PG_device *dev;
   {PG_set_color_line(dev, dev->BLACK, TRUE);
    PG_set_color_text(dev, dev->BLACK, TRUE);

    sf_dt(dev, .1, .9, "helvetica", "medium", 12);
    sf_dt(dev, .1, .8, "helvetica", "italic", 12);
    sf_dt(dev, .1, .7, "helvetica", "bold", 12);
    sf_dt(dev, .1, .6, "helvetica", "bold-italic", 12);

    sf_dt(dev, .1, .50, "helvetica", "medium", 10);
    sf_dt(dev, .1, .45, "helvetica", "italic", 10);
    sf_dt(dev, .1, .40, "helvetica", "bold", 10);
    sf_dt(dev, .1, .35, "helvetica", "bold-italic", 10);

    sf_dt(dev, .1, .30, "helvetica", "medium", 8);
    sf_dt(dev, .1, .25, "helvetica", "italic", 8);
    sf_dt(dev, .1, .20, "helvetica", "bold", 8);
    sf_dt(dev, .1, .15, "helvetica", "bold-italic", 8);

    sf_dt(dev, .3, .9, "times", "medium", 12);
    sf_dt(dev, .3, .8, "times", "italic", 12);
    sf_dt(dev, .3, .7, "times", "bold", 12);
    sf_dt(dev, .3, .6, "times", "bold-italic", 12);

    sf_dt(dev, .3, .50, "times", "medium", 10);
    sf_dt(dev, .3, .45, "times", "italic", 10);
    sf_dt(dev, .3, .40, "times", "bold", 10);
    sf_dt(dev, .3, .35, "times", "bold-italic", 10);

    sf_dt(dev, .3, .30, "times", "medium", 8);
    sf_dt(dev, .3, .25, "times", "italic", 8);
    sf_dt(dev, .3, .20, "times", "bold", 8);
    sf_dt(dev, .3, .15, "times", "bold-italic", 8);

    sf_dt(dev, .5, .9, "courier", "medium", 12);
    sf_dt(dev, .5, .8, "courier", "italic", 12);
    sf_dt(dev, .5, .7, "courier", "bold", 12);
    sf_dt(dev, .5, .6, "courier", "bold-italic", 12);

    sf_dt(dev, .5, .50, "courier", "medium", 10);
    sf_dt(dev, .5, .45, "courier", "italic", 10);
    sf_dt(dev, .5, .40, "courier", "bold", 10);
    sf_dt(dev, .5, .35, "courier", "bold-italic", 10);

    sf_dt(dev, .5, .30, "courier", "medium", 8);
    sf_dt(dev, .5, .25, "courier", "italic", 8);
    sf_dt(dev, .5, .20, "courier", "bold", 8);
    sf_dt(dev, .5, .15, "courier", "bold-italic", 8);

    PG_update_vs(dev);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
