/*
 * GSDV_IM.C - PGS IMAGE routines
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
#include "pgs.h"
#include "gsrast.h"

#define PG_DPMT_IMAGE 35

/* to use the IMAGE device issue a call
 *
 *   PG_register_device("IMAGE", PG_setup_image_device);
 *
 */

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_TRANSMIT_IMAGES - transmit images between nodes */

static PG_image *_PG_transmit_images(dev, im)
   PG_device *dev;
   PG_image *im;
   {int i, ip, np, dp, nb, pw, dfl;
    int *map;
    PROCESS *pp;
    PG_par_rend_info *pri;
    PG_image *pim;
    static int sp[] = {PC_MATCH_NODE, 1, 0,
		       PC_MATCH_TAG, PG_DPMT_IMAGE,
		       PC_BLOCK_STATE, FALSE,
		       PC_BUFFER_SIZE, 0,
		       0};

    if (PG_parallel_simulate)
       {ip = PG_get_processor_number();
	np = PG_get_number_processors();
	dp = dev->pri->ip;

/* post the receives */
	if (ip == dp)
	   {pim = FMAKE_N(PG_image, np, "_PG_TRANSMIT_IMAGES:pim");

	    for (i = 0; i < np; i++)
	        pim[i] = *im;

	    SC_mark(im->label, np);
	    SC_mark(im->element_type, np);
	    SC_mark(im->buffer, np);};}

    else
       {ip  = PG_get_processor_number();
	np  = PG_get_number_processors();
	pri = dev->pri;
	pp  = pri->pp;
	dp  = pri->ip;
	map = pri->map;
	dfl = pri->have_data;

	pw = max(dev->window_width, dev->window_height);
	nb = 1.5*(sizeof(PG_image) + 2*MAXLINE + pw*pw/np);

	sp[6] = FALSE;
	sp[8] = nb;

/* post the receives */
	if (ip == dp)
	   {pim = FMAKE_N(PG_image, np, "_PG_TRANSMIT_IMAGES:pim");
	    if ((_SC_zero_space != 1) && (_SC_zero_space != 2))
	       memset(pim, 0, np*sizeof(PG_image));

	    for (i = 0; i < np; i++)
	        {if ((i != dp) && (map[i] == TRUE))
		    {sp[2] = i;
		     PC_in(pim+i, "PG_image", 1, pp, sp);};};

	    if (dfl)
	       pim[dp] = *im;}

/* post the sends */
	else if (dfl)
	   {pim         = NULL;
	    im->palette = NULL;
	    sp[2] = dp;
	    PC_out(im, "PG_image", 1, pp, sp);};

	PC_wait(pp);};

    return(pim);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_DISPLAY_IMAGE - receive and assemble an image from other nodes
 *                   - once it is assembled draw it
 */

static void _PG_display_image(dev, pim)
   PG_device *dev;
   PG_image *pim;
   {int i, np, bpp, kmx, lmx, render;
    int *map;
    double xmn, xmx, ymn, ymx, zmn, zmx;
    double xn, xx, yn, yx, zn, zx;
    char *cpn, *labl, type[MAXLINE];
    PG_image *im, *nim, *tim;
    PG_par_rend_info *pri;
    PG_device *dd;
    extern void SC_DECLARE(PG_render_parallel,
			   (PG_device *dd, PG_image *nim, int np,
			    PG_image *pim));

    PG_get_device_image(dev, im);

    np = PG_get_number_processors();

    pri = dev->pri;
    if (pri != NULL)
       {render = pri->render;
	map    = pri->map;
	dd     = pri->dd;
	if (dd != NULL)
	   {labl = pri->label;
	    bpp  = im->bits_pixel;
	
	    strcpy(type, im->element_type);
	    PD_dereference(type);

/* get the single image specs */
	    xmn = HUGE;
	    xmx = -HUGE;
	    ymn = HUGE;
	    ymx = -HUGE;
	    zmn = HUGE;
	    zmx = -HUGE;
	    for (i = 0; i < np; i++)
	        {if (map[i])
		    {tim = pim + i;
		     xn  = tim->xmin;
		     xx  = tim->xmax;
		     yn  = tim->ymin;
		     yx  = tim->ymax;
		     zn  = tim->zmin;
		     zx  = tim->zmax;
		     xmn = min(xmn, xn);
		     xmx = max(xmx, xx);
		     ymn = min(ymn, yn);
		     ymx = max(ymx, yx);
		     zmn = min(zmn, zn);
		     zmx = max(zmx, zx);};};

	    for (i = 0; i < np; i++)
	        {if (map[i])
		    {tim = pim + i;
		     if (render == PLOT_CURVE)
		        {xn  = tim->xmin;
			 xx  = tim->xmax;
			 kmx = tim->kmax*(xmx - xmn)/(xx - xn);
			 lmx = tim->lmax;}
		     else
		        {xn  = tim->xmin;
			 xx  = tim->xmax;
			 yn  = tim->ymin;
			 yx  = tim->ymax;
			 kmx = tim->kmax*(xmx - xmn)/(xx - xn);
			 lmx = tim->lmax*(ymx - ymn)/(yx - yn);};
		     break;}};

	    cpn = dev->current_palette->name;

/* make the single image */
	    nim = PG_make_image(labl, type, NULL,
				xmn, xmx, ymn, ymx, zmn, zmx,
				kmx, lmx, bpp,
				PG_set_palette(dd, cpn));

	    memset(nim->buffer, dd->BLACK, nim->size);

/* assemble the images into a single image for plotting */
	    for (i = 0; i < np; i++)
	        {if (map[i])
		    {tim = pim + i;
		     PG_copy_image(nim, tim, dd->BLACK);};};

/* prevent rescaling the image data by NULLing the type */
	    SFREE(nim->element_type);

	    PG_set_window(dd, xmn, xmx, ymn, ymx);
	    PG_render_parallel(dd, nim, np, pim);

	    SFREE(pri->label);};};

/* cleanup */
    for (i = 0; i < np; i++)
        {SFREE(pim[i].buffer);
	 SFREE(pim[i].element_type);
	 SFREE(pim[i].label);};

    SFREE(pim);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_IM_FINISH_PLOT - do what's necessary to finish up a graphical image
 *                    - and get the device updated with the image
 *                    - after this function nothing more can be added to
 *                    - the image
 */
 
static void _PG_IM_finish_plot(dev)
   PG_device *dev;
   {int ip;
    REAL zmn, zmx;
    REAL *rextr;
    PG_image *im, *pim;

    PG_get_device_image(dev, im);
    if (im != NULL)
       {PG_rl_image(im);
	PG_put_device_image(dev, NULL);};

    rextr = dev->range_extrema;
    if (rextr != NULL)
       {zmn = rextr[0];
	zmx = rextr[1];}

    else
       {zmn = 0.0;
	zmx = 1.0;};

    im = PG_extract_image(dev, 0, 0, 0, 0, zmn, zmx);

    PG_put_device_image(dev, im);

/* send the images around */
    pim = _PG_transmit_images(dev, im);

/* put them all together */
    ip = PG_get_processor_number();
    if (ip == dev->pri->ip)
       _PG_display_image(dev, pim);

    PG_rl_image(im);
    PG_put_device_image(dev, NULL);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_IM_OPEN - initialize a IMAGE device */
 
static PG_device *_PG_IM_open(dev, xf, yf, dxf, dyf)
   PG_device *dev;
   double xf, yf, dxf, dyf;
   {int Lightest, Light, Light_Gray, Dark_Gray, Dark, Darkest;
    int display_width, display_height, n_colors, re_open;
    REAL intensity;
    REAL view_x_max, view_y_max;
    PG_par_rend_info *pri;
    PG_font_family *ff;
    frame *fr;
    PG_RAST_device *rdev;

    re_open = (dev->window_width != 0);

    if (!re_open)
       {pri = dev->pri;
        if (pri->dd != NULL)
	   PG_open_device(pri->dd, xf, yf, dxf, dyf);

	PG_setup_markers();

	dev->type_index       = IMAGE_DEVICE;
	dev->quadrant         = QUAD_ONE;
	dev->hard_copy_device = FALSE;
	dev->print_labels     = FALSE;};

/* get the window shape in NDC */
    if (dxf < 2.0)
       dxf = 400.0;

    if (dyf < 2.0)
       dyf = 400.0;

    _PG_rst_set_dev_prop(dev, (int) dxf, (int) dyf, N_RAST_COLOR);

    if (re_open)
       {GET_RAST_DEVICE(dev, rdev);
	PG_free_raster_device(rdev);};

    fr   = NULL;
    rdev = PG_make_raster_device((int) dxf, (int) dyf, dev->title,
				 fr, FALSE, NULL);

    SET_RAST_DEVICE(dev, rdev);

    PG_clear_window(dev);

    PG_query_screen(dev, &display_width, &display_height, &n_colors);

/* set device pixel coordinate limits */
    dev->min_pc_x = SHRT_MIN + display_width;
    dev->max_pc_x = SHRT_MAX - display_width;
    dev->min_pc_y = SHRT_MIN + display_height;
    dev->max_pc_y = SHRT_MAX - display_height;
 
    dev->window_x      = 0.0;
    dev->window_y      = 0.0;
    dev->window_width  = display_width;
    dev->window_height = display_width;

    dev->window_x_off  = dev->window_x;
    dev->window_y_off  = dev->window_y;

    if (!re_open)
       {Color_Map(dev, 1, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15);

	dev->ncolor = N_RAST_COLOR;
	dev->absolute_n_color = N_RAST_COLOR;

/* compute the view port */
	if (dev->view_x == 0.0)
	   {dev->view_x = 0.175;
	    dev->view_y = 0.175;};

	if (dev->view_width == 0.0)
	   dev->view_width = 0.65;

	if (dev->view_height == 0.0)
	   dev->view_height = 0.65;

	view_x_max = dev->view_x + dev->view_width;
	view_y_max = dev->view_y + dev->view_height;

/* set the view port */
	PG_set_viewport(dev, dev->view_x, view_x_max, dev->view_y, view_y_max);
	PG_set_window(dev, 0.0, 1.0, 0.0, 1.0);
 
/* initialize fonts */
	ff = PG_make_font_family(dev, "helvetica", NULL, 4,
				 "Helvetica",
				 "Helvetica-Oblique",
				 "Helvetica-Bold",
				 "Helvetica-BoldOblique");

	ff = PG_make_font_family(dev, "times", ff, 4,
				 "Times-Roman",
				 "Times-Italic",
				 "Times-Bold",
				 "Times-BoldItalic");

	ff = PG_make_font_family(dev, "courier", ff, 4,
				 "Courier",
				 "Courier-Oblique",
				 "Courier-Bold",
				 "Courier-BoldOblique");

	dev->font_family = ff;

	PG_set_font(dev, "helvetica", "medium", 12);

/* put in the default palettes */
	intensity  = dev->max_intensity*MAXPIX;
	Lightest   = 0;
	Light      = intensity;
	Light_Gray = 0.8*intensity;
	Dark_Gray  = 0.5*intensity;
	Dark       = 0;
	Darkest    = intensity;

	PG_setup_standard_palettes(dev, 64,
				   Light, Dark,
				   Light_Gray, Dark_Gray,
				   Lightest, Darkest);

	getln = (PFfgets) io_gets_hook;
	putln = (PFfprintf) io_printf_hook;};

    return(dev);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_IM_CLOSE_DEVICE - close a device */
 
static void _PG_IM_close_device(dev)
   PG_device *dev;
   {PG_RAST_device *rdv;
    PG_image *im;

    PG_get_device_image(dev, im);
    if (im != NULL)
       {PG_rl_image(im);
	PG_put_device_image(dev, NULL);};

    GET_RAST_DEVICE(dev, rdv);

    _PG_free_frame(rdv->inner_frame);
    SFREE(rdv->out_fname);
    SFREE(rdv);

/* clean up the device */
   _PG_rl_device(dev);

   return;}

/*--------------------------------------------------------------------------*/

/*                              PGS INTERFACE ROUTINES                      */

/*--------------------------------------------------------------------------*/
 
/* PG_SETUP_IMAGE_DEVICE - do the device dependent device initialization
 *                       - for PG_make_device
 */

void PG_setup_image_device(d)
   PG_device *d;
   {

    PG_setup_raster_device(d);

    d->type_index   = IMAGE_DEVICE;
    d->close_device = _PG_IM_close_device;
    d->finish_plot  = _PG_IM_finish_plot;
    d->open_screen  = _PG_IM_open;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
