/*
 * PAGNRD.C - Generator core for PANACEA
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
 
#include "panace.h"
 
static char
 PA_input_bf[MAXLINE],
 *_PA_gen_rsname = NULL; /* communicate the restart name between readh and wrrstrth */

static FILE
 *PA_input_stream,
 **infile_lst = NULL;

static int
 _PA_input_flag = FALSE,
 n_infiles = 0,
 nx_infiles = 0;

HASHTAB
 *PA_alias_tab,
 *PA_commands;
 
PA_plot_request
 *plot_reqs = NULL;

PA_iv_specification
 *iv_spec_lst;

static pcons
 *ivlst;

char
 *PA_strtok_p,
 *PAN_COMMAND;
 
int
 ivnum,
 N_graphs,
 N_plots,
 STAND_ALONE;

double
 SC_DECLARE(PA_alias_value, (char *s));

void
 SC_DECLARE(_PA_init_cont, (byte));

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_INST_PCK_GEN_CMMNDS - install the generator commands which each
 *                        - package needs and provides
 */

void PA_inst_pck_gen_cmmnds()
   {PA_package *pck;
    PFInt pck_cmd;

/* loop over all packages */
    for (pck = Packages; pck != NULL; pck = pck->next)
        {pck_cmd  = pck->gencmd;

/* execute the package generator command installers */
         if (pck_cmd != NULL)
            {PA_control_set(pck->name);
             (*pck_cmd)();};};

/* reconnect the global controls */
    PA_control_set("global");

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_INTERN_PCK_DB - execute the functions which intern package variables
 *                  - in the data base
 */

void PA_intern_pck_db()
   {PA_package *pck;
    PFInt pck_intrn;

/* loop over all packages */
    for (pck = Packages; pck != NULL; pck = pck->next)
        {pck_intrn = pck->intrn;

/* execute the package variable interners */
         if (pck_intrn != NULL)
            {PA_control_set(pck->name);
             (*pck_intrn)();};};

/* reset to the global controls */
    PA_control_set("global");

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* PA_INST_COM - install the commands
 *             - only the commands which are generic to all PANACEA
 *             - generators should be here
 *             - the others belong with the packages they serve
 */
 
HASHTAB *PA_inst_com()
   {PA_alias_tab = SC_make_hash_table(HSZLARGE, NODOC);
    PAN_COMMAND  = SC_strsavef("PA_command", "char*:PA_INST_COM:command");

/* this call should be moved into PA_inst_pck_gen_cmmnds */
    PA_gencmd();

/* install the commands serving the packages */
    PA_inst_pck_gen_cmmnds();
 
/* build the data base now */
    PA_definitions();
    PA_variables(FALSE);

    return(PA_commands);}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* PA_INST_C - install generator commands in the command table
 *           - a command object is defined as:
 *           -      struct s_PA_command
 *           -         {char type;
 *           -          int *var;
 *           -          int num;
 *           -          char *name;
 *           -          PFVoid proc;
 *           -          PFInt handler;};
 *           -
 *           -      typedef struct s_PA_command PA_command;
 *           -
 */
 
void PA_inst_c(cname, cvar, ctype, cnum, cproc, chand)
   char *cname;
   byte *cvar;
   int ctype;
   int cnum;
   PFVoid cproc;
   PFVoid chand;
   {PA_command *cp;
 
    if (PA_commands == NULL)
       PA_commands  = SC_make_hash_table(HSZLARGE, NODOC);

    cp          = FMAKE(PA_command, "PA_INST_C:cp");
    cp->name    = SC_strsavef(cname, "char*:PA_INST_C:cname");
    cp->type    = ctype;
    cp->num     = cnum;
    cp->proc    = cproc;
    cp->handler = chand;
    cp->vr      = (int *) cvar;
 
    SC_install(cname, cp, PAN_COMMAND, PA_commands);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_DEF_ALIAS - define an alias for a constant value */

void PA_def_alias(name, type, pv)
   char *name, *type;
   byte *pv;
   {char *cp, **tp;
    short *sp;
    int *ip;
    long *lp;
    float *fp;
    double *dp;

    if (strcmp(type, SC_CHAR_S) == 0)
       {cp  = FMAKE(char, "PA_DEF_ALIAS:cp");
        *cp = *(char *) pv;
        SC_install(name, cp, SC_CHAR_S, PA_alias_tab);}

    else if (strcmp(type, SC_SHORT_S) == 0)
       {sp  = FMAKE(short, "PA_DEF_ALIAS:sp");
        *sp = *(short *) pv;
        SC_install(name, sp, SC_SHORT_S, PA_alias_tab);}

    else if (strncmp(type, SC_INTEGER_S, 3) == 0)
       {ip  = FMAKE(int, "PA_DEF_ALIAS:ip");
        *ip = *(int *) pv;
        SC_install(name, ip, SC_INTEGER_S, PA_alias_tab);}

    else if (strcmp(type, SC_LONG_S) == 0)
       {lp  = FMAKE(long, "PA_DEF_ALIAS:lp");
        *lp = *(long *) pv;
        SC_install(name, lp, SC_LONG_S, PA_alias_tab);}

    else if (strcmp(type, SC_FLOAT_S) == 0)
       {fp  = FMAKE(float, "PA_DEF_ALIAS:fp");
        *fp = *(float *) pv;
        SC_install(name, fp, SC_FLOAT_S, PA_alias_tab);}

    else if (strcmp(type, SC_DOUBLE_S) == 0)
       {dp  = FMAKE(double, "PA_DEF_ALIAS:dp");
        *dp = *(double *) pv;
        SC_install(name, dp, SC_DOUBLE_S, PA_alias_tab);}

    else if (strcmp(type, SC_STRING_S) == 0)
       {tp  = FMAKE(char *, "PA_DEF_ALIAS:tp");
        *tp = *(char **) pv;
        SC_install(name, tp, SC_STRING_S, PA_alias_tab);};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_ALIAS_VALUE - return the value aliased to the string S as a double
 *                - NOTE: the value can be cast to its true type
 */

double PA_alias_value(s)
   char *s;
   {hashel *hp;
    double d;

    hp = SC_lookup(s, PA_alias_tab);
    if (hp == NULL)
       d = SC_stof(s);

    else if (strcmp(hp->type, SC_DOUBLE_S) == 0)
       d = *(double *) hp->def;

    else if (strcmp(hp->type, SC_FLOAT_S) == 0)
       d = *(float *) hp->def;

    else if (strcmp(hp->type, SC_LONG_S) == 0)
       d = *(long *) hp->def;

    else if (strncmp(hp->type, SC_INTEGER_S, 3) == 0)
       d = *(int *) hp->def;

    else if (strcmp(hp->type, SC_SHORT_S) == 0)
       d = *(short *) hp->def;

    else if (strcmp(hp->type, SC_CHAR_S) == 0)
       d = *(char *) hp->def;

    else
       PA_ERR(TRUE, "BAD ALIAS - PA_ALIAS_VALUE");

    return(d);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_SPECIFYH - handler for specify command */

void PA_specifyh()
   {char *s, *ivfn, *ivident;
    int ivtype, interp;
    double nxt, *nxtp;
    pcons *first, *prev;

    s = PA_get_field("TYPE", "PA_SPECIFY", REQU);
    if (strcmp(s, "bc") == 0)
       {ivtype = 'b';
        ivident = PA_get_field("IDENTIFIER", "PA_SPECIFY", REQU);}
    else if (strcmp(s, "src") == 0)
       {ivtype = 's';
        ivident = PA_get_field("IDENTIFIER", "PA_SPECIFY", REQU);}
    else
       {ivtype = 'v';
        ivident = SC_strsavef(s, "char*:PA_SPECIFYH:s");};

    first  = NULL;
    ivlst  = NULL;
    ivfn   = NULL;
    ivnum  = 0;
    interp = TRUE;
    while ((s = PA_get_field("SPECIFICATION", "PA_SPECIFY", OPTL)) != NULL)
       {if (strcmp(s, "from") == 0)
           {ivfn = PA_get_field("FILE NAME", "PA_SPECIFY", REQU);
            continue;}
        else if (strcmp(s, "interpolate") == 0)
           {interp = TRUE;
            continue;}
        else if (strcmp(s, "discrete") == 0)
           {interp = FALSE;
            continue;}
        else
           {if (strcmp(s, "in") == 0)
               {PFInt reg_hook;

                s = PA_get_field("REGION", "PA_SPECIFY", REQU);
                reg_hook = PA_GET_FUNCTION(PFInt, "region_id");
                PA_ERR((reg_hook == NULL),
                       "CAN'T USE 'in' WITHOUT A 'region_id' HOOK - PA_SPECIFY");
                nxt = (double) (*reg_hook)(s);}

            else if (strcmp(s, "at") == 0)
               {s = PA_get_field("LOCATION", "PA_SPECIFY", REQU);
                nxt = SC_stof(s);}

            else if (strcmp(s, "along") == 0)
               {s = PA_get_field("LOCATION", "PA_SPECIFY", REQU);
                nxt = SC_stof(s);}

            else
               nxt = PA_alias_value(s);

            nxtp = FMAKE(double, "PA_SPECIFYH:nxtp");
            *nxtp = nxt;
            ivlst = SC_mk_pcons("double *", nxtp, SC_PCONS_P_S, NULL);
            if (first == NULL)
               first = ivlst;
            else
               prev->cdr = (byte *) ivlst;
            prev = ivlst;
            ivnum++;};};
    
    iv_spec_lst = _PA_mk_spec(ivident, ivtype, ivfn, ivnum, interp,
                              first, iv_spec_lst);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_SH - handler s command */

void PA_sh()
   {char *s;
    double nxt, *nxtp;
    pcons *next;

    while ((s = PA_get_field("SPECIFICATION", "S", OPTL)) != NULL)
       {nxt = SC_stof(s);
        nxtp = FMAKE(double, "PA_SH:nxtp");
        *nxtp = nxt;
        next = SC_mk_pcons("double *", nxtp, SC_PCONS_P_S, NULL);
        if (ivlst == NULL)
           iv_spec_lst->spec = next;
        else
           ivlst->cdr = (byte *) next;
        ivlst = next;
        ivnum++;};

    PA_ERR((iv_spec_lst == NULL),
           "%s", "NO SPECIFICY COMMAND BEFORE SPECIFICATION");

    iv_spec_lst->num = ivnum;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_PROC_IV_SPEC - process the initial value specifications
 *                 - take the data out of the PA_iv_specification structs
 *                 - and put it into some nice arrays for the restart dump
 */

void PA_proc_iv_spec(lst)
   PA_iv_specification *lst;
   {PA_iv_specification *sp;
    double *data, *ths;
    pcons *pp, *nxt;

    for (sp = lst; sp != NULL; sp = sp->next)
        {if (sp->spec == NULL)
            continue;

/* if a data base variable is being specified then connect to it */
         data = FMAKE_N(double, sp->num, "PA_PROC_IV_SPEC:data");
         if (sp->type == 'v')
            PA_INTERN(data, sp->name);

         sp->data = data;

/* put the list of specifications into the data array and free the list */
         for (pp = sp->spec; pp != NULL; pp = nxt)
             {ths = (double *) (pp->car);
              nxt = (pcons *) (pp->cdr);
              *(data++) = *ths;
              SC_rl_pcons(pp, 1);};

         sp->spec = NULL;};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_READH - handle the read command */

void PA_readh(str)
   char *str;
   {char s[MAXLINE], *t;
    PFVoid hook;
    static int first = TRUE;

    if (first)
       {PA_input_stream = stdin;
	first = FALSE;};

    PA_control_set("global");

/* get the base names set up */
    strcpy(s, str);
    SC_strtok(s, ".", t);
    hook = PA_GET_FUNCTION(PFVoid, "base_name");
    if (hook != NULL)
       (*hook)(s);

    SC_REMEMBER(FILE *, PA_input_stream, infile_lst,
		n_infiles, nx_infiles, 5);

/* open the input deck */
    PA_input_stream = io_open(str, "r");
    PA_ERR((PA_input_stream == NULL),
           "Couldn't open file %s", str);

    hook = PA_GET_FUNCTION(PFVoid, "generation-error");
    PA_get_commands(PA_input_stream, hook);

    PA_input_stream = infile_lst[--n_infiles];

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_GET_COMMANDS - get commands from the current input stream */

void PA_get_commands(fp, errfnc)
   FILE *fp;
   DECLFPTR(byte, errfnc, (char *token));
   {char *s, *token;
    PA_command *cp;
    hashel *hp;
    FILE *old_stream;

    old_stream      = PA_input_stream;
    PA_input_stream = fp;

/* dispatch on commands from the deck */
    while (TRUE)
       {if (fp == stdin)
           PRINT(stdout, "-> ");
        s = PA_get_next_line();
        if (s == NULL)
           {if (fp != stdin)
               {io_close(fp);
                PA_input_stream = stdin;};

            break;};

        if (SC_blankp(s, "c#"))
           continue;

	token = PA_get_field("COMMAND", "PARSE", REQU);
        if (token != NULL)
           {hp = SC_lookup(token, PA_commands);
            if (hp != NULL)
               {cp = (PA_command *) hp->def;
                (*(cp->handler))(cp);}

            else if (errfnc != NULL)
               (*errfnc)(token);};};

    PA_input_stream = old_stream;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_GET_NEXT_LINE - get the next line of input from the current
 *                  - input stream
 *                  - has the same return semantics as fgets
 */

char *PA_get_next_line()
   {_PA_input_flag = TRUE;
    return(GETLN(PA_input_bf, MAXLINE, PA_input_stream));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_GET_FIELD - get the next field from the command string */

char *PA_get_field(s, t, optp)
   char *s, *t;
   int optp;
   {char *token, *b;

    b = (_PA_input_flag) ? PA_input_bf : NULL;

    token = SC_strtok(b, PA_token_delimiters, PA_strtok_p);
    PA_ERR(((token == NULL) && (optp == REQU)),
           "Bad %s field in %s command\n", s, t);

    _PA_input_flag = FALSE;

    return(token);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_INIT_SYSTEM - initialize the code system
 *                - connect the global variables, open the post-processor
 *                - file and the edit file, and run the package initializers
 */

void _PA_init_cont()
   {PA_package *pck;
    PFInt pck_defcnt;

/* initialize the package controls */
    for (pck = Packages; pck != NULL; pck = pck->next)
        {pck_defcnt = pck->defcnt;
         if (pck_defcnt != NULL)
            (*pck_defcnt)(pck);};

/* reset the global control arrays */
    PA_control_set("global");

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_CLEAR - re-initialize the system in preparation for new IV problem */

void PA_clear()
   {int i, sz;
    hashel **tb, *np, *nxt;

    sz = PA_variable_tab->size;
    tb = PA_variable_tab->table;
    for (i = 0; i < sz; i++)
        {for (np = tb[i]; np != NULL; np = nxt)
             {nxt = np->next;
              if (strcmp(np->type, PAN_VARIABLE) == 0)
                 {_PA_rl_variable((PA_variable *) (np->def));
                  SC_hash_rem(np->name, PA_variable_tab);};};};
/*
    SFREE(PA_variable_tab->table);
    SFREE(PA_variable_tab);
*/
    _PA_rl_spec(iv_spec_lst);
    _PA_rl_request(plot_reqs);

    plot_reqs   = NULL;
    iv_spec_lst = NULL;

    _PA_init_cont();

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_PACKH - handle the package command */

void PA_packh()
   {char *s;

/* get the package name */
    s = PA_get_field("NAME", "PACKAGE", REQU);

/* set the control pointers */
   PA_control_set(s);

   return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_PSHAND - handle the setting of switches and parameters */

void PA_pshand(cp)
   PA_command *cp;
   {int i, ival;
    double fval;
    char *sval;

    if (strcmp(cp->name, "switch") == 0)
       {i    = SC_stoi(PA_get_field("INDEX", "SWITCH", REQU));
        ival = SC_stoi(PA_get_field("VALUE", "SWITCH", REQU));
        SWTCH[i] = ival;}

    else if (strcmp(cp->name, "parameter") == 0)
       {i    = SC_stoi(PA_get_field("INDEX", "PARAMETER", REQU));
        fval = SC_stof(PA_get_field("VALUE", "PARAMETER", REQU));
        PARAM[i] = fval;}

    else if (strcmp(cp->name, "name") == 0)
       {i    = SC_stoi(PA_get_field("INDEX", "NAME", REQU));
        sval = SC_strtok(NULL, "\n\r", PA_strtok_p);
        NAME[i] = SC_strsavef(sval, "char*:PA_PSHAND:s");}

    else if (strcmp(cp->name, "unit") == 0)
       {i    = SC_stoi(PA_get_field("INDEX", "UNIT", REQU));
        fval = SC_stof(PA_get_field("VALUE", "UNIT", REQU));
        unit[i] = ival;}

    else if (strcmp(cp->name, "conversion") == 0)
       {i    = SC_stoi(PA_get_field("INDEX", "CONVERSION", REQU));
        fval = SC_stof(PA_get_field("VALUE", "CONVERSION", REQU));
        convrsn[i] = ival;}

    else
       {double d;

	i    = cp->num;
        sval = PA_get_field("VALUE", cp->name, REQU);
	d    = PA_alias_value(sval);

        if (cp->type == SC_INTEGER_I)
           (cp->vr)[i] = (int) d;

        else if (cp->type == SC_DOUBLE_I)
           ((double *) cp->vr)[i] = d;

        else if (cp->type == SC_REAL_I)
           ((REAL *) cp->vr)[i] = (REAL) d;

        else if ((cp->type == SC_CHAR_I) ||
                 (cp->type == SC_STRING_I))
           ((char **) cp->vr)[i] = SC_strsavef(sval,
                                    "char*:PA_PSHAND:s");

/* since char_8 is a FORTRAN disease treat it as static */
        else if (cp->type == SC_CHAR_8_I)
           {int nb;
            char *s;

            s  = ((char **) cp->vr)[i];
            nb = (strlen(sval) + 7)/8 << 3;
            memset(s, 0, nb);
            strncpy(((char **) cp->vr)[i], sval, strlen(sval));};};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_NPLOTH - handler for the new plot command */

void PA_nploth()
   {char *spec, *ran, *dom, text[MAXLINE];
    PA_set_spec *range, *domain;

    N_graphs++;

    spec = SC_strtok(NULL, "\n", PA_strtok_p);
    strcpy(text, spec);

    ran = SC_strtok(spec, "{(", PA_strtok_p);
    dom = SC_strtok(NULL, "\n", PA_strtok_p);

    range = NULL;
    while ((spec = SC_strtok(ran, "{,}", PA_strtok_p)) != NULL)
       {range = _PA_proc_set_spec(spec, range);
        ran   = NULL;};

    domain = NULL;
    while ((spec = SC_strtok(dom, ",)", PA_strtok_p)) != NULL)
       {domain = _PA_proc_set_spec(spec, domain);
        dom    = NULL;};

/* reverse the order of the range specifications */
    SC_REVERSE_LIST(PA_set_spec, range, next);

/* reverse the order of the domain specifications */
    SC_REVERSE_LIST(PA_set_spec, domain, next);

    plot_reqs = _PA_mk_plot_request(range, domain, text, plot_reqs);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_TIME_PLOT - make a time plot request from the source */

void PA_time_plot(rname, vr)
   char *rname;
   byte *vr;
   {char text[MAXLINE];
    PA_set_spec *range, *domain;

    N_graphs++;

    sprintf(text, "%s->{t}", rname);
    range     = _PA_proc_set_spec(rname, NULL);
    domain    = _PA_proc_set_spec("t", NULL);
    plot_reqs = _PA_mk_plot_request(range, domain, text, plot_reqs);

    plot_reqs->data       = (PM_set *) vr;
    plot_reqs->data_index = 0;
    plot_reqs->conv       = 1.0;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PA_MK_PLOT_REQUEST - create a new plot request structure
 *                     - and initialize it
 */

PA_plot_request *_PA_mk_plot_request(range, domain, text, next)
   PA_set_spec *range;
   PA_set_spec *domain;
   char *text;
   PA_plot_request *next;
   {PA_plot_request *req;

    req = FMAKE(PA_plot_request, "_PA_MK_PLOT_REQUEST:req");

    req->range            = range;
    req->range_name       = NULL;
    req->domain           = domain;
    req->base_domain_name = NULL;
    req->domain_map       = NULL;
    req->text             = SC_strsavef(text,
                             "char*:_PA_MK_PLOT_REQUEST:text");
    req->time_plot        = FALSE;
    req->mesh_plot        = FALSE;
    req->status           = EDIT;
    req->size             = 0L;
    req->offset           = 0L;
    req->stride           = -1L;
    req->str_index        = -1;
    req->conv             = 0.0;
    req->centering        = U_CENT;
    req->allocate_data    = TRUE;
    req->data             = NULL;
    req->data_index       = (int) -HUGE_INT;
    req->data_type        = SC_DOUBLE_I;
    req->next             = next;

    return(req);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_FUNCTION_FORM - fill the SPEC with appropriate values and return
 *                  - TRUE iff T is of the form func(a;b;c)
 */

int PA_function_form(t, spec)
   char *t;
   PA_set_spec *spec;
   {int n, nx, ret;
    char *ps;
    char fnc[MAXLINE], s[MAXLINE], arg[MAXLINE];
    REAL vc, *val;

    strcpy(s, t);

    val = NULL;
    n   = 0;
    nx  = 0;

    ps = strchr(s, '(');
    if (ps != NULL)
       {if (*s == '(')
           strcpy(fnc, "limit");
	else
	   strcpy(fnc, SC_firsttok(s, " \t()"));

/* NOTE: the "(" will come from forms like a=(i;j;k)
 *       and fall under the "limit" operator
 */
	strcpy(arg, SC_firsttok(s, "()"));
	while (TRUE)
	   {ps = SC_firsttok(arg, ";");
	    if (ps != NULL)
	       {vc = SC_stof(ps);
		SC_REMEMBER(double, vc, val, n, nx, 3);}
	    else
	       break;};
	
	PA_ERR(((n != 3) && (strcmp(fnc, "step") == 0)),
	       "MISSING STEP VALUE - PA_FUNCTION_FORM");

	ret = TRUE;}

/* if there is no match define this to be the case "var=<string>" */
    else
       {strcpy(fnc, t);

	ret = FALSE;};

    spec->function = SC_strsavef(fnc, "char*:PA_FUNCTION_FORM:function");
    spec->n_values = n;
    spec->values   = val;

    return(ret);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PA_PROC_SET_SPEC - process an set element variable specification
 *                   - in a plot request
 */

PA_set_spec *_PA_proc_set_spec(s, lst)
   char *s;
   PA_set_spec *lst;
   {PA_set_spec *spec;
    char t[MAXLINE], *token;

    strcpy(t, s);

    spec = FMAKE(PA_set_spec, "_PA_PROC_SET_SPEC:spec");

    token = SC_firsttok(t, " \t=");
    if (token == NULL)
       return(lst);

    spec->var_name = SC_strsavef(token, "char*:_PA_PROC_SET_SPEC:name");
    spec->text     = NULL;
    spec->values   = NULL;

/* handle case "var" */
    token = SC_firsttok(t, "\n");
    if (token == NULL)
       spec->function = NULL;

/* handle case "var=#" */
    else if (SC_numstrp(token))
       {spec->function = NULL;
	spec->n_values = 1;
	spec->values   = FMAKE(double, "_PA_PROC_SET_SPEC:values");
	*spec->values  = SC_stof(token);}

/* handle cases "var=func(#;#;#)" and "var=<string>" */
    else
       PA_function_form(token, spec);

    spec->next = lst;

    return(spec);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_WRRSTRTH - handle the writing of the restart dump
 *             - first see to the building of the data base and
 *             - the proper final initialization of the pure panacea
 *             - variables
 */

void PA_wrrstrth()
   {PFVoid db_hook;

/* reverse the order of the new plot requests */
    SC_REVERSE_LIST(PA_plot_request, plot_reqs, next);

    PA_proc_units();

/* intern the controls */
    PA_INTERN(unit, "unit");
    PA_INTERN(convrsn, "convrsn");

/* intern the plot requests */
    PA_INTERN(plot_reqs, "plot-requests");

/* intern the initial value data list after the package data have been
 * interned
 */
    PA_proc_iv_spec(iv_spec_lst);
    PA_INTERN(iv_spec_lst, "initial-value-specifications");

/* an extra hook for anything which does NOT fall under the control of
 * intern_pck_db
 */
    db_hook = PA_GET_FUNCTION(PFVoid, "setup_region");
    if (db_hook != NULL)
       (*db_hook)();

    PA_intern_pck_db();

    _PA_wrrstrt(_PA_gen_rsname, EXT_INT);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_DONE - gracefully leave the generator */

void PA_done()
   {longjmp(SC_top_lev, ERR_FREE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* PA_NAME_FILES - name the various files and log them in the name array */

void PA_name_files(base_name, ped, prs, ppp, pgf)
   char *base_name, **ped, **prs, **ppp, **pgf;
   {char s[50], t[50], *token, *pt;

/* strip off any directory names */
    token = SC_strtok(base_name, "/\\:", pt);
    strcpy(t, token);
    while ((token = SC_strtok(NULL, "/\\:", pt)) != NULL)
       strcpy(t, token);

/* name the first edit file */
    if (ped != NULL)
       {strcpy(s, t);
	strcat(s, ".e00");
	*ped = SC_strsavef(s, "char*:PA_NAME_FILES:ped");};

/* name the restart dump file */
    if (prs != NULL)
       {strcpy(s, t);
	strcat(s, ".r00");
	*prs = _PA_gen_rsname = SC_strsavef(s, "char*:PA_NAME_FILES:prs");};

/* name the post-processor file */
    if (ppp != NULL)
       {strcpy(s, t);
	strcat(s, ".t00");
	*ppp = SC_strsavef(s, "char*:PA_NAME_FILES:ppp");};

/* name the post-processor file */
    if (pgf != NULL)
       {strcpy(s, t);
	strcat(s, ".s00");
	*pgf = SC_strsavef(s, "char*:PA_NAME_FILES:pgf");};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
