/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  ORBit: A CORBA v2.2 ORB
 *
 *  Copyright (C) 1998 Richard H. Porter and Red Hat Software
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Phil Dawes <philipd@parallax.co.uk>
 *
 */

/*
 *   ORBit specific CORBA_Object funcitons.
 *
 */
#ifndef _ORBIT_ORBIT_OBJECT_H_
#define _ORBIT_ORBIT_OBJECT_H_

#include <IIOP/IIOP.h>
#include "corba_object.h"

extern CORBA_Object ORBit_CORBA_Object_new(CORBA_Environment *ev);
extern void ORBit_CORBA_Object_free(CORBA_Object obj, CORBA_Environment *ev);

void ORBit_set_object_key(CORBA_Object obj,
			  gpointer key,
			  CORBA_unsigned_long key_len);


typedef enum {
	ORBIT_PSEUDO_ORB,
	ORBIT_PSEUDO_POA,
	ORBIT_PSEUDO_POAMANAGER,
	ORBIT_PSEUDO_POLICY
} ORBit_PseudoObject_type;
typedef struct ORBit_PseudoObject_struct *ORBit_PseudoObject;

void ORBit_pseudo_object_init(ORBit_PseudoObject obj,
			      ORBit_PseudoObject_type obj_type,
			      CORBA_Environment *ev);
void ORBit_policy_object_init(CORBA_Policy obj,
			      CORBA_PolicyType obj_type,
			      CORBA_Environment *ev);

/* Use ORBit_CORBA_Object_new() */
void ORBit_object_reference_init(CORBA_Object obj, CORBA_Environment *ev);

typedef struct {
	CORBA_octet iiop_major, iiop_minor;
	CORBA_char *host;
	CORBA_unsigned_short port;
	CORBA_sequence_octet object_key;
	struct { CORBA_unsigned_long _length; char _buffer[1]; } *object_key_data;
	struct iovec object_key_vec;
} TAG_INTERNET_IOP_info;

typedef struct {
	CORBA_char *unix_sock_path;
	CORBA_short ipv6_port;
} TAG_ORBIT_SPECIFIC_info;

typedef struct {
} TAG_MULTIPLE_COMPONENTS_info;

typedef struct {
	TAG_INTERNET_IOP_info *iopinfo;
	TAG_ORBIT_SPECIFIC_info *orbitinfo;
	TAG_MULTIPLE_COMPONENTS_info *mcinfo;
	char *obj_id;
} ORBit_Object_info;

CORBA_Object ORBit_create_object_with_info(GHashTable *obj_info,
					   CORBA_ORB orb,
					   CORBA_Environment *ev);

#define ORBit_object_get_connection(obj) \
     ((obj)->connection && (obj)->connection->is_valid)?((obj)->connection):_ORBit_object_get_connection(obj)
GIOPConnection *_ORBit_object_get_connection(CORBA_Object obj);
void ORBit_marshal_object(GIOPSendBuffer *send_buffer, CORBA_Object obj);
CORBA_Object ORBit_demarshal_object(GIOPRecvBuffer *recv_buffer,
				    CORBA_ORB orb);

#endif /* _ORBIT_ORBIT_OBJECT_H_ */
