// This program tests the use of T_var type of fixed size struct
// and variable size struct

// IDL
//	interface obj {
//         void op();
//      };


#include "varTest.hh"
#include <iostream.h>

class obj_i : virtual public _sk_obj {
public:
  obj_i() {}
  virtual ~obj_i() {}
  virtual void op() {}
};

obj_ptr
__obj_fn (obj_ptr in, obj_ptr& inout, obj_ptr& out) {
  out = obj::_duplicate(in);
  CORBA::release(inout);
  inout = obj::_duplicate(in);
  obj_ptr result = obj::_duplicate(in);
  return result;
}

obj_ptr
obj_fn (obj_ptr in,
	_CORBA_ObjRef_INOUT_arg<obj,obj_var,
	                        _CORBA_ObjRef_Member<obj,obj_Helper> > inout,
	_CORBA_ObjRef_OUT_arg<obj,obj_var,
	                      _CORBA_ObjRef_Member<obj,obj_Helper>,
	                       obj_Helper> out) 
{
  return __obj_fn(in,inout._data,out._data);
}

int
main (int argc, char**argv)
{
  CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");
  CORBA::BOA_ptr boa = orb->BOA_init(argc,argv,"omniORB2_BOA");

  {
    cerr << "Object Reference test: ";
    obj_i *myobj = new obj_i;
    myobj->_obj_is_ready(boa);

    obj_var in    = myobj->_this();
    obj_var inout = in;

    obj_var out = in;

    obj_var result;

    result = obj_fn(in,inout,out);
    if (!in->_is_equivalent(inout) ||
	!in->_is_equivalent(out))
      {
	cerr << "failed. Line no: " << __LINE__ << endl;
	return 1;
      }
    cerr << "PASSED." << endl;
  }
  return 0;
}
