// Usage: server [<echo object name>]
//        Names are COSNaming compound names (e.g. x/y/test.obj)
//

#include <iostream.h>
#include <echo.hh>
#include <common/common.h>


CORBA::BOA_ptr boa;

class Echo_i : public virtual _sk_Echo {
public:
  Echo_i() : count(0) {}
  virtual ~Echo_i() { cerr << "Echo_i::~Echo_i" << endl; }
  virtual char * echoString(const char *mesg);
private:
  CORBA::ULong count;
};

char *
Echo_i::echoString(const char *mesg) {
  switch (++count) {
  case 1:
    throw CORBA::UNKNOWN(0,CORBA::COMPLETED_NO);
  case 2:
    throw CORBA::BAD_PARAM(0,CORBA::COMPLETED_NO);
  case 3:
    throw CORBA::NO_MEMORY(0,CORBA::COMPLETED_NO);
  case 4:
    throw CORBA::IMP_LIMIT(0,CORBA::COMPLETED_NO);
  case 5:
    throw CORBA::COMM_FAILURE(0,CORBA::COMPLETED_NO);
  case 6:
    throw CORBA::INV_OBJREF(0,CORBA::COMPLETED_NO);
  case 7:
    throw CORBA::OBJECT_NOT_EXIST(0,CORBA::COMPLETED_NO);
  case 8:
    throw CORBA::NO_PERMISSION(0,CORBA::COMPLETED_NO);
  case 9:
    throw CORBA::INTERNAL(0,CORBA::COMPLETED_NO);
  case 10:
    throw CORBA::MARSHAL(0,CORBA::COMPLETED_NO);
  case 11:
    throw CORBA::INITIALIZE(0,CORBA::COMPLETED_NO);
  case 12:
    throw CORBA::NO_IMPLEMENT(0,CORBA::COMPLETED_NO);
  case 13:
    throw CORBA::BAD_TYPECODE(0,CORBA::COMPLETED_NO);
  case 14:
    throw CORBA::BAD_OPERATION(0,CORBA::COMPLETED_NO);
  case 15:
    throw CORBA::NO_RESOURCES(0,CORBA::COMPLETED_NO);
  case 16:
    throw CORBA::NO_RESPONSE(0,CORBA::COMPLETED_NO);
  case 17:
    throw CORBA::PERSIST_STORE(0,CORBA::COMPLETED_NO);
  case 18:
    throw CORBA::BAD_INV_ORDER(0,CORBA::COMPLETED_NO);
  case 19:
    throw CORBA::TRANSIENT(0,CORBA::COMPLETED_NO);
  case 20:
    throw CORBA::FREE_MEM(0,CORBA::COMPLETED_NO);
  case 21:
    throw CORBA::INV_IDENT(0,CORBA::COMPLETED_NO);
  case 22:
    throw CORBA::INV_FLAG(0,CORBA::COMPLETED_NO);
  case 23:
    throw CORBA::INTF_REPOS(0,CORBA::COMPLETED_NO);
  case 24:
    throw CORBA::BAD_CONTEXT(0,CORBA::COMPLETED_NO);
  case 25:
    throw CORBA::OBJ_ADAPTER(0,CORBA::COMPLETED_NO);
  case 26:
    throw CORBA::DATA_CONVERSION(0,CORBA::COMPLETED_NO);
  case 27:
    throw CORBA::TRANSACTION_REQUIRED(0,CORBA::COMPLETED_NO);
  case 28:
    throw CORBA::TRANSACTION_ROLLEDBACK(0,CORBA::COMPLETED_NO);
  case 29:
    throw CORBA::INVALID_TRANSACTION(0,CORBA::COMPLETED_NO);
  case 30:
    throw CORBA::WRONG_TRANSACTION(0,CORBA::COMPLETED_NO);
  default:
    _dispose();
  }
  return CORBA::string_dup(mesg);
}


int
main(int argc, char **argv)
{
  CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");
  boa = orb->BOA_init(argc,argv,"omniORB2_BOA");

  CosNaming::Name echo_name;

  if (argc > 1) {
    if (argc != 2) {
      cerr << "Usage: server [<echo object name>]\n"
	   << "       Names are COSNaming compound names (e.g. x/y/test.obj)"
	   << endl;
      return 1;
    }
    try {
      echo_name = string_to_name(argv[1]);
    }
    catch (...) {
      cerr << argv[1] << " is not a valid COS Naming compound name." << endl;
      return 1;
    }
  }

  omniORB::idleConnectionScanPeriod(omniORB::idleIncoming,15);
  omniORB::idleConnectionScanPeriod(omniORB::idleOutgoing,0);

  Echo_i *myobj = new Echo_i;
  myobj->_obj_is_ready(boa);

  {
    Echo_var myobjRef = myobj->_this();
    if (echo_name.length()) {
      if (!bindObjectToName(orb,myobjRef,echo_name)) {
	return 1;
      }
    }
    else {
      CORBA::String_var p = orb->object_to_string(myobjRef);
      cerr << "Echo Object " << (char*)p << endl;
    }
  }

  cerr << "Main thread calling BOA is ready..." << endl;
  boa->impl_is_ready();
  cerr << "Main thread returns from BOA is ready..." << endl;
  myobj->_dispose();
  cerr << "Removing BOA..." << endl;
  boa->destroy();
  cerr << "BOA has been removed.." << endl;
  return 0;
}

