#include <iostream.h>
#include <common/common.h>
#include <echo.hh>

class Echo_i : public virtual _sk_Echo {
public:
  Echo_i() {}
  virtual ~Echo_i() {}
  virtual char * echoString(const char *mesg);
};

char *
Echo_i::echoString(const char *mesg) {
  char *p = CORBA::string_dup(mesg);
  return p;
}


class killer : public omni_thread {
public:
  killer() {
    start_undetached();
  }
  virtual ~killer() {}
  virtual void* run_undetached(void *arg);
};

class multi : public omni_thread {
public:
  multi() {
    start_undetached();
  }
  virtual ~multi() {}
  virtual void* run_undetached(void *arg);
};

CORBA::Boolean kflag = 0;
// kflag = 0
//       main thread call impl_is_ready() non-blocking, sleep for a while
//       and call impl_shutdown()
// kflag = 1
//       main thread spawn killer thread, call impl_is_ready() blocking
//       killer thread sleep for a while then call impl_shutdown
//       on unblocking from impl_is_ready(), main thread call join on the
//       killer thread.

CORBA::Boolean mflag = 0;
// mflag = 1
//       main thread spawn multi thread.
//       multi thread call impl_is_ready() non-blocking multiple times and
//       call impl_is_ready() blocking.
// mflag = 0
//       do not spawn multi thread.


CORBA::BOA_ptr boa;

int
main(int argc, char **argv)
{
  CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");
  boa = orb->BOA_init(argc,argv,"omniORB2_BOA");

  CosNaming::Name_var use_name;

  int idx = 1;
  while (argc > idx)
    {
      if (strcmp(argv[idx],"-k") == 0) {
	kflag = 1;
      }
      else if (strcmp(argv[idx],"-m") == 0) {
	mflag = 1;
      }
      else if (*argv[idx] != '-') {
	try {
	  use_name = new CosNaming::Name(string_to_name(argv[idx]));
	}
	catch (...) {
	  cerr << argv[idx] << " is not a valid COS Naming compound name." << endl;
	  return 1;
	}
      }
      else {
	cerr << "usage: " << argv[0] << " [-m] [-k] " 
	     << "[<COSNaming compound name (e.g. x/y/test.obj)>]"
	     << endl;
	return 1;
      }
      idx++;
    }


  omniORB::idleConnectionScanPeriod(omniORB::idleIncoming,15);
  omniORB::idleConnectionScanPeriod(omniORB::idleOutgoing,0);

  Echo_i *myobj = new Echo_i();
  myobj->_obj_is_ready(boa);

  {
    Echo_var myobjRef = myobj->_this();
    CosNaming::Name* b = use_name.operator->();
    if (b) {
      if (!bindObjectToName(orb,myobjRef,*b)) {
	return 1;
      }
    }
    else {
      CORBA::String_var p = orb->object_to_string(myobjRef);
      cerr << (char*)p << endl;
    }
  }

  int count = 10;
  while (count--) {
    multi* mthr;
    if (mflag) {
      mthr = new multi;
    }
    if (!kflag) {
      boa->impl_is_ready(0,1);
      cerr << "BOA is ready..." << endl;
      omni_thread::sleep(3);
      cerr << "Shutting down BOA..." << endl;
      boa->impl_shutdown();
      cerr << "BOA is down..." << endl;
      if (mflag) {
	boa->impl_shutdown();     // can call impl_shutdown() multiple times
	boa->impl_shutdown();
	mthr->join(0);
	cerr << "Main thread: joined with multi thread..." << endl;
      }
    }
    else {
      killer* kthr = new killer;
      cerr << "Main thread: Calling BOA is ready..." << endl;
      boa->impl_is_ready();
      cerr << "Main thread: returns from impl_is_ready.." << endl;
      kthr->join(0);
      cerr << "Main thread: joined with killer thread.." << endl;
      if (mflag) {
	mthr->join(0);
	cerr << "Main thread: joined with multi thread..." << endl;
      }
    }
    omni_thread::sleep(1);
    cerr << "Restarting BOA..." << endl;
  }

  myobj->_dispose();

  cerr << "Removing BOA..." << endl;
  boa->destroy();
  cerr << "BOA has been removed.. Wait 5 seconds before exiting" << endl;
  omni_thread::sleep(5);
  cerr << "Call BOA is ready again, should have no effect. Wait 60 seconds before exiting" << endl;
  boa->impl_is_ready(0,1);
  omni_thread::sleep(60);
  cerr << "main thread exit." << endl;
  return 0;
}

void*
killer::run_undetached(void* arg)
{
  omni_thread::sleep(5);
  cerr << "Killer thread: Shutting down BOA..." << endl;
  boa->impl_shutdown();
  cerr << "Killer thread: BOA is down..." << endl;
  return 0;
}

void*
multi::run_undetached(void* arg)
{
  cerr << "Multi thread: About to block on impl_is_ready()..." << endl;
  boa->impl_is_ready();
  cerr << "Multi thread: returns from impl_is_ready().." << endl;
  return 0;
}
