// -*- Mode: C++; -*-
//                            Package   : omniORB2
// t_seq_string.cc            Created on: 06/12/96
//                            Author    : Sai Lai Lo (sll)
//
// Copyright (C) Olivetti Research Limited, 1996
//
// Description:
 
/*
  $Log$
  */

#include <assert.h>
#include "seq1.hh"
#include <iostream.h>


static
void
test_seq_string()
{
  int i;

  seq_string s1; 		// ctor seq_string();

  seq_string s2(100);		// ctor seq_string(CORBA::ULong max);
  s2.length(10);
  for (i=0; i<10; i++)
    assert((const char*)s2[i] == 0);

  const char *constr1 = "string 1";
  for (i=0; i<10; i++)
    s2[i] = constr1;
  for (i=0; i<10; i++) {
    assert((const char*)s2[i] != 0);
    assert((const char*)s2[i] != constr1);
    assert(strcmp((const char*)s2[i],constr1)==0);
  }
  
  CORBA::String_var string_var = constr1;
  for (i=0; i<10; i++)
    s2[i] = string_var;
  for (i=0; i<10; i++) {
    assert((const char*)s2[i] != 0);
    assert((const char*)s2[i] != (const char*)string_var);
    assert(strcmp((const char*)s2[i],(const char*)string_var) == 0);
  }
  
  string_var = s2[1];
  assert((const char *)string_var != 0);
  assert((const char *)string_var != (const char*)s2[1]);
  assert(strcmp((const char*)string_var,(const char*)s2[1]) == 0);

  seq_string s3(s2);		// ctor seq_string(const seq_string &);
  for (i=0; i<10; i++) {
    assert((const char*)s3[i] != (const char*)s2[i]);
    assert(strcmp((const char*)s3[i],(const char*)s2[i])==0);
  }

  s1 = s2;		// seq_string &operator= (const seq_string &);
  for (i=0; i<10; i++) {
    assert((const char*)s1[i] != (const char*)s2[i]);
    assert(strcmp((const char*)s1[i],(const char*)s2[i])==0);
  }


  seq_string_var s1_var;	// ctor seq_string_var();
  assert(s1_var.operator->() == 0);
  s1_var = new seq_string(s1);	// seq_string_var &operator=(seq_string *);
  for (i=0; i<10; i++) {
    assert((const char*)(s1_var[i]) != (const char*)s1[i]);
    assert(strcmp((const char*)(s1_var[i]),(const char*)s1[i])==0);
  }

}

static
void
test_seqseq_string()
{
  int i;
  const char *constr1 = "string sample";
  seq_string s1(100);
  s1.length(100);
  for (i=0; i<100; i++) {
    s1[i] = constr1;
  }

  seqseq_string ss1; 		// ctor seqseq_string();
  ss1.length(10);
  for (i=0; i<10; i++) {
    assert(ss1[i].length() == 0);
    ss1[i] = s1;
    assert(ss1[i].length() == 100);
  }

  seqseq_string ss2(ss1);      // ctor seqseq_string(const seqseq_string &);
  assert(ss2.length() == 10);
  assert(ss2.maximum() == 10);
  for (i=0; i<10; i++) {
    assert(ss2[i].length() == 100);
  }

  seqseq_string  ss3;
  ss3 = ss1;		  // seqseq_string &operator= (const seqseq_string&);
  assert(ss3.length() == 10);
  assert(ss3.maximum() == 10);
  for (i=0; i<10; i++) {
    assert(ss3[i].length() == 100);
  }
}

static
void
test_seqseqseq_string()
{
  int i;
  const char *constr1 = "string sample";
  seq_string s1(100);
  s1.length(100);
  for (i=0; i<100; i++) {
    s1[i] = constr1;
  }

  seqseq_string ss1;
  ss1.length(10);
  for (i=0; i<10; i++) {
    ss1[i] = s1;
  }

  seqseqseq_string sss1;
  sss1.length(5);
  for (i=0; i<5; i++) {
    assert(sss1[i].length() == 0);
    sss1[i] = ss1;
    assert(sss1[i].length() == 10);
  }

  seqseqseq_string sss2(sss1);
  assert(sss2.length() == 5);
  assert(sss2.maximum() == 5);
  for (i=0; i<5; i++) {
    assert(sss2[i].length() == 10);
  }

  seqseqseq_string sss3;
  sss3 = sss1;
  assert(sss3.length() == 5);
  assert(sss3.maximum() == 5);
  for (i=0; i<5; i++) {
    assert(sss3[i].length() == 10);
  }
}


int
main(int argc, char **argv)
{
  int loopcount = 1;

  while (loopcount--) {
    cerr << "Testing sequence<string>...";
    test_seq_string();
    cerr << "PASSED." << endl;
    cerr << "Testing sequence<sequence<string> >...";
    test_seqseq_string();
    cerr << "PASSED." << endl;
    cerr << "Testing sequence<sequence<sequence<string> > >...";
    test_seqseqseq_string();
    cerr << "PASSED." << endl;
  }

  return 0;

}
