// Usage: client -i <stringified IOR>
//        client <COSNaming compound name (e.g. x/y/echo.obj)>

#include <assert.h>
#include <iostream.h>
#include <seq1.hh>
#include <common/common.h>
#include <stdlib.h>

CORBA::ORB_ptr orb;

void
test_seq_arr_double(CORBA::Object_ptr obj)
{
  Exercise4_var ser = Exercise4::_narrow(obj);
  if (CORBA::is_nil(ser)) {
    cerr << "test_seq_arr_double: Cannot invoke on a nil object reference.\n" << endl;
    return;
  }

  seq_arr_double in;
  seq_arr_double_var out;
  seq_arr_double inout;
  seq_arr_double_var result;

  in.length(2);
  {
    for (int i=0; i<2; i++)
      for (int j=0; j<10; j++) {
	in[i][j] = i*10+j;
      }
  }
  inout = in;
  result = ser->dump_seq_arr_double(in,inout,out);
  assert(result->length() == in.length());
  assert(inout.length() == in.length());
  assert(out->length() == in.length());
  {
    for (int i=0; i<2; i++)
      for (int j=0; j<10; j++) {
	assert(result[i][j] == in[i][j]);
	assert(out[i][j] == in[i][j]);
	assert(inout[i][j] == in[i][j]);
      }
  }
}

void
test_seq_arrarr_double_10(CORBA::Object_ptr obj)
{
  Exercise4_var ser = Exercise4::_narrow(obj);
  if (CORBA::is_nil(ser)) {
    cerr << "test_seq_arr_double: Cannot invoke on a nil object reference.\n" << endl;
    return;
  }

  seq_arrarr_double_10 in;
  seq_arrarr_double_10_var out;
  seq_arrarr_double_10 inout;
  seq_arrarr_double_10_var result;

  in.length(2);
  {
    for (int i=0; i<2; i++)
      for (int j=0; j<10; j++)
	for (int k=70; k<80; k++) {
	  in[i][j][k] = (i*10+j)*100 + k;
	}
  }
  inout = in;
  result = ser->dump_seq_arrarr_double_10(in,inout,out);
  assert(result->length() == in.length());
  assert(inout.length() == in.length());
  assert(out->length() == in.length());
  {
    for (int i=0; i<2; i++)
      for (int j=0; j<10; j++) 
	for (int k=70; k<80; k++) {
	assert(result[i][j][k] == in[i][j][k]);
	assert(out[i][j][k] == in[i][j][k]);
	assert(inout[i][j][k] == in[i][j][k]);
      }
  }
}

void
test_seq_arr_string(CORBA::Object_ptr obj)
{
  Exercise5_var ser = Exercise5::_narrow(obj);
  if (CORBA::is_nil(ser)) {
    cerr << "test_seq_arr_double: Cannot invoke on a nil object reference.\n" << endl;
    return;
  }

  seq_arr_string in;
  seq_arr_string_var out;
  seq_arr_string inout;
  seq_arr_string_var result;

  in.length(2);
  {
    for (int i=0; i<2; i++)
      for (int j=0; j<4; j++) {
	in[i][j] = (const char*) "test_seq_arr_double";
      }
  }
  inout = in;
  result = ser->dump_seq_arr_string(in,inout,out);
  assert(result->length() == in.length());
  assert(inout.length() == in.length());
  assert(out->length() == in.length());
  {
    for (int i=0; i<2; i++)
      for (int j=0; j<4; j++) {
	assert(strcmp(result[i][j],in[i][j])==0);
	assert(strcmp(out[i][j],in[i][j])==0);
	assert(strcmp(inout[i][j],in[i][j])==0);
      }
  }
}

void
test_seq_arrarr_string_10(CORBA::Object_ptr obj)
{
  Exercise5_var ser = Exercise5::_narrow(obj);
  if (CORBA::is_nil(ser)) {
    cerr << "test_seq_arr_double: Cannot invoke on a nil object reference.\n" << endl;
    return;
  }

  seq_arrarr_string_10 in;
  seq_arrarr_string_10_var out;
  seq_arrarr_string_10 inout;
  seq_arrarr_string_10_var result;

  in.length(2);
  {
    for (int i=0; i<2; i++)
      for (int j=0; j<4; j++)
	for (int k=0; k<8; k++) {
	  in[i][j][k] = (const char*) "test_seq_arrarr_double";
	}
  }
  inout = in;
  result = ser->dump_seq_arrarr_string_10(in,inout,out);
  assert(result->length() == in.length());
  assert(inout.length() == in.length());
  assert(out->length() == in.length());
  {
    for (int i=0; i<2; i++)
      for (int j=0; j<4; j++) 
	for (int k=0; k<8; k++) {
	assert(strcmp(result[i][j][k],in[i][j][k])==0);
	assert(strcmp(out[i][j][k],in[i][j][k])==0);
	assert(strcmp(inout[i][j][k],in[i][j][k])==0);
      }
  }
}

static
const char* test_ior1 = "IOR:000000000000000d49444c3a4563686f3a312e3000051160000000010000000000000028000100000000000d3139322e352e3233392e363100208fec0000000c000000000000000000000004";

void
test_seq_arr_Echo(CORBA::Object_ptr obj)
{
  Exercise6_var ser = Exercise6::_narrow(obj);
  if (CORBA::is_nil(ser)) {
    cerr << "test_seq_arr_double: Cannot invoke on a nil object reference.\n" << endl;
    return;
  }

  CORBA::Object_var tmpobj = orb->string_to_object(test_ior1);
  Echo_var e1 = Echo::_narrow(tmpobj);
  assert(!CORBA::is_nil(e1));

  seq_arr_Echo in;
  seq_arr_Echo_var out;
  seq_arr_Echo inout;
  seq_arr_Echo_var result;

  in.length(2);
  {
    for (int i=0; i<2; i++)
      for (int j=0; j<13; j++) {
	in[i][j] = Echo::_duplicate(e1);
      }
  }
  inout = in;
  result = ser->dump_seq_arr_Echo(in,inout,out);
  assert(result->length() == in.length());
  assert(inout.length() == in.length());
  assert(out->length() == in.length());
  {
    for (int i=0; i<2; i++)
      for (int j=0; j<13; j++) {
	assert(result[i][j]->_is_equivalent(in[i][j]));
	assert(out[i][j]->_is_equivalent(in[i][j]));
	assert(inout[i][j]->_is_equivalent(in[i][j]));
      }
  }
}

void
test_seq_arrarr_Echo_10(CORBA::Object_ptr obj)
{
  Exercise6_var ser = Exercise6::_narrow(obj);
  if (CORBA::is_nil(ser)) {
    cerr << "test_seq_arr_double: Cannot invoke on a nil object reference.\n" << endl;
    return;
  }

  CORBA::Object_var tmpobj = orb->string_to_object(test_ior1);
  Echo_var e1 = Echo::_narrow(tmpobj);
  assert(!CORBA::is_nil(e1));

  seq_arrarr_Echo_10 in;
  seq_arrarr_Echo_10_var out;
  seq_arrarr_Echo_10 inout;
  seq_arrarr_Echo_10_var result;

  in.length(2);
  {
    for (int i=0; i<2; i++)
      for (int j=0; j<3; j++)
	for (int k=0; k<83; k++) {
	  in[i][j][k] = Echo::_duplicate(e1);
	}
  }
  inout = in;
  result = ser->dump_seq_arrarr_Echo_10(in,inout,out);
  assert(result->length() == in.length());
  assert(inout.length() == in.length());
  assert(out->length() == in.length());
  {
    for (int i=0; i<2; i++)
      for (int j=0; j<3; j++) 
	for (int k=0; k<83; k++) {
	assert(result[i][j][k]->_is_equivalent(in[i][j][k]));
	assert(out[i][j][k]->_is_equivalent(in[i][j][k]));
	assert(inout[i][j][k]->_is_equivalent(in[i][j][k]));
      }
  }
}

void
test_seq_arr_sVariable(CORBA::Object_ptr obj)
{
  Exercise8_var ser = Exercise8::_narrow(obj);
  if (CORBA::is_nil(ser)) {
    cerr << "test_seq_arr_double: Cannot invoke on a nil object reference.\n" << endl;
    return;
  }

  seq_arr_sVariable in;
  seq_arr_sVariable_var out;
  seq_arr_sVariable inout;
  seq_arr_sVariable_var result;

  in.length(2);
  {
    sVariable e;
    e.s1 = (const char*) "abc";
    for (int i=0; i<2; i++)
      for (int j=0; j<4; j++) {
	in[i][j] = e;
      }
  }
  inout = in;
  result = ser->dump_seq_arr_sVariable(in,inout,out);
  assert(result->length() == in.length());
  assert(inout.length() == in.length());
  assert(out->length() == in.length());
  {
    for (int i=0; i<2; i++)
      for (int j=0; j<4; j++) {
	assert(strcmp(result[i][j].s1,in[i][j].s1)==0);
	assert(strcmp(out[i][j].s1,in[i][j].s1)==0);
	assert(strcmp(inout[i][j].s1,in[i][j].s1)==0);
      }
  }
}

void
test_seq_arrarr_sVariable_10(CORBA::Object_ptr obj)
{
  Exercise8_var ser = Exercise8::_narrow(obj);
  if (CORBA::is_nil(ser)) {
    cerr << "test_seq_arr_double: Cannot invoke on a nil object reference.\n" << endl;
    return;
  }

  seq_arrarr_sVariable_10 in;
  seq_arrarr_sVariable_10_var out;
  seq_arrarr_sVariable_10 inout;
  seq_arrarr_sVariable_10_var result;

  in.length(2);
  {
    sVariable e;
    e.s1 = (const char*) "def";
    for (int i=0; i<2; i++)
      for (int j=0; j<4; j++)
	for (int k=0; k<8; k++) {
	  in[i][j][k] = e;
	}
  }
  inout = in;
  result = ser->dump_seq_arrarr_sVariable_10(in,inout,out);
  assert(result->length() == in.length());
  assert(inout.length() == in.length());
  assert(out->length() == in.length());
  {
    for (int i=0; i<2; i++)
      for (int j=0; j<4; j++) 
	for (int k=0; k<8; k++) {
	assert(strcmp(result[i][j][k].s1,in[i][j][k].s1)==0);
	assert(strcmp(out[i][j][k].s1,in[i][j][k].s1)==0);
	assert(strcmp(inout[i][j][k].s1,in[i][j][k].s1)==0);
      }
  }
}

void
test_seq_arr_uVariable(CORBA::Object_ptr obj)
{
  Exercise10_var ser = Exercise10::_narrow(obj);
  if (CORBA::is_nil(ser)) {
    cerr << "test_seq_arr_double: Cannot invoke on a nil object reference.\n" << endl;
    return;
  }

  seq_arr_uVariable in;
  seq_arr_uVariable_var out;
  seq_arr_uVariable inout;
  seq_arr_uVariable_var result;

  in.length(2);
  {
    sVariable e;
    e.s1 = (const char*) "xyz";
    uVariable u;
    u.w(e);
    for (int i=0; i<2; i++)
      for (int j=0; j<4; j++) {
	in[i][j] = u;
      }
  }
  inout = in;
  result = ser->dump_seq_arr_uVariable(in,inout,out);
  assert(result->length() == in.length());
  assert(inout.length() == in.length());
  assert(out->length() == in.length());
  {
    for (int i=0; i<2; i++)
      for (int j=0; j<4; j++) {
	assert(strcmp(result[i][j].w().s1,in[i][j].w().s1)==0);
	assert(strcmp(out[i][j].w().s1,in[i][j].w().s1)==0);
	assert(strcmp(inout[i][j].w().s1,in[i][j].w().s1)==0);
      }
  }
}

void
test_seq_arrarr_uVariable_10(CORBA::Object_ptr obj)
{
  Exercise10_var ser = Exercise10::_narrow(obj);
  if (CORBA::is_nil(ser)) {
    cerr << "test_seq_arr_double: Cannot invoke on a nil object reference.\n" << endl;
    return;
  }

  seq_arrarr_uVariable_10 in;
  seq_arrarr_uVariable_10_var out;
  seq_arrarr_uVariable_10 inout;
  seq_arrarr_uVariable_10_var result;

  in.length(2);
  {
    sVariable e;
    e.s1 = (const char*) "def";
    uVariable u;
    u.w(e);
    for (int i=0; i<2; i++)
      for (int j=0; j<4; j++)
	for (int k=0; k<8; k++) {
	  in[i][j][k] = u;
	}
  }
  inout = in;
  result = ser->dump_seq_arrarr_uVariable_10(in,inout,out);
  assert(result->length() == in.length());
  assert(inout.length() == in.length());
  assert(out->length() == in.length());
  {
    for (int i=0; i<2; i++)
      for (int j=0; j<4; j++) 
	for (int k=0; k<8; k++) {
	assert(strcmp(result[i][j][k].w().s1,in[i][j][k].w().s1)==0);
	assert(strcmp(out[i][j][k].w().s1,in[i][j][k].w().s1)==0);
	assert(strcmp(inout[i][j][k].w().s1,in[i][j][k].w().s1)==0);
      }
  }
}


int
main (int argc, char **argv) 
{
  orb = CORBA::ORB_init(argc,argv,"omniORB2");

  CORBA::Object_var obj;

  switch (argc) {
  case 2:
    {
      try {
	CosNaming::Name use_name = string_to_name(argv[1]);
	obj = getObjectReference(orb,use_name);
      }
      catch (...) {
	obj = CORBA::Object::_nil();
      }
      if (CORBA::is_nil(obj)) {
	cerr << "Cannot resolve compound name to an object reference."
	     << endl;
	return 1; 
      }
      break;
    }
  case 3:
    if (strcmp(argv[1],"-i") == 0) {
      obj = orb->string_to_object(argv[2]);
      if (CORBA::is_nil(obj)) {
	cerr << "Cannot convert stringified IOR to an object reference."
	     << endl;
	return 1;
      }
      break;
    }
  default:
    cerr << "usage: client -i <stringified IOR>" << endl;
    cerr << "       client <COSNaming compound name (e.g. x/y/test.obj)>"
	 << endl;
    return 1;
  }

  Exercise_var exvar = Exercise::_narrow(obj);
  if (CORBA::is_nil(exvar)) {
    cerr << "Argument is a nil object reference." << endl;
    return 1;
  }

  try {
    cerr << "Testing sequence<array of double>....";
    obj = exvar->ex4();
    test_seq_arr_double(obj);
    cerr << "PASSED." << endl;
    cerr << "Testing sequence<array of array of double,10>....";
    obj = exvar->ex4();
    test_seq_arrarr_double_10(obj);
    cerr << "PASSED." << endl;
    cerr << "Testing sequence<array of string>....";
    obj = exvar->ex5();
    test_seq_arr_string(obj);
    cerr << "PASSED." << endl;
    cerr << "Testing sequence<array of array of string,10>....";
    obj = exvar->ex5();
    test_seq_arrarr_string_10(obj);
    cerr << "PASSED." << endl;
    cerr << "Testing sequence<array of Echo>....";
    obj = exvar->ex6();
    test_seq_arr_Echo(obj);
    cerr << "PASSED." << endl;
    cerr << "Testing sequence<array of array of Echo,10>....";
    obj = exvar->ex6(); 
    test_seq_arrarr_Echo_10(obj);
    cerr << "PASSED." << endl;
    cerr << "Testing sequence<array of sVariable>....";
    obj = exvar->ex8();
     test_seq_arr_sVariable(obj);
    cerr << "PASSED." << endl;
    cerr << "Testing sequence<array of array of sVariable,10>....";
    obj = exvar->ex8();
    test_seq_arrarr_sVariable_10(obj);
    cerr << "PASSED." << endl;
    cerr << "Testing sequence<array of uVariable>....";
    obj = exvar->ex10();
    test_seq_arr_uVariable(obj);
    cerr << "PASSED." << endl;
    cerr << "Testing sequence<array of array of uVariable,10>....";
    obj = exvar->ex10();
    test_seq_arrarr_uVariable_10(obj);
    cerr << "PASSED." << endl;

  }
  catch(CORBA::COMM_FAILURE& ex) {
    cerr << "Caught system exception COMM_FAILURE, unable to contact the "
         << "object." << endl;
  }
  catch(omniORB::fatalException& ex) {
    cerr << "Caught omniORB2 fatalException. This indicates a bug is caught "
         << "within omniORB2.\nPlease send a bug report.\n"
         << "The exception was thrown in file: " << ex.file() << "\n"
         << "                            line: " << ex.line() << "\n"
         << "The error message is: " << ex.errmsg() << endl;
  }
  //  catch(...) {
  //    cerr << "Caught a system exception." << endl;
  //}

    return 0;
}
