// Testing code: client of seqEcho objects
// 

#include <iostream.h>
#include <stdlib.h>
#include <seqEcho.hh>
#include <common/common.h>

static double numbers[] = {
  0, 1.23, 8903, 18.029, 0.928, 1e10, 3.458e-8, 3.1416, 12348.9393,
  -289.2, -1e-10
};

int
main (int argc, char **argv) {

  CORBA::ORB_ptr orb = CORBA::ORB_init(argc,argv,"omniORB2");

  CORBA::Object_var obj;

  switch (argc) {
  case 2:
    {
      try {
	CosNaming::Name use_name = string_to_name(argv[1]);
	obj = getObjectReference(orb,use_name);
      }
      catch (...) {
	obj = CORBA::Object::_nil();
      }
      if (CORBA::is_nil(obj)) {
	cerr << "Cannot resolve compound name to an object reference."
	     << endl;
	return 1; 
      }
      break;
    }
  case 3:
    if (strcmp(argv[1],"-i") == 0) {
      obj = orb->string_to_object(argv[2]);
      if (CORBA::is_nil(obj)) {
	cerr << "Cannot convert stringified IOR to an object reference."
	     << endl;
	return 1;
      }
      break;
    }
  default:
    cerr << "usage: seqEchoclt -i <stringified IOR>" << endl;
    cerr << "       seqEchoclt <COSNaming compound name (e.g. x/y/echo.obj)>"
	 << endl;
    return 1;
  }

  seqEcho::echo_var e = seqEcho::echo::_narrow(obj);

  if (CORBA::is_nil(e))
    {
      cerr << "Can't create proxy.\n" << endl;
      return(1);
    }

  try {
    if (e->_non_existent())
      {
	cerr << "Object does not exist.\n" << endl;
      }

    for (CORBA::ULong len=0; len < 10; len++) 
      {
	seqEcho::seqchar a1;
	seqEcho::seqdouble a2;
	seqEcho::seqdouble_var a3;
	a1.length(len);
	a2.length(len);
	for (CORBA::ULong i0=0; i0 < a2.length(); i0++) {
	  //	  a2[i0] = rand();
	  a2[i0] = numbers[i0];
	  cerr << a2[i0] << " ";
	}
	cerr << endl;
	a3 = e->op1(a1,a2);
	if (a3->length() != a2.length()) {
	  cerr << "Return sequence is not the same length as sent." 
	       << a3->length() << "-" << a2.length()
	       << endl;
	  return 1;
	}
	for (CORBA::ULong i1=0; i1 < a2.length(); i1++) {
	  cerr << a3[i1] << " ";
	  if (a3[i1] != a2[i1]) {
	    cerr << "Return sequence is not the same as sent." << endl;
	    return 1;
	  }
	}
	cerr << endl;
      }
  }
  catch (const CORBA::COMM_FAILURE&) {
    cerr << "Caught COMM_FAILURE exception. Exit." << endl;
  }
  return 0;
}
