CXXSRCS = echo_i.cc echoclt.cc \
          tstexcept_i.cc tstexceptclt.cc \
          refp_i.cc refpclt.cc \
          derivedEcho_i.cc derivedEchoclt.cc \
          multiEcho_i.cc multiEchoclt.cc \
          attrEcho_i.cc attrEchoclt.cc \
          attrObjRef_i.cc attrObjRefclt.cc \
	  seqEcho_i.cc seqEchoclt.cc \
          conclt.cc consrv.cc \
          tiesrv.cc

# -t tell the compiler to generate templates for tie implementation skeletons
OMNIORB2_IDL += -t

DIR_CPPFLAGS = $(CORBA_CPPFLAGS) -I.. $(patsubst %,-I%/..,$(VPATH))

COMMON_OBJS = ../common/$(patsubst %,$(LibPattern),common)
ifdef ATMos
IMPORT_LIBRARY_DIRS += .
endif

CORBA_INTERFACES = echo tstexcept refp derivedEcho attrEcho \
                   attrObjRef multiEcho

ifndef ATMos
CORBA_INTERFACES += seqEcho
endif

echoclt        = $(patsubst %,$(BinPattern),echoclt)
echosrv        = $(patsubst %,$(BinPattern),echosrv)
nullechoclt    = $(patsubst %,$(BinPattern),nullechoclt)
tstexceptclt   = $(patsubst %,$(BinPattern),tstexceptclt)
tstexceptsrv   = $(patsubst %,$(BinPattern),tstexceptsrv)
refpclt        = $(patsubst %,$(BinPattern),refpclt)
refpsrv        = $(patsubst %,$(BinPattern),refpsrv)
derivedEchoclt = $(patsubst %,$(BinPattern),derivedEchoclt)
derivedEchosrv = $(patsubst %,$(BinPattern),derivedEchosrv)
attrEchoclt    = $(patsubst %,$(BinPattern),attrEchoclt)
attrEchosrv    = $(patsubst %,$(BinPattern),attrEchosrv)
attrObjRefclt  = $(patsubst %,$(BinPattern),attrObjRefclt)
attrObjRefsrv  = $(patsubst %,$(BinPattern),attrObjRefsrv)
multiEchoclt   = $(patsubst %,$(BinPattern),multiEchoclt)
multiEchosrv   = $(patsubst %,$(BinPattern),multiEchosrv)
seqEchoclt     = $(patsubst %,$(BinPattern),seqEchoclt)
seqEchosrv     = $(patsubst %,$(BinPattern),seqEchosrv)
conclt     = $(patsubst %,$(BinPattern),conclt)
consrv     = $(patsubst %,$(BinPattern),consrv)
tiesrv     = $(patsubst %,$(BinPattern),tiesrv)

all:: $(echoclt) $(echosrv) $(nullechoclt) $(tstexceptclt) $(tstexceptsrv) \
      $(refpclt) $(refpsrv) $(derivedEchoclt) $(derivedEchosrv) \
      $(multiEchoclt) $(multiEchosrv) $(attrEchoclt) $(attrEchosrv) \
      $(attrObjRefclt) $(attrObjRefsrv) $(multiEchoclt) $(multiEchosrv) \
      $(conclt) $(consrv) $(nullechoclt) $(tiesrv)

ifndef ATMos
all:: $(seqEchoclt) $(seqEchosrv)
endif

clean::
	$(RM) $(echoclt) $(echosrv) $(tstexceptclt) $(tstexceptsrv) \
        $(refpclt) $(refpsrv) $(derivedEchoclt) $(derivedEchosrv) \
        $(multiEchoclt) $(multiEchosrv) $(attrEchoclt) $(attrEchosrv) \
        $(attrObjRefclt) $(attrObjRefsrv) $(multiEchoclt) $(multiEchosrv) \
        $(seqEchoclt) $(seqEchosrv) $(conclt) $(consrv) $(nullechoclt) \
        $(tiesrv)

$(echoclt): echoclt.o $(COMMON_OBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

$(echosrv): echo_i.o $(COMMON_OBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

$(nullechoclt): nullecho.o $(COMMON_OBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

$(tstexceptclt): tstexceptclt.o $(COMMON_OBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

$(tstexceptsrv): tstexcept_i.o $(COMMON_OBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

$(refpclt): refpclt.o $(COMMON_OBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

$(refpsrv): refp_i.o $(COMMON_OBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

$(derivedEchoclt): derivedEchoclt.o $(COMMON_OBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

$(derivedEchosrv): derivedEcho_i.o $(COMMON_OBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

$(multiEchoclt): multiEchoclt.o $(COMMON_OBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

$(multiEchosrv): multiEcho_i.o $(COMMON_OBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

$(attrEchoclt): attrEchoclt.o $(COMMON_OBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

$(attrEchosrv): attrEcho_i.o $(COMMON_OBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

$(attrObjRefclt): attrObjRefclt.o $(COMMON_OBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

$(attrObjRefsrv): attrObjRef_i.o $(COMMON_OBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

$(seqEchoclt): seqEchoclt.o $(COMMON_OBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

$(seqEchosrv): seqEcho_i.o $(COMMON_OBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

$(conclt): conclt.o $(COMMON_OBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))

$(consrv): consrv.o $(COMMON_OBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))


$(tiesrv): tiesrv.o $(COMMON_OBJS) $(CORBA_STUB_OBJS) $(CORBA_LIB_DEPEND)
	@(libs="$(COMMON_OBJS) $(CORBA_LIB)"; $(CXXExecutable))
