// anyStructTest_i.cc
//

#include <iostream.h>
#include <stdlib.h>

#include "anyParse.h"

#include "anyStructTest_i.h"



static CORBA::Boolean viewStruct(const CORBA::Any& a)
{
  structLong* aStr;
  structDouble1* bStr;
  structDouble2* cStr;
  structVariable* dStr;
  
  seqStruct* aSeq;
  arrayStruct_forany aArr;

  structSequence* eStr;
  structArray* fStr;
  structStruct* gStr;

  CORBA::Any b;

  if (a >>= b)
    {
      cout << "Any contains any: " << endl;
      return viewStruct(b);
    }  
  else if (a >>= aStr)
    {
      cout << "structLong: " << endl;    
      cout << "Long: " << aStr->l << endl;
      cout << "Short: " << aStr->s << endl;
      return 1;
    }
  else if (a >>= bStr)
    {
      cout << "structDouble1: " << endl;    
      cout << "Double: " << bStr->d << endl;
      cout << "Long: " << bStr->l  << endl;
      return 1;
    }
  else if (a >>= cStr)
    {
      cout << "structDouble2: " << endl;
      cout << "Short: " << cStr->l  << endl;
      cout << "Double: " << cStr->d << endl;

      cout << "++Again++ : " << endl;
      structDouble2* tmpStr;

      a >>= tmpStr;
      cout << "Short: " << tmpStr->l  << endl;
      cout << "Double: " << tmpStr->d << endl;

      return 1;
    }
  else if (a >>= dStr)
    {
      cout << "structVariable: " << endl;
      cout << "String: _" << dStr->str << "_" << endl;
      cout << "Double: " << dStr->d << endl;
      return 1;
    }
  else if (a >>= aSeq)
    {
      cout << "seqStruct: " << endl;
      cout << "Number of members: " << aSeq->length() << endl;
      CORBA::ULong count = 0;
      for (count = 0; count < aSeq->length(); count++)
	{
	  cout << "[" << count << "]" << endl;
	  cout << "String: " << ((*aSeq)[count]).str << endl;
	  cout << "Double: " << ((*aSeq)[count]).d << endl;
	}
      return 1;
    }
  else if (a >>= aArr)
    {
      cout << "arrayStruct: " << endl;
      for (CORBA::ULong count = 0; count < 2; count++)
	{
	  cout << "[" << count << "]" << endl;
	  cout << "String: " << aArr[count].str << endl;
	  cout << "Double: " << aArr[count].d << endl;
	}
      return 1;
    }
  else if (a >>= eStr)
    {
      cout << "structSequence: " << endl;
      cout << "  seqStruct: " << endl;
      cout << "    Number of members: " << (eStr->s).length() << endl;
      CORBA::ULong count = 0;
      for (count = 0; count < (eStr->s).length(); count++)
	{
	  cout << "    [" << count << "]" << endl;
	  cout << "    String: " << ((eStr->s)[count]).str << endl;
	  cout << "    Double: " << ((eStr->s)[count]).d << endl;
	}
      cout << "Double: " << eStr->d << endl;

      cout << "-- [Test extracting again] --" << endl;

      structSequence* tmpStr;
      a >>= tmpStr;
      cout << "  seqStruct: " << endl;
      cout << "    Number of members: " << (tmpStr->s).length() << endl;
      for (count = 0; count < (tmpStr->s).length(); count++)
	{
	  cout << "    [" << count << "]" << endl;
	  cout << "    String: " << ((tmpStr->s)[count]).str << endl;
	  cout << "    Double: " << ((tmpStr->s)[count]).d << endl;
	}
      cout << "Double: " << tmpStr->d << endl;
      return 1;
    }
  else if (a >>= fStr)
    {
      cout << "structArray: " << endl;
      cout << "  arrayStruct:" << endl;
      for (CORBA::ULong count = 0; count < 2; count++)
	{
	  cout << "    [" << count << "]" << endl;
	  cout << "    String: " << ((fStr->ar)[count]).str << endl;
	  cout << "    Double: " << ((fStr->ar)[count]).d << endl;
	}
      
      cout << "Double: " << fStr->d << endl;
      return 1;
    }
  else if (a >>= gStr)
    {
      cout << "structStruct:" << endl;
      cout << "Double: " << gStr->d << endl;

      cout << "  structSequence:" << endl;
      cout << "    seqStruct: " << endl;
      cout << "      Number of members: " << ((gStr->st).s).length() << endl;
      for (CORBA::ULong count = 0; count < ((gStr->st).s).length(); count++)
	{
	  cout << "      [" << count << "]" << endl;
	  cout << "      String: " << (((gStr->st).s)[count]).str << endl;
	  cout << "      Double: " << (((gStr->st).s)[count]).d << endl;
	}
      cout << "    Double: " << (gStr->st).d << endl;
      return 1;
    }     
  else return 0;
}


static void viewAny(const CORBA::Any& a)
{
  if (!anyParse::parse(a))
    {
      if (!viewStruct(a))
	{
	  cerr << "Unknown type contained in any. Test failed." << endl;
	  exit(-1);
	}
    }
}


CORBA::Any* 
anyStructTest_i::testOp(const CORBA::Any& a, CORBA::Any& b, CORBA::Any*& c)
{

  cout << "\nTest number " << pass++ << endl;;
  cout << "** Incoming Anys:" << endl;

  cout << "a: " << endl;
  viewAny(a); 

  cout << "b: ";
  viewAny(b); 
  	
  c = new CORBA::Any;
  CORBA::Any* rc = new CORBA::Any;

  CORBA::ULong l = 2345;
  CORBA::Char ch = 'a';

  *c <<= l;
  *rc <<= CORBA::Any::from_char(ch);

  cout << "\n** Returning:" << endl;
  
  // bTC returned unmodified

  cout << "c: ";   viewAny(*c);
  cout << "Return value: "; viewAny(*rc);
  
  cout << "------------------------" << endl;
  return rc;
}

 
