#line 14 "main.nw"
static char rcsid[] = "$Id: main.nw,v 2.9 1997/09/13 19:59:15 nr Exp nr $";
static char rcsname[] = "$Name: v2_8a $";
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "notangle.h"
#include "errors.h"
#include "columns.h"

main(int argc, char **argv) {
    int i;
    char *rootname = "*";       /* name of the root module */
    char *locformat = "";
    char *Clocformat = "#line %L \"%F\"%N";

    tabsize = 0;  /* default for nt is not to use tabs */
    progname = argv[0];
    finalstage = 1;

    for (i=1; i<argc; i++) {
        
#line 44 "main.nw"
if (*argv[i]=='-') {
    
#line 51 "main.nw"
    switch (*++argv[i]) {
        case 't': /* set tab size or turn off */
            if (isdigit(argv[i][1]))
                tabsize = atoi(argv[i]+1);
            else if (argv[i][1]==0)
                tabsize = 0;            /* no tabs */
            else 
                errormsg(Error, "%s: ill-formed option %s\n", argv[0], argv[i]);
            break;          
        case 'R': /* change name of root module */
            rootname = ++argv[i];
            break;
        case 'L': /* have a #line number format */
            locformat = ++argv[i];
            if (!*locformat) locformat = Clocformat;
            break;
        default:
            errormsg(Warning, "Ignoring unknown option -%s", argv[i]);
     }
#line 46 "main.nw"
} else {
    
#line 72 "main.nw"
errormsg(Warning,
    "I can't handle arguments yet, so I'll just ignore `%s'",argv[i]);

#line 48 "main.nw"
}
#line 36 "main.nw"
    }

    notangle(stdin, stdout, rootname, locformat);
    nowebexit(NULL);
    return errorlevel;  /* slay warning */
}
