/*
 * DS.c - test out DS macro
 *
 * Copyright (c) 1997 Phil Maker
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: DS.c,v 1.1.1.1 1997/11/23 11:45:50 pjm Exp $
 */


#include <stdio.h>

#define DI_DEFAULT_HANDLER(e,f,l,p) \
@@call printf("fail")@@  \
@@cont @@

#include "../src/DI.h"

#include "check.h"

int main() {
     volatile int i = 10;

     struct {
       int a[5];
     } s;

     CHECKMESSAGE("# testing DS.c");

     CHECKEMPTY(DS($i = i));
     i++;
     CHECKEMPTY(DI($i == 10));
     CHECKEMPTY(DI(i == 11));
     CHECKEMPTY(DI(i == ($i + 1)));
     CHECKFAIL(DI($i == i));  

     CHECKEMPTY(DS($i = i));

     CHECKEMPTY(DI(i == $i));
     CHECKEMPTY(DI(i == 11));
     i++;
     CHECKEMPTY(DI(i == ($i + 1))); 
     CHECKFAIL(DI($i == i));  

     for(i = 0; i != 5; i++) {
       s.a[i] = i;
     }

     CHECKEMPTY(DS($s = s));
     for(i = 0; i != 5; i++) {
       CHECKEMPTY(DI($s.a[i] == i));
       s.a[i] = 0;
       CHECKFAIL(DI(s.a[i] < 0));
       CHECKEMPTY(DI(s.a[i] == 0));
     }
     CHECKFAIL(DI($s.a[4] == 0));
     CHECKEMPTY(DI(s.a[2] == 0));
     CHECKEMPTY(DS($s = s));
     CHECKEMPTY(DI(s.a[2] == 0));
     CHECKFAIL(DI($s.a[3] == 3));

     return 0;
     
}


     

