#!/bin/sh
# Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
# This file is public domain and comes with NO WARRANTY of any kind

# Mysql deamon start/stop script.

# Usually this is put in /etc/init.d (at least on machines SYSV R4
# based systems) and linked to /etc/rc3.d/S99mysql. When this is done
# the mysql server will be started when the machine is started.


PATH=/sbin:/usr/bin:/usr/sbin:/bin
basedir=@prefix@
bindir=@bindir@
mysql_root_user=root		# In the mysql 'user' table this user has shutdown priv.
mysql_root_pwd=			# The password for the mysql_root_user.
mysql_daemon_user=root		# Run mysqld as this user. Should be 'mysql'
				# If you use this, uncomment one of the su rows below
export PATH

mode=$1

# The following test may be removed if this script isn't to be run as root.
if test ! -w /
then
  echo "$0: this script must be run as root ... fatal error"
  exit 1
fi

# Safeguard (relative paths, core dumps..)
cd $basedir

case "$mode" in
  'start')
    # Start deamon

    if test -x $bindir/safe_mysqld
    then
      # -l means start with log.
      # su -c -- $mysql_daemon_user $bindir/safe_mysqld -l &	# For Linux
      # su $mysql_daemon_user $bindir/safe_mysqld -l &		# For sun
      $bindir/safe_mysqld -l &
    else
      echo "Can't execute $bindir/safe_mysqld"
    fi
    ;;

  'stop')
    # Stop deamon
    $bindir/mysqladmin -u $mysql_root_user --password=$mysql_root_pwd shutdown
    ;;

  *)
    # usage
    echo "usage: $0 start|stop"
    exit 1
    ;;
esac
