/*
 *  $Id: graph_nbr.c,v 1.18 1997/01/07 01:48:01 gropp Exp $
 *
 *  (C) 1993 by Argonne National Laboratory and Mississipi State University.
 *      See COPYRIGHT in top-level directory.
 */

#include "mpiimpl.h"
#include "mpitopo.h"

#ifndef MPIR_MIN
#define MPIR_MIN(a,b) ((a)>(b)?(b):(a))
#endif

/*@

MPI_Graph_neighbors - Returns the neighbors of a node associated 
                      with a graph topology

Input Parameters:
. comm - communicator with graph topology (handle) 
. rank - rank of process in group of comm (integer) 
. maxneighbors - size of array neighbors (integer) 

Output Parameters:
. neighbors - ranks of processes that are neighbors to specified process
 (array of integer) 

.N fortran

.N Errors
.N MPI_SUCCESS
.N MPI_ERR_TOPOLOGY
.N MPI_ERR_COMM
.N MPI_ERR_ARG
.N MPI_ERR_RANK
@*/
int MPI_Graph_neighbors ( comm, rank, maxneighbors, neighbors )
MPI_Comm  comm;
int       rank;
int      maxneighbors;
int      *neighbors;
{
  int i, begin, end, flag;
  int mpi_errno = MPI_SUCCESS;
  MPIR_TOPOLOGY *topo;
  struct MPIR_COMMUNICATOR *comm_ptr;
  static char myname[] = "MPI_GRAPH_NEIGHBORS";

  TR_PUSH(myname);

  comm_ptr = MPIR_GET_COMM_PTR(comm);
  MPIR_TEST_MPI_COMM(comm,comm_ptr,comm_ptr,myname);

  if (((rank <  0) && (mpi_errno = MPI_ERR_RANK)) ||
      MPIR_TEST_ARG(neighbors))
    return MPIR_ERROR( comm_ptr, mpi_errno, myname );

  /* Get topology information from the communicator */
  MPI_Attr_get ( comm, MPIR_TOPOLOGY_KEYVAL, (void **)&topo, &flag );

  /* Check for valid topology */
  if ( ( (flag != 1)                  && (mpi_errno = MPI_ERR_TOPOLOGY))  ||
       ( (topo->type != MPI_GRAPH)    && (mpi_errno = MPI_ERR_TOPOLOGY))  ||
       ( (rank >= topo->graph.nnodes) && (mpi_errno = MPI_ERR_RANK))      )
    return MPIR_ERROR( comm_ptr, mpi_errno, myname );

  /* Get neighbors */
  if ( rank == 0 ) begin = 0;
  else             begin = topo->graph.index[rank-1];
  end = topo->graph.index[rank];
  for ( i=begin; i<end; i++ )
    neighbors[i-begin] = topo->graph.edges[i];

  TR_POP;
  return (mpi_errno);
}
