/* 
   xbrowsercell.m

   NSBrowserCell for GNUstep GUI X/RAW Backend

   Copyright (C) 1996, 1997 Free Software Foundation, Inc.

   Author:  Scott Christley <scottc@net-community.com>
   Date: March 1996
   Author:  Felipe A. Rodriguez <far@ix.netcom.com>
   Date: July 1998
   
   This file is part of the GNUstep GUI X/RAW Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <Foundation/NSNotification.h>

#include "xbrowsercell.h"
#include <AppKit/NSWindow.h>
#include <AppKit/NSGraphics.h>
#include <AppKit/NSImage.h>
#include <AppKit/NSTextFieldCell.h>
#include <gnustep/xraw/XRCell.h>
#include <AppKit/NSColor.h>
#include <AppKit/NSFont.h>

//
// Class variables
//
static NSImage *branch_image;
static NSImage *default_image;
static NSColor *backColor;



@implementation xbrowsercell

//
// Class methods
//
+ (void)initialize
{
	if (self == [xbrowsercell class])
		{
		[self setVersion:1];								// Initial version
      											// allocate the default images
		ASSIGN(branch_image, [NSImage imageNamed: @"folder.tiff"]);
		ASSIGN(default_image, [NSImage imageNamed: @"text.tiff"]);
		backColor = [NSColor lightGrayColor];
		
		if(!branch_image)
			NSLog (@"xbrowsercell:  unable to allocate folder image ------ ");
    	}
}

//
// Instance methods
//
- initTextCell:(NSString *)aString
{
	[super initTextCell: aString];

	[self setEditable: YES];

  	ASSIGN(_branchImage, [branch_image retain]);
  	ASSIGN(_alternateImage, [default_image retain]);

	[_browserText setAlignment:NSCenterTextAlignment];

	return self;
}

//
// Displaying 
//
- (void)drawInteriorWithFrame:(NSRect)cellFrame inView:(NSView *)controlView
{
NSRect title_rect = cellFrame;
NSRect image_rect = cellFrame;
NSImage *image;

	control_view = controlView;						// Save last view drawn to

	if (cell_state)									// Clear the background
		{
		NSColor *white = [NSColor whiteColor];

		[white set];
		if (!_isLeaf)
			image = _branchImage;
		else
			image = _alternateImage;
		}									
	else
		{	
		[backColor set];
		if (!_isLeaf)
			image = _branchImage;
		else
			image = _alternateImage;
		}
	NSRectFill(cellFrame);

	image_rect.size.height = cellFrame.size.height;		// Determine image rect
	image_rect.size.width = image_rect.size.height;
														// center justify
	image_rect.origin.x += (cellFrame.size.width - image_rect.size.width)/2;

	title_rect.size.height = 17;						// Determine title rect
	image_rect.origin.y += 7;

														// Draw the title cell
  	[_browserText drawWithFrame: title_rect inView: controlView];

	if (image)											// Draw the image
    	[self _displayImage:image inFrame:image_rect];
}

- (BOOL)trackMouse:(NSEvent *)theEvent
			inRect:(NSRect)cellFrame
			ofView:(NSView *)controlView
			untilMouseUp:(BOOL)flag
{
NSRect title_rect = cellFrame;

	title_rect.size.height = 17;						// Determine title rect

	if([_browserText trackMouse:theEvent			 
			  		 inRect:title_rect					
			  		 ofView:controlView				
			  		 untilMouseUp:NO])
		{
		float titleWidth;
		NSPoint point;
		NSWindow *window = [controlView window];
		
		titleWidth = [cell_font widthOfString:[_browserText stringValue]];
												// calc y origin for text
//		title_rect.origin.y += 2;
		if (titleWidth < title_rect.size.width)
			title_rect.origin.x = title_rect.origin.x + (title_rect.size.width 
									- titleWidth) / 2;
		else
			title_rect.origin.x = title_rect.origin.x + xDist;
														// set field editor to
		[_browserText editWithFrame:title_rect 			// edit browser cell's
					  inView:controlView				// text
					  editor:[window fieldEditor:YES forObject:_browserText]	
					  delegate:self	
					  event:theEvent];

		return YES;
		}

	return NO;
}

//
// Editing Text 
//
- (BOOL)textShouldEndEditing:(NSText *)aTextObject		// NSText(field editor) 
{														// delegate method
	[_browserText endEditing:aTextObject];

	return YES;
}

- (BOOL)isOpaque								{ return YES; }

- (void)_handleKeyEvent:(NSEvent*)keyEvent
{
	fprintf(stderr, " XRBrowserCell: _handleKeyEvent --- ");
}

- (NSImage *)image
{
	if (!_isLeaf)
		return _branchImage;
	else
		return _alternateImage;
}

@end
