/* 
   Controller.m

   Controller class for the GNUstep Interface Modeller

   Copyright (C) 1996, 1997 Free Software Foundation, Inc.

   Author: Scott Christley <scottc@net-community.com>
   Date: August 1996
   Author:  Felipe A. Rodriguez <far@ix.netcom.com>
   Date: Sept 1998
  
   This file is part of the GNUstep Interface Modeller.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <AppKit/AppKit.h>

#include "Controller.h"
#include "IMModelWindow.h"
#include "IMModelView.h"


@implementation Controller

//
// Instance methods
//
- init
{
	[super init];
	
	paint_panel = nil;
	palettePanel = nil;
	inspector_panel = nil;
	user_models = [[NSMutableArray alloc] initWithCapacity: 2];
	
	return self;
}

- (void)dealloc
{
	[user_models release];
	[super dealloc];
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
IMModelWindow *im_main;
NSRect wf0 = {{100, 100}, {600, 600}};
NSRect wcf0 = {{0, 0}, {600, 600}};
NSButton *b0, *b1;
NSRect bf0 = {{10, 10}, {200, 50}};
NSRect bf1 = {{100, 100}, {200, 50}};
NSView *contentView;
unsigned int style = NSTitledWindowMask | NSClosableWindowMask				
					| NSMiniaturizableWindowMask | NSResizableWindowMask;

 													// Create the main window
	im_main = [[IMModelWindow alloc] initWithContentRect:wf0	
									 styleMask:style		
									 backing:NSBackingStoreNonretained
									 defer:NO];
	contentView = [[IMModelView alloc] initWithFrame:wcf0];
	[im_main setContentView: contentView];
	[im_main setTitle:@"GNUstep Interface Modeller"];
	[im_main setFrame:wf0 display:YES];
	[im_main display];
	[im_main orderFront:nil];
													// create test controls
	b0 = [[NSButton alloc] initWithFrame: bf0];
	b1 = [[NSButton alloc] initWithFrame: bf1];
	[[im_main contentView] addSubview: b0];
	[[im_main contentView] addSubview: b1];
	[b0 display];

	[contentView display];
}

//
// Display the panels
//
- (void)showPaintPanel:sender
{
NSRect r = {{0, 0}, {200, 200}};

	if (!paint_panel)							
		{
		paint_panel = [[NSPanel alloc] init];
		[paint_panel setFrame: r display: YES];
		[paint_panel center];
		}

	[paint_panel makeKeyAndOrderFront: sender];
}

- createPalettePanel
{
NSRect pf = {{680, 510}, {270, 245}};
NSRect tf = {{10, 10}, {100, 32}};
NSButton *b;
NSRect bf = {{10, 52}, {100, 32}};

	palettePanel = [[NSPanel alloc] init];
	[palettePanel setTitle:@"Palettes"];

	b = [[NSButton alloc] initWithFrame: bf];
    [b setButtonType: NSOnOffButton];
    [b setTitle: @"Test Interface"];
    [b setTarget:self];
    [b setAction:@selector(setTestInterface:)];
	testInterface = NO;

	textfield = [[NSTextField alloc] initWithFrame: tf];
    [textfield setStringValue:@"model"];
	[[palettePanel contentView] addSubview: b];
	[[palettePanel contentView] addSubview: textfield];

	[palettePanel setFrame: pf display: YES];
	[palettePanel orderFront:nil];
	
	return palettePanel;
}

- (void)showPalettePanel:sender
{
	if (!palettePanel)									// create palette if 
		palettePanel = [self createPalettePanel];		// it doesn't exist

	[palettePanel makeKeyAndOrderFront: sender];
}

- (void)showInspectorPanel:sender
{
	if (!inspector_panel)
		inspector_panel = [[NSPanel alloc] init];

	[inspector_panel makeKeyAndOrderFront: sender];
}
													// Working with model files
- (void)newModelFile:sender
{
}

- (void)openModelFile:sender
{
}

- (void)closeModelFile:sender
{
}

- (void)saveModelFile:sender
{
}

- (void)saveAsModelFile:sender
{
} 

- (void)method:menuCell								// temp for sake of menu
{
  	NSLog (@"method invoked from cell with title '%@'", [menuCell title]);
}

- (void)setTestInterface:(id)sender					// toggle between model and
{													// test interface modes
	NSLog (@"testInterface:");
	[textfield setStringValue:[sender intValue] ? @"test" : @"model"];
	[textfield display];
	testInterface = [sender intValue];
}

- (BOOL)testInterface
{													// return mode IM's mode
	return testInterface;							// YES == test mode
}													// NO  == model mode

@end
