/* xrcontext - Definitions for X-Windows specific implementation of OpenStep

   Copyright (C) 1995 Free Software Foundation, Inc.

   Written by:  Adam Fedor <fedor@boulder.colorado.edu>
   Date: Nov 1995
   
   This file is part of the GNU Objective C User interface library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   */

#ifndef _xrcontext_h_INCLUDE
#define _xrcontext_h_INCLUDE

#define Object X11Object        /* To avoid problems with Objective C */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#undef Object

#ifdef XSHM
#include <X11/extensions/XShm.h>
#endif

#include <Foundation/NSGeometry.h>

typedef enum {
  gray_colorspace, rgb_colorspace, hsb_colorspace, cmyk_colorspace
} xr_device_colorspace_t;

typedef enum {
  no_colormap = -2, four_colormap, gray_colormap, rgb_colormap
} xr_colormap_style_t;

typedef enum {
  XRVisualId = 0x01,
  XRDefaultVisual = 0x02,
  XRNumberOfGrays = 0x04,
  XRColorsPerChannel = 0x08,
  XRGamma = 0x10,
  XRColormapStyle = 0x20,
  XRPrivateColormap = 0x40,
} xr_context_flags_t;

typedef struct _xr_device_color {
  xr_device_colorspace_t space;
  float field[6];
} xr_device_color_t;

typedef struct xr_context_attributes_t {
    int flags;
    int render_mode;
    int colors_per_channel;    /* for PseudoColor */
    int colormap_style;	       /* for PseudoColor */
    float rgamma;		       /* gamma correction for red, */
    float ggamma;		       /* green, */
    float bgamma;		       /* and blue */
    int number_of_grays;
    int use_shared_memory;
    VisualID visualid;
} xr_context_attributes_t;

/* Specific X-Windows information used by the context */
typedef struct _xr_context_t {
    void *context_obj;
    Display *display;
    int screen_number;
    XVisualInfo	vinfo;

    Window drawable;
    Region viewclip;
    xr_context_attributes_t attr;

    /* Colormap info */
    XStandardColormap *rgbmap;
    XStandardColormap *graymap;
    int ncolors, ngrays;
    unsigned long black;
    unsigned long white;
    unsigned long ltgray;
    unsigned long dkgray;
    /* Extra colors */
    XColor *colors;
    int nextracolors;
} xr_context_t;

#endif
