/* 
   XRText.m

   NSText for GNUstep GUI X/RAW Backend

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Felipe A. Rodriguez <far@ix.netcom.com>
   Date: July 1998
   
   This file is part of the GNUstep GUI X/RAW Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <Foundation/NSAutoreleasePool.h>
#include <Foundation/NSString.h>
#include <Foundation/NSException.h>

#include <AppKit/NSColor.h>
#include <AppKit/NSFont.h>
#include <AppKit/NSCStringText.h>
#include <AppKit/NSStringDrawing.h>
#include <AppKit/PSMatrix.h>

#include <gnustep/xraw/XR.h>
#include "config.h"





@implementation XRText

//
// Displaying
//

- (void)displayRect:(NSRect)rect
{
NSRect aRect = rect;

	fprintf (stderr,
	"XRText displayRect0: rect origin (%1.2f, %1.2f), size (%1.2f, %1.2f)\n",
				rect.origin.x, rect.origin.y, 
				rect.size.width, rect.size.height);

	if(rect.origin.y < 0)	
		{											// FIX ME this should
		fprintf (stderr, "XRText displayRect: zero\n");
		return;											// not happen
		}

///	aRect.origin.y = [super_view bounds].size.height - aRect.origin.y;	
///	aRect.origin.y = [window frame].size.height - aRect.origin.y;
	
	aRect.origin.y -= aRect.size.height;
	
	fprintf (stderr,
	"XRText displayRect1: aRect origin (%1.2f, %1.2f), size (%1.2f, %1.2f)\n",
				aRect.origin.x, aRect.origin.y, 
				aRect.size.width, aRect.size.height);
	fprintf (stderr,
	"XRText displayRect2: frame origin (%1.2f, %1.2f), size (%1.2f, %1.2f)\n",
				[super_view frame].origin.x, [super_view frame].origin.y, 
				[super_view frame].size.width, [super_view frame].size.height);

	[super displayRect:aRect];
}

//#define FAR_DEBUG 1

-(void) setFrame:(NSRect)frameRect
{	
	fprintf (stderr,
"XRText set frameRect: origin (%1.2f, %1.2f), size (%1.2f, %1.2f)\n",
		frameRect.origin.x, frameRect.origin.y, 
		frameRect.size.width, frameRect.size.height);

	[super setFrame:frameRect];

	fprintf (stderr,
"XRText set frame: rect origin (%1.2f, %1.2f), size (%1.2f, %1.2f)\n",
		frame.origin.x, frame.origin.y, 
		frame.size.width, frame.size.height);
}

- (void) sizeToFit
{
	if(![self isFieldEditor])
		[super sizeToFit];
}

- (NSRect)visibleRect
{
	if (!super_view)
		return bounds;
	else 
		{
		NSRect svrect = [super_view visibleRect];
//		NSRect csvrect = [self convertRect:svrect fromView:super_view];
		NSRect csvrect = svrect;
		NSRect rect;

		if(csvrect.origin.y > 0)
			csvrect.origin.y = bounds.size.height - csvrect.size.height;

		rect = NSIntersectionRect (csvrect, bounds);

//#ifdef FAR_DEBUG
	fprintf (stderr,
"XRText bounds: rect origin (%1.2f, %1.2f), size (%1.2f, %1.2f)\n",
		bounds.origin.x, bounds.origin.y, 
		bounds.size.width, bounds.size.height);
	fprintf (stderr,
"XRText frame: rect origin (%1.2f, %1.2f), size (%1.2f, %1.2f)\n",
		frame.origin.x, frame.origin.y, 
		frame.size.width, frame.size.height);
	fprintf (stderr,
"XRText svrect: rect origin (%1.2f, %1.2f), size (%1.2f, %1.2f)\n",
		svrect.origin.x, svrect.origin.y, 
		svrect.size.width, svrect.size.height);
	fprintf (stderr,
"XRText csvrect: rect origin (%1.2f, %1.2f), size (%1.2f, %1.2f)\n",
		csvrect.origin.x, csvrect.origin.y, 
		csvrect.size.width, csvrect.size.height);
	fprintf (stderr,
	"XRText visibleRect: rect origin (%1.2f, %1.2f), size (%1.2f, %1.2f)\n",
				rect.origin.x, rect.origin.y, 
				rect.size.width, rect.size.height);
//#endif																		

		return rect;
  		}
}

-(void)keyDown:(NSEvent *)theEvent
{
	[super keyDown:theEvent];
	
	[window _view:self needsFlushInRect:[super_view bounds]];		
	[window flushWindow];
}

- (void)mouseDown:(NSEvent *)theEvent
{
	[super mouseDown:theEvent];

	[window _view:self needsFlushInRect:[super_view bounds]];		
	[window flushWindow];
}

- (NSPoint)convertPoint:(NSPoint)aPoint
	           fromView:(NSView*)aView 
{												// override point conversion
NSPoint new;									// method because view is				
PSMatrix* matrix;								// flipped

	if (!aView)
		aView = [window contentView];

//#define FAR_DEBUG 1
#ifdef FAR_DEBUG
	fprintf(stderr,"XRText convertPoint0 x %f y %f \n", aPoint.x, aPoint.y);
#endif /* FAR_DEBUG */

	if ([self isDescendantOf:aView]) 
		{
    	NSArray* path = [self _pathBetweenSubview:self toSuperview:aView];

    	matrix = [self _concatenateMatricesInReverseOrderFromPath:path];
    	[matrix inverse];
    	new = [matrix pointInMatrixSpace:aPoint];
  		}
  	else 
		if ([aView isDescendantOf:self]) 
			{
    		NSArray* path = [self _pathBetweenSubview:aView toSuperview:self];

   			matrix = [self _concatenateMatricesInReverseOrderFromPath:path];
    		new = [matrix pointInMatrixSpace:aPoint];
  			}			// The views are not in the same hierarchy of views.
  		else 			// Convert the point to window from the other's view's
			{			// coordinates and then to our view coordinates.
			new = [aView convertPoint:aPoint toView:nil];
    		new = [self convertPoint:new fromView:nil];
  			}

#ifdef FAR_DEBUG
	fprintf(stderr,"XRText convertPoint1 x %f y %f \n", new.x, new.y);
#endif /* FAR_DEBUG */


if(bounds.size.height > [super_view frame].size.height)
//	new.y = (bounds.size.height - new.y) - (bounds.size.height - 
//			[super_view bounds].origin.y) + ([super_view bounds].origin.y - 
//			[super_view frame].size.height);	
	new.y = [super_view frame].size.height - new.y + 
			(2*[super_view bounds].origin.y);	
else
//	new.y = (bounds.size.height - (bounds.size.height - 
//			[super_view bounds].origin.y)) - new.y;
	new.y = bounds.size.height - new.y;


#ifdef FAR_DEBUG
	fprintf(stderr,"XRText convertPoint2 x %f y %f \n", new.x, new.y);	
	fprintf(stderr,"XRText convertPoint bounds.size.height x %f \n", bounds.size.height);
	fprintf(stderr,"XRText convertPoint frame.size.height x %f \n", frame.size.height);
	fprintf(stderr,"XRText convertPoint frame.origin.y x %f \n", frame.origin.y);
	fprintf(stderr,"XRText convertPoint [super_view bounds].origin.y x %f \n", [super_view bounds].origin.y);
	fprintf(stderr,"XRText convertPoint [super_view frame].size.height x %f \n", [super_view frame].size.height);
#endif /* FAR_DEBUG */
																	
	return new;
}

@end
