/* 
   XRStringDrawing.m

   Category which adds draw capabilities to NSString.

   Copyright (C) 1997 Free Software Foundation, Inc.

   Author:  Felipe A. Rodriguez <far@ix.netcom.com>
   Date: Aug 1998
   
   This file is part of the GNUstep GUI X/RAW Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <AppKit/NSStringDrawing.h>
#include <gnustep/xraw/XR.h>

#define TABWIDTH 4										// default tab width
														// is 4 spaces

@implementation NSString (XRStringDrawing)

- (void)drawAtPoint:(NSPoint)point withAttributes:(NSDictionary *)attrs
{
NSColor *textColor;
NSArray *subStrings;
NSString *aStr;
int numberOfSubStrings, i;
static float tabSize;
NSFont *font;
static NSFont *lastFont = nil;
int strLength;
float adjTabSize, charToTabRatio;

	if(!(textColor = [attrs objectForKey:NSForegroundColorAttributeName]))
		{	 												
		textColor = [NSColor blackColor];					// default color
		NSLog (@"XRStringDrawing drawAtPoint: text color not specified.");
		}
	[textColor set];										// set text color
															
	if(!(font = [attrs objectForKey:NSFontAttributeName]))	// if font is not
		font = [NSFont userFontOfSize:12];					// specified, use
	[font set];												// the default

	if(font != lastFont)
		{
		tabSize = TABWIDTH * [font widthOfString:@"\t"];	// calc tab width
		lastFont = font;
		}
															// divide string  
	subStrings = [self componentsSeparatedByString:@"\t"];	// contents at tabs
	numberOfSubStrings = [subStrings count];
	for(i = 0; i < numberOfSubStrings; i++)		// cycle thru the str's array
		{										// displaying each then adding 
		aStr = [subStrings objectAtIndex:i];	// TABWIDTH spaces for tabs

		if((strLength = [aStr length]) == 0)		// str is a tab so just inc
			point.x += tabSize;						// the display position
		else										 
			{							// calc adjTabSize in order to place 
										// tabs evenly along the X axis
			charToTabRatio = (float)strLength / (float)TABWIDTH;
			charToTabRatio = charToTabRatio - floor(charToTabRatio);
			adjTabSize = charToTabRatio == 0 ? tabSize 
							: tabSize - (tabSize * charToTabRatio);

			XRDrawString([aStr cString], NSMakeRect(point.x, point.y, 0, 0));
													// calc X axis position for
													// displaying the next str
			point.x += [font widthOfString:aStr] + adjTabSize;
			}
		}
}																		

- (void)drawInRect:(NSRect)rect withAttributes:(NSDictionary *)attrs
{
fprintf(stderr,"string %s drawAtPoint x %f y %f \n", [self cString], rect.origin.x, rect.origin.y);																		
	XRDrawString([self cString], rect);									// draw 
}																		// text

@end
