/* 
   XRContext.h

   GSContext for GNUstep GUI X/RAW Backend.  Conceptually, instances of 
   this subclass encapsulate the connection to an X display.

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Felipe A. Rodriguez <far@ix.netcom.com>
   Date: November 1998
   
   This file is part of the GNUstep GUI X/RAW Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#ifndef _GNUstep_H_XRContext
#define _GNUstep_H_XRContext

#include <gnustep/xraw/stdxr.h>
#include <AppKit/GSContext.h>

@class XRWindow;


@interface XRContext : GSContext
{
	Display *xDisplay;
	Window xAppRootWindow;
	Window xDisplayRootWindow;
}

//
// Class methods
//
+ (Display*) currentXDisplay;

//
// Controlling the X Display connection
//
- (Display*)xDisplay;
- (void)setXDisplay:(Display *)xdisplay;
- (Window)xDisplayRootWindow;
- (Window)xAppRootWindow;

//
// Controlling the Context
//
- (void)flush;
- (void)interruptExecution;
- (void)resetCommunication;
- (void)wait;

//
// Coordinate translation
//
- (NSPoint)userPointFromXPoint:(NSPoint)xPoint;
- (NSPoint)XPointFromUserPoint:(NSPoint)userPoint;
- (NSSize)userSizeFromXSize:(NSSize)xSize;
- (NSSize)XSizeFromUserSize:(NSSize)userSize;

@end

#endif /* _GNUstep_H_XRContext */
