/* 
   PXKView.h

   NSView for GNUstep GUI X/DPS Backend

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Pascal Forget <pascal@wsc.com>
   Date: September 1995
   
   This file is part of the GNUstep GUI X/DPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#ifndef _GNUstep_H_PXKView
#define _GNUstep_H_PXKView

#include <AppKit/NSView.h>

@interface PXKView : NSView
{
}

- (void)_displayNeededViews;
- (void)_recursivelyResetNeedsDisplayInAllViews;
- (void)_removeSubviewFromViewsThatNeedDisplay:(PXKView*)view;

/* Collects into `array' the invalid rectangles that need to be displayed. All
   the rectangles are expressed in the window coordinates and not of the views
   they come from. */
- (void)_collectInvalidatedRectanglesInArray:(NSMutableArray*)array
  originMatrix:(PSMatrix*)matrix1
  sizeMatrix:(PSMatrix*)matrix2;

@end

#endif /* _GNUstep_H_PXKView */
