/* 
   test-fault.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Mircea Oancea <mircea@jupiter.elcom.pub.ro>
   Date: 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __test_fault_h__
#define __test_fault_h__

#include <eoaccess/EOFault.h>
#include <eoaccess/EOFaultResolver.h>

@interface TestFault : NSObject
{
    id fault;
}

- initWithFault:aFault;
- faultInstance;
+ (void)setThrowOnFault:(BOOL)yn;

// 
+ fault_objectFaultWithPrimaryKey:(NSDictionary*)key
    entity:(EOEntity*)entity 
    databaseChannel:(EODatabaseChannel*)channel
    zone:(NSZone*)zone;
+ (NSArray*)fault_arrayFaultWithQualifier:(EOQualifier*)qualifier 
    fetchOrder:(NSArray*)fetchOrder 
    databaseChannel:(EODatabaseChannel*)channel
    zone:(NSZone*)zone;

// Inquire about a fault

+ (BOOL)fault_isFault:object;
+ (void)fault_clearFault:fault;
+ (Class)fault_targetClassForFault:fault;
+ (NSDictionary*)fault_primaryKeyForFault:fault;
+ (EOEntity*)fault_entityForFault:fault;
+ (EOQualifier*)fault_qualifierForFault:fault;
+ (NSArray*)fault_fetchOrderForFault:fault;
+ (EODatabaseChannel*)fault_databaseChannelForFault:fault;

// Non-Faulting Instance methods

+ fault_superclass;
+ (Class)fault_class;
+ (BOOL)fault_isKindOfClass:(Class)aClass;
+ (BOOL)fault_isMemberOfClass:(Class)aClass;
+ (BOOL)fault_conformsToProtocol:(Protocol*)aProtocol;
+ (BOOL)fault_respondsToSelector:(SEL)aSelector;
+ fault_self;
+ (void)fault_dealloc;
+ fault_retain;
+ (void)fault_release;
+ fault_autorelease;
+ (unsigned)fault_retainCount;
+ (NSZone*)fault_zone;
+ (BOOL)fault_isProxy;
+ (NSString*)fault_description;

- fault_superclass;
- (Class)fault_class;
- (BOOL)fault_isKindOfClass:(Class)aClass;
- (BOOL)fault_isMemberOfClass:(Class)aClass;
- (BOOL)fault_conformsToProtocol:(Protocol*)aProtocol;
- (BOOL)fault_respondsToSelector:(SEL)aSelector;
- fault_self;
- (void)fault_dealloc;
- fault_retain;
- (void)fault_release;
- fault_autorelease;
- (unsigned)fault_retainCount;
- (NSZone*)fault_zone;
- (BOOL)fault_isProxy;
- (NSString*)fault_description;
@end /* test-fault */

@interface TestFaultChannel : NSObject
{
    int		level;
    BOOL	fetching;
    NSArray*	objects;
    int		index;
}

- init;
- setObjectsToFetch:(NSArray*)array;

- databaseContext;
- (BOOL)beginTransaction;
- (BOOL)commitTransaction;
- (void)rollbackTransaction;
- (int)transactionNestingLevel;

- (BOOL)isFetchInProgress;
- (BOOL)selectObjectsDescribedByQualifier:(EOQualifier*)qualifier
  fetchOrder:(NSArray*)fetchOrder;
- fetchWithZone:(NSZone*)zone;
- (void)cancelFetch;

- allocateObjectForRow:(NSDictionary*)row entity:(EOEntity*)entity 
  zone:(NSZone*)zone;
@end

#endif /* __test_fault_h__ */
