/* 
   main.m

   Copyright (C) 1997 Free Software Foundation, Inc.

   Author: Scott Christley <scottc@net-community.com>
   Date: August 1997

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

// #include <ObjCTest/tests.h>
#include <Foundation/NSException.h>
#include <Foundation/NSValue.h>
#include <eoaccess/eoaccess.h>
#include <eoaccess/EOPrimaryKeyDictionary.h>
#include <eoaccess/EOExpressionArray.h>

#include "MyEOModelClasses.h"
#include "MyObject.h"
#include "FakeAdaptor.h"
#include "test-classes.h"

int
main(int argc, char** argv, char** env)
{
#if LIB_FOUNDATION_LIBRARY
    [NSProcessInfo initializeWithArguments:argv count:argc environment:env];
#endif

  /* Customize behaviour of some DB classes */
  [MyEOModel poseAsClass:[EOModel class]];
  [MyEOEntity poseAsClass:[EOEntity class]];
  [MyEOAttribute poseAsClass:[EOAttribute class]];
  [MyEORelationship poseAsClass:[EORelationship class]];
  [MyEOJoin poseAsClass:[EOJoin class]];

  //  run_test();

  return 0;
}


@class KeyValueCodingIvar;
@class KeyValueCodingMethod;

@interface MyObject (DebugMethods)
@end
@implementation MyObject (DebugMethods)

- (void)debugMethod
{
  id key1 = [NSString stringWithCString: "key1"];
  id val1 = [NSNumber numberWithInt:1];

  id karray1 = [NSArray arrayWithObject:key1];
  id varray1 = [NSArray arrayWithObject:val1];
  id row1 = [NSDictionary dictionaryWithObjects:varray1 forKeys:karray1];
}

@end
