/* 
   EOControllerPrivate.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Mircea Oancea <mircea@jupiter.elcom.pub.ro>
   Date: November 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __EOControllerPrivate_H__
#define __EOControllerPrivate_H__

#include <eointerface/EOController.h>

/*
 * _EOOperation
 */

typedef enum {
	_EOUpdate=0, _EOInsert=1, _EODelete=2, _EORollBack=3
} _EOControllerOperation;

@interface _EOOperation : NSObject
{
    _EOControllerOperation	operation;
    id 				object;
    id				newvalues;
    id				oldvalues;
    int				index;
}

- initOperation:(_EOControllerOperation)op onObject:obj new:new old:old;
- initOperation:(_EOControllerOperation)op onObject:obj index:(int)ind;
- (void)dealloc;
- (void)setOperation:(_EOControllerOperation)op;
- (_EOControllerOperation)operation;
- (id)object;
- (id)newvalues;
- (id)oldvalues;
- (int)index;

@end /* _EOOperation */

/*
 * _EOUndoGroup
 */
 
@interface _EOUndoGroup : NSObject
{
    NSMutableArray*		stack;
}

- init;
- (void)dealloc;
- (void)pushController:ctrl;
- (id)popController;
- (void)removeController:ctrl;
- (void)removeAllControllers;
- (BOOL)hasUndos;

@end /* _EOUndoGroup */

@interface EOController(Private)
- (void)__recursePerform:(SEL)sel root:(id)root;
- (void)__recursePerform:(SEL)sel arg:(id)arg root:(id)root;
- (id)__recursePerformUntilYES:(SEL)sel root:(id)root;
- (id)__recursePerformUntilNO:(SEL)sel root:(id)root;

- (void)__notifyAssociations:(SEL)sel;
- (void)__notifySelectionChanged;

- (BOOL)_fetch:root;

- (BOOL)_setSelectionForObjects:(NSArray*)list detailDiscard:(BOOL)yn;

- (void)_addEdits:edits object:obj markUndo:(BOOL)yn;

- (void)_resort;

- (BOOL)_deleteObject:obj atIndex:(int)index markUndo:(BOOL)yn;
- (BOOL)_deleteObjectIndexes:indx;

- (BOOL)_insertObject:obj atIndex:(int)index markUndo:(BOOL)yn;

- (void)_discardEdits:root;
- (void)_discardOperations:root;
- (BOOL)_isDiscardAllowed:root;
- (BOOL)_detailDiscardIfAllowed;
- (BOOL)_detailDiscard;

- (void)_reduceEdits;
- (NSDictionary*)_coerceEdits:(NSDictionary*)edits;
- (BOOL)_updateObject:obj;
- (BOOL)_saveToObjects:root;

- (void)_reduceOperations;
- (EODataSourceFailureResponse)_dataSourceOperation:(_EOControllerOperation)op
  onObject:(id)obj;
- (BOOL)_saveToDataSourceRollback:(id)root;
- (BOOL)_saveToDataSourceCommit:(id)root;
- (BOOL)_saveToDataSourcePrepare:(id)root;

- (void)_addUndo:(id)op mark:(BOOL)yn;
- (void)_undo;
- (void)_redisplay:root;
- (void)_setUndoGroup:ctrl root:root;
- (id)_askUndoGroupForController:root;
@end

#endif /* __EOControllerPrivate_H__ */
