/* 
   SQLServerValues.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Author: Scott Christley <scottc@net-community.com>
   Date: October 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __SQLServerValues_h__
#define __SQLServerValues_h__

#include <Foundation/NSString.h>
#include <Foundation/NSValue.h>
#include <Foundation/NSData.h>
#include <Foundation/NSDate.h>
#include <eoaccess/EONull.h>

@class EOAttribute;
@class SQLServerChannel;

@interface NSString (SQLServerValueCreation)
+ valueFromBytes:(const char*)bytes
  length:(unsigned)lenth
  sqlserverType:(int)type
  attribute:(EOAttribute*)attribute
  adaptorChannel:(SQLServerChannel*)channel
  zone:(NSZone*)zone;
- (NSString*)stringValueForSQLServerType:(int)type
  attribute:(EOAttribute*)attribute;
@end

@interface NSNumber (SQLServerValueCreation)
+ valueFromBytes:(const char*)bytes
  length:(unsigned)lenth
  sqlserverType:(int)type
  attribute:(EOAttribute*)attribute
  adaptorChannel:(SQLServerChannel*)channel
  zone:(NSZone*)zone;
- (NSString*)stringValueForSQLServerType:(int)type
  attribute:(EOAttribute*)attribute;
@end

@interface NSData (SQLServerValueCreation)
+ valueFromBytes:(const char*)bytes
  length:(unsigned)lenth
  sqlserverType:(int)type
  attribute:(EOAttribute*)attribute
  adaptorChannel:(SQLServerChannel*)channel
  zone:(NSZone*)zone;
- (NSString*)stringValueForSQLServerType:(int)type
  attribute:(EOAttribute*)attribute;
@end

@interface NSCalendarDate (SQLServerValueCreation)
+ valueFromBytes:(const char*)bytes
  length:(unsigned)lenth
  sqlserverType:(int)type
  attribute:(EOAttribute*)attribute
  adaptorChannel:(SQLServerChannel*)channel
  zone:(NSZone*)zone;
- (NSString*)stringValueForSQLServerType:(int)type
  attribute:(EOAttribute*)attribute;
@end

@interface EONull (SQLServerValueCreation)
- (NSString*)stringValueForSQLServerType:(int)type
  attribute:(EOAttribute*)attribute;
@end

@interface NSObject (SQLServerValueCreation)
+ valueFromBytes:(const char*)bytes
  length:(unsigned)lenth
  sqlserverType:(int)type
  attribute:(EOAttribute*)attribute
  adaptorChannel:(SQLServerChannel*)channel
  zone:(NSZone*)zone;
- (NSString*)stringValueForSQLServerType:(int)type
  attribute:(EOAttribute*)attribute;
@end

#endif /* __SQLServerValues_h__ */
