/* 
   Postgres95Channel.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Mircea Oancea <mircea@jupiter.elcom.pub.ro>
	      based on the Sybase Adaptor written by 
	   Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: December 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __Postgres95Channel_h__
#define __Postgres95Channel_h__

#include <eoaccess/EOAdaptorChannel.h>
#include <eoadaptors/Postgres95/Postgres95Adaptor.h>

@class NSMutableDictionary;
@class NSMutableArray;
@class EOAttribute;

@interface Postgres95Channel : EOAdaptorChannel
{
    Postgres95Adaptor* adaptor;
    PGconn* pgConn;
    PGresult* pgResult;
    id sqlExpression;
    int currentResultRow;
    NSMutableDictionary* oidToTypeName;
    
    struct {
	BOOL postgres95InsertedRowOid:1;
	BOOL postgres95Notification:1;
    } postgres95DelegateRespondsTo;
}

- (PGconn*)pgConn;
- (PGresult*)pgResult;
- (void)cancelResults;
- (BOOL)advanceRow;

/* Private methods */
- (char*)_readBinaryDataRow:(Oid)oid length:(int*)length zone:(NSZone*)zone;
- (Oid)_insertBinaryData:(NSData*)binaryData forAttribute:(EOAttribute*)attr;
- (Oid)_updateBinaryDataRow:(Oid)oid data:(NSData*)binaryData;
- (void)_describeDatabaseTypes;
@end

@interface NSObject (Postgres95ChannelDelegate)
- (void)postgres95Channel:(Postgres95Channel*)channel
  insertedRowWithOid:(Oid)oid;
- (void)postgres95Channel:(Postgres95Channel*)channel
  receivedNotification:(NSString*)notification;
@end

#endif /* __Postgres95Channel_h__ */
