/* 
   EOGenericRecord.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Mircea Oancea <mircea@jupiter.elcom.pub.ro>
   Date: 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __EOGenericRecord_h__
#define __EOGenericRecord_h__

#include <Foundation/NSObject.h>

@class NSArray;
@class NSMutableArray;
@class NSDictionary;
@class NSMutableDictionary;
@class NSString;
@class NSData;

@class EOEntity;

/*
 * EOGeneric record class, used for enterprise objects
 * that do not have special data handling
 */

@interface EOGenericRecord : NSObject
{
    EOEntity* entity;
    NSMutableDictionary* values;
}

// Initializing new instances

- initWithPrimaryKey:(NSDictionary*)aKey entity:(EOEntity*)anEntity;

// Getting the associated entity

- (EOEntity*)entity;

// Key-value coding methods

- (BOOL)takeValuesFromDictionary:(NSDictionary*)dictionary;
- (NSDictionary*)valuesForKeys:(NSArray*)keys;

// Shortcuts to key-value coding methods

- (void)setObject:anObject forKey:aKey;
- objectForKey:aKey;
- (void)removeObjectForKey:aKey;

@end /* EOGenericRecord */


/*
 * Informal protocol. NOT implemented by NSObject.
 * Before sending one of this messages the caller must
 * check if the object responds to them.
 */

@interface NSObject(EOGenericRecord)

/*
 * Initialize an new instance of an object. 
 * If an enterprise object does not respond
 * to this method it will receive -init.
 */
- initWithPrimaryKey:(NSDictionary*)key entity:(EOEntity*)entity;

/*
 * Determines the entity of user defined objects, 
 * when more than one entity uses the same class for its objects.
 */
- (EOEntity*)entity;

/*
 * Determine the class for object based on its fetched row. 
 * The returned class *must* be a subclass of the class that 
 * receives this method.
 */
+ (Class)classForEntity:(EOEntity*)entity values:(NSDictionary*)values;
@end

#endif		/* __EOGenericRecord_h__ */
