/****************************************************************************/
/*                                                                          */
/*                           GNAT COMPILER TOOLS                            */
/*                                                                          */
/*                            G N A T C H O P                               */
/*                                                                          */
/*                          C Implementation File                           */
/*                                                                          */
/*                            $Revision: 1.2 $                              */
/*                                                                          */
/*             Copyright (C) 1996 Free Software Foundation, Inc.            */
/*                                                                          */
/* GNAT is free software;  you can  redistribute it  and/or modify it under */
/* terms of the  GNU General Public License as published  by the Free Soft- */
/* ware  Foundation;  either version 2,  or (at your option) any later ver- */
/* sion.  GNAT is distributed in the hope that it will be useful, but WITH- */
/* OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License */
/* for  more details.  You should have  received  a copy of the GNU General */
/* Public License  distributed with GNAT;  see file COPYING.  If not, write */
/* to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, */
/* MA 02111-1307, USA.                                                      */
/*                                                                          */
/* GNAT was originally developed  by the GNAT team at  New York University. */
/* It is now maintained by Ada Core Technologies Inc (http://www.gnat.com). */
/*                                                                          */
/****************************************************************************/

/* 
 * This program is for Open/VMS Alpha.  The GNAT spawn routine on VMS uses the
 * fork/exec calls, but they can't handle command files, so we have this
 * wrapper program that gets execed instead and then uses the VMS lib$spawn
 * routine to spawn gnatchop.com. This program is GNAT spawned from gnatcmd,
 * and is not needed when invoking gnatchop.com directly. Since a .com
 * extension appears (alphabetically) before a .exe extension, there is no
 * confusion by DCL.
 */

#include "config.h"

extern char* locate_regular_file();
typedef struct dsc {unsigned short len, mbz; char *adr; } Descr;

main (argc, argv)
     int argc;
     char *argv[];
{
  int i;
  int len = 0;
  char *buff;
  Descr cmd;
  char *chopspec;
  char *path_val = TO_NORMAL_FILE_SPEC (getenv ("VAXC$PATH"));
  char *apath_val = alloca (strlen (path_val) + 1);

  strcpy (apath_val, path_val);

  chopspec = TO_HOST_FILE_SPEC (locate_regular_file
				("gnatchop.com", apath_val));

  /* 
   * Figure out how many bytes of commands and args.
   */

  len = strlen (chopspec) + 1;
  for (i=1; i<argc; i++)
    len = len + strlen (argv [i]) + 1;

  buff = (char *) malloc (len);

  /* 
   * Command procedures must start with @.
   */

  buff [0] = '@';

  /* 
   * We know that exec() puts the directory we are in and all that good
   * stuff in argv[0].
   */

  strcpy (&buff [1], chopspec);

  /*
   * Find the switches and put them first since that is what gnatchop.com
   * expects, and not what gnatcmd does.
   */

  for (i=1; i<argc; i++)
    if (argv[i][0] == '-')
      {
	strcat (buff, " ");
	strcat (buff, argv[i]);
      }

  /* 
   * Put file and directory names last.
   */

  for (i=1; i<argc; i++)
    if (argv[i][0] != '-')
      {
	strcat (buff, " ");
	strcat (buff, argv[i]);
      }

  /*
   * Build a proper descriptor for lib$spawn.
   */

  len = strlen (buff);

  buff [len] = '\0';

  cmd.adr = buff;
  cmd.len = len;
  cmd.mbz = 0;

  i = lib$spawn (&cmd);

  /*
   * Die with a traceback if something went wrong.
   */

  if ((i & 1) != 1)
    lib$stop ();

  exit (0);

}
