------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                 S Y S T E M . T I M E _ O P E R A T I O N S              --
--                                                                          --
--                                  B o d y                                 --
--                         (Version for new GNARL)                          --
--                                                                          --
--                             $Revision: 1.5 $                             --
--                                                                          --
--             Copyright (C) 1991-1997, Florida State University            --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNARL was developed by the GNARL team at Florida State University. It is --
-- now maintained by Ada Core Technologies Inc. in cooperation with Florida --
-- State University (http://www.gnat.com).                                  --
--                                                                          --
------------------------------------------------------------------------------

--  This is a HP-UX version of this package.

with System.Error_Reporting;
--  used for Shutdown

with System.OS_Interface;

with Interfaces.C;

with System.Task_Primitives.Operations;
--  used for Clock
--           Task_ID
--           Self

package body System.Time_Operations is

   use System.Error_Reporting;
   use System.OS_Interface;
   use Interfaces.C;
   use System.Task_Primitives.Operations;

   --  For abortion safety, we need to
   --  implement these using cond_timedwait. Use the service provided by
   --  System.Task_Primitives.Operations.

   type Delay_Mode is (Relative, Absolute_RT, Absolute_Calendar);

   procedure Timed_Delay
     (Self_ID  : Task_ID;
      Time     : Duration;
      Mode     : Delay_Mode);

   pragma Import (C, Timed_Delay, "__timed_delay");

   --  Timed_Delay is declared in 5htaprop.adb, so we cannot call this
   --  directly, and we don't want to change the file 7staprop.ads because
   --  this change is an intermediate version before the nevised tasking
   --  run time.  That's why we use pragma Import to declare this procedure.

   -----------------
   -- Delay_Until --
   -----------------

   procedure Delay_Until (Abs_Time : Duration) is
   begin
      Timed_Delay (Self, Abs_Time, Absolute_Calendar);
   end Delay_Until;

   ---------------
   -- Delay_For --
   ---------------

   procedure Delay_For (Rel_Time : Duration) is
   begin
      Timed_Delay (Self, Rel_Time, Relative);
   end Delay_For;

end System.Time_Operations;
