// $Id: toolbar.cc,v 1.7 1998/09/24 13:19:50 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"

void Gtk_Toolbar::Include(File &f,const Widget &w)
{  f.include("gtk--/toolbar.h");
   Gtk_Container::Include(f,w);
}

void Gtk_Toolbar::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,"Gtk_Toolbar");
}

void Gtk_Toolbar::Derive(File &f,const Widget &w)
{  f << "Gtk_Toolbar";
}

void Gtk_Toolbar::Construct(File &f,const Widget &w,bool is_member)
{  string orientation=w.getString("orientation","GTK_ORIENTATION_HORIZONTAL");
   string style=w.getString("type","GTK_TOOLBAR_BOTH");
   
   f << StandardWriter::ConstructName(f,w,is_member,"Gtk_Toolbar");
   f << "(" << orientation << ", " << style << ")";
}

bool Gtk_Toolbar::NeedConstruct(const Widget &w,bool is_member)
{  return true;
}

void Gtk_Toolbar::Customize(File &f,const Widget &w,const string instance)
{  Gtk_Container::Customize(f,w,instance);
   // space_size
   // tooltips
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  // const Widget ch=(*i).get_Child_params();
      f << instance << "append_widget(" << f.Pointer(*i) << ");\n\t";
   }
}

bool Gtk_Toolbar::SampleCode(File &f,const Widget &w,enum WriterType::CodePosition pos,const string misc)
{  switch(pos)
   {  case WriterType::ContainingConstructor: // see optionmenu?
#warning SampleCode   
         {  //f << "\t" << f.InstanceName(w.Name()) << (w.isPointer() ? "->" : "." )
            //  << "update(33.3);\n";
   	 }
   	 break;
      default: break;
   }
   return false;
}
