// $Id: text.cc,v 1.5 1998/10/07 14:37:51 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"

void Gtk_Text::Include(File &f,const Widget &w)
{  f.include("gtk--/text.h");
}

void Gtk_Text::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,"Gtk_Text");
}

void Gtk_Text::Construct(File &f,const Widget &w,bool is_member)
{  f << StandardWriter::ConstructName(f,w,is_member,"Gtk_Text");
   f << "(0, 0)";
}

bool Gtk_Text::NeedConstruct(const Widget &w,bool is_member)
{  return true;
}

void Gtk_Text::Customize(File &f,const Widget &w,const string instance)
{  Gtk_Widget::Customize(f,w,instance);
   bool editable=w.getBool("editable",false);
   f << instance << "set_editable(" << (editable?"true":"false") << ");\n\t";
   bool word_wrap=w.getBool("word_wrap",false);
   f << instance << "set_word_wrap(" << (word_wrap?"true":"false") << ");\n\t";
   int point(w.getInt("point",0));
   f << instance << "set_point(" << point << ");\n\t";
   string text(w.getString("text",""));
//   if (text.size())
//      f << instance << "insert(0,0,0, \"" << f.CString(text) << "\", -1);\n\t";
}
