// $Id: table.cc,v 1.16 1998/09/24 13:19:49 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"

void Gtk_Table::Include(File &f,const Widget &w)
{  f.include("gtk--/table.h");
   Gtk_Container::Include(f,w);
}

void Gtk_Table::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,"Gtk_Table");
}

void Gtk_Table::Derive(File &f,const Widget &w)
{  f << "Gtk_Table";
}

void Gtk_Table::Construct(File &f,const Widget &w,bool is_member)
{  bool homogeneous=w.getBool("homogeneous",true);
   int rows=w.getInt("rows",2);
   int columns=w.getInt("columns",2);
   
   f << StandardWriter::ConstructName(f,w,is_member,"Gtk_Table");
   f << "(" << rows << ", " << columns << ", " 
     << (homogeneous?"true":"false") << ")";
}

bool Gtk_Table::NeedConstruct(const Widget &w,bool is_member)
{  return true;
}

void Gtk_Table::Customize(File &f,const Widget &w,const string instance)
{  Gtk_Container::Customize(f,w,instance);
   for (Widget::const_iterator i=w.begin();i!=w.end();++i)
   {  const Widget ch=(*i).get_Child_params();
      int left_attach=ch.getInt("left_attach",-1);
      int right_attach=ch.getInt("right_attach",-1);
      int top_attach=ch.getInt("top_attach",-1);
      int bottom_attach=ch.getInt("bottom_attach",-1);
      string xoptions("0"),yoptions("0");
      if (ch.getBool("xexpand",true)) xoptions+="|GTK_EXPAND";
      if (ch.getBool("xshrink",false)) xoptions+="|GTK_SHRINK";
      if (ch.getBool("xfill",true)) xoptions+="|GTK_FILL";
      if (ch.getBool("yexpand",true)) yoptions+="|GTK_EXPAND";
      if (ch.getBool("yshrink",false)) yoptions+="|GTK_SHRINK";
      if (ch.getBool("yfill",true)) yoptions+="|GTK_FILL";
      int xpad=ch.getInt("xpad",0);
      int ypad=ch.getInt("ypad",0);
      
      if (xoptions.size()>1) xoptions=string(xoptions.begin()+2,xoptions.end());
      if (yoptions.size()>1) yoptions=string(yoptions.begin()+2,yoptions.end());
      if (xoptions=="GTK_FILL|GTK_EXPAND" 
          && yoptions=="GTK_FILL|GTK_EXPAND" && !xpad && !ypad)
         f << instance << "attach_defaults(" << f.Pointer(*i) << ", "
      	   << left_attach << ", " << right_attach << ", " << top_attach << ", " 
      	   << bottom_attach << ");\n\t";
      else
         f << instance << "attach(" << f.Pointer(*i) << ", "
      	   << left_attach << ", " << right_attach << ", " << top_attach << ", " 
      	   << bottom_attach << ", " << xoptions << ", " << yoptions << ", "
      	   << xpad << ", " << ypad << ");\n\t";
   }
}
