// $Id: scale.cc,v 1.3 1998/09/24 13:19:48 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"

void Gtk_Scale::Include(File &f,const Widget &w)
{  f.include("gtk--/scale.h");
}

void Gtk_Scale::DeclareNeeded(File &f,const Widget &w)
{  Gtk_Adjustment::Declare(f,Widget(w,f.InstanceName(w.Name())+"_adj"));
}

void Gtk_Scale::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,w.Class()[3]=='H' ?"Gtk_HScale":"Gtk_VScale");
}

void Gtk_Scale::Construct(File &f,const Widget &w,bool is_member)
{  const Widget adj(w,f.InstanceName(w.Name())+"_adj");
      
   if (is_member)
   {  Gtk_Adjustment::Construct(f,adj,true);
      f << ", "
        << StandardWriter::ConstructName(f,w,is_member,w.Class()[3]=='H' ?"Gtk_HScale":"Gtk_VScale")
        << "(&" << (f.InstanceName(w.Name())+"_adj") << ")";
   }
   else
   {  f << StandardWriter::ConstructName(f,w,is_member,"Gtk_Scale")
        << "(0), ";
      cerr << "Gtk_Scale::Construct: not member, you will run into trouble\n";
      Gtk_Adjustment::Construct(f,adj,true);
   }
}

void Gtk_Scale::ConstructPointer(File &f,const Widget &w)
{  Gtk_Adjustment::ConstructPointer(f,Widget(w,f.InstanceName(w.Name())+"_adj"));
   f << ";\n\t" << f.InstanceName(w.Name()) << " = new " 
     << (w.Class()[3]=='H' ?"Gtk_HScale":"Gtk_VScale")
     << "(" << (f.InstanceName(w.Name())+"_adj") << ")";
}

void Gtk_Scale::DestructPointer(File &f,const Widget &w)
{  f << "\tdelete " << f.InstanceName(w.Name()) << ";\n";
   Gtk_Adjustment::DestructPointer(f,Widget(w,f.InstanceName(w.Name())+"_adj"));
}

bool Gtk_Scale::NeedConstruct(const Widget &w,bool is_member)
{  return true;
}

void Gtk_Scale::Customize(File &f,const Widget &w,const string instance)
{  Gtk_Range::Customize(f,w,instance);
   int digits=w.getInt("digits",0);
   f << instance << "set_digits(" << digits << ");\n\t";
   bool draw_value=w.getInt("draw_value",true);
   f << instance << "set_draw_value(" << (draw_value?"true":"false") << ");\n\t";
   string value_pos=w.getString("value_pos","GTK_POS_TOP");
   f << instance << "set_value_pos(" << value_pos << ");\n\t";
   // can focus
}
