// $Id: combo.cc,v 1.8 1998/09/24 13:19:44 cvs_christof Exp $
/*  glade--: C++ frontend for glade (Gtk+ User Interface Builder)
 *  Copyright (C) 1998  Christof Petig
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "writers.hh"

void Gtk_Combo::Include(File &f,const Widget &w)
{  f.include("gtk--/combo.h");
}

void Gtk_Combo::Declare(File &f,const Widget &w)
{  StandardWriter::Declare(f,w,"Gtk_Combo");
}

void Gtk_Combo::Construct(File &f,const Widget &w,bool is_member)
{  f << StandardWriter::ConstructName(f,w,is_member,"Gtk_Combo");
   f << "()";
}

bool Gtk_Combo::NeedConstruct(const Widget &w,bool is_member)
{  return false;
}

void Gtk_Combo::Customize(File &f,const Widget &w,const string instance)
{  Gtk_Widget::Customize(f,w,instance);
   // hmm perhaps call HBox Customize ??? since Combo is a HBox descendant
   bool case_sensitive=w.getBool("case_sensitive",true);
   if (!case_sensitive)
      f << instance << "set_case_sensitive(" << (case_sensitive?"true":"false")
        << ");\n\t";
   bool use_arrows=w.getBool("use_arrows",true);
   if (!use_arrows)
      f << instance << "set_use_arrows(" << (use_arrows?"true":"false")
        << ");\n\t";
   bool use_arrows_always=w.getBool("use_arrows_always",false);
   if (use_arrows_always)
      f << instance << "set_use_arrows_always(" << (use_arrows_always?"true":"false")
        << ");\n\t";
        
   // items
}

bool Gtk_Combo::SampleCode(File &f,const Widget &w,enum WriterType::CodePosition pos,const string misc)
{  switch(pos)
   {  case WriterType::ContainingConstructor:
         {  f << "\t{\tGList *gl=0;\n"
              << "\t\tgl=g_list_append(gl,(void*)\"two\");\n"
              << "\t\tgl=g_list_append(gl,(void*)\"four\");\n"
              << "\t\tgl=g_list_append(gl,(void*)\"eight\");\n"
              << "\t\t" 
              << f.InstanceName(w.Name()) << (w.isPointer() ? "->" : "." ) 
              << "set_popdown_strings(gl);\n"
              << "\t\tg_list_free(gl);\n"
              << "\t\t"
              << f.InstanceName(w.Name()) << (w.isPointer() ? "->" : "." )
              << "entry.set_text(\"one\");\n"
              << "\t}\n";
   	 }
   	 break;
      default: break;
   }
   return false;
}
